/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.exceptions.ExtendedConfigurationException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.MultipleType;
import oracle.oc4j.admin.deploy.spi.xml.ServletChainingTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.ServletChainingType;

public class ServletChainingsTreeNode
extends ConfigTreeNode
implements ActionListener {
    private ConfigBeanNode _parentBean;
    private static final String ADD_SERVLET_CHAINING_MENU_STRING = "Add Servlet Chaining";
    private JMenuItem _addServletChainingMenuItem;
    private ServletChainingType[] servletChainingType = new ServletChainingType[0];
    private Method _readMethod = null;
    private Method _addMethod = null;
    private Method _removeMethod = null;

    public ServletChainingsTreeNode(ConfigTreeNode rootNode, MultipleType servletChaining) {
        super(servletChaining);
        this.setRootNode(rootNode);
        this._parentBean = servletChaining.getConfigParent();
        this._addServletChainingMenuItem = new JMenuItem(ADD_SERVLET_CHAINING_MENU_STRING);
        this._addServletChainingMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addServletChainingMenuItem.setFont(ServletChainingsTreeNode.getFont());
        this._addServletChainingMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addServletChainingMenuItem);
        Class<?> beanClass = this._parentBean.getClass();
        try {
            this._readMethod = beanClass.getMethod("getServletChaining", null);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
        try {
            this._addMethod = beanClass.getMethod("addServletChaining", ServletChainingType.class);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
        try {
            this._removeMethod = beanClass.getMethod("removeServletChaining", ServletChainingType.class);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public String viewHeaderString() {
        return "Servlet Chainings";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        try {
            ServletChainingType[] servletChainings = (ServletChainingType[])this._readMethod.invoke((Object)this._parentBean, null);
            if (servletChainings != null) {
                for (int i = 0; i < servletChainings.length; ++i) {
                    ServletChainingType servletChaining = servletChainings[i];
                    if (servletChaining == null) continue;
                    ServletChainingTreeNode servletChainingTreeNode = new ServletChainingTreeNode(this.getRootNode(), servletChaining);
                    this.addChild(servletChainingTreeNode);
                }
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            ServletChainingType newServletChaining;
            if (event.getActionCommand().equals(ADD_SERVLET_CHAINING_MENU_STRING) && this.showAddDialog(newServletChaining = new ServletChainingType(this._parentBean), ADD_SERVLET_CHAINING_MENU_STRING)) {
                this._addMethod.invoke((Object)this._parentBean, newServletChaining);
                ServletChainingTreeNode newNode = new ServletChainingTreeNode(this, newServletChaining);
                this.insertNode(newNode);
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof ServletChainingTreeNode) {
            try {
                ServletChainingType servletChaining = (ServletChainingType)node.getConfigBeanNode();
                this._removeMethod.invoke((Object)this._parentBean, servletChaining);
                this.removeNode(node);
            }
            catch (Throwable t) {
                throw new ExtendedConfigurationException(t);
            }
        }
    }
}

