/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import java.util.Vector;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.PropertyConfigBean;
import oracle.oc4j.admin.deploy.spi.xml.SignElementsConfigType;
import oracle.oc4j.admin.deploy.spi.xml.SignatureMethodConfigType;
import oracle.oc4j.admin.deploy.spi.xml.TimestampConfigType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SignatureConfigType
extends ConfigBeanNode {
    SignatureMethodConfigType _signatureMethod = null;
    SignElementsConfigType _tbsElements = null;
    TimestampConfigType _addTimestamp = null;
    PropertyConfigBean[] _properties = null;

    public SignatureConfigType(ConfigBeanNode parent) throws ConfigurationException {
        this(parent, null);
    }

    public SignatureConfigType(ConfigBeanNode parent, Node node) throws ConfigurationException {
        super(null, parent, node);
        this.init();
    }

    public void setSignatureMethod(SignatureMethodConfigType signatureMethod) throws ConfigurationException {
        SignatureMethodConfigType oldValue = this._signatureMethod;
        this._signatureMethod = signatureMethod;
        this.firePropertyChange("signatureMethod", oldValue, this._signatureMethod);
    }

    public SignatureMethodConfigType getSignatureMethod() {
        return this._signatureMethod;
    }

    public SignatureMethodConfigType defaultSignatureMethod() throws ConfigurationException {
        return new SignatureMethodConfigType(this);
    }

    public void addSignatureMethod() throws ConfigurationException {
        if (this._signatureMethod != null) {
            return;
        }
        SignatureMethodConfigType signatureMethod = new SignatureMethodConfigType(this, null);
        this.setSignatureMethod(signatureMethod);
    }

    public void removeSignatureMethod() throws ConfigurationException {
        if (this._signatureMethod == null) {
            return;
        }
        this.setSignatureMethod(null);
    }

    public void setTbsElements(SignElementsConfigType tbsElements) throws ConfigurationException {
        SignElementsConfigType oldValue = this._tbsElements;
        this._tbsElements = tbsElements;
        this.firePropertyChange("tbsElements", oldValue, this._tbsElements);
    }

    public SignElementsConfigType getTbsElements() {
        return this._tbsElements;
    }

    public SignElementsConfigType defaultTbsElements() {
        try {
            return new SignElementsConfigType(this, null);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void addTbsElements() throws ConfigurationException {
        if (this._tbsElements != null) {
            return;
        }
        SignElementsConfigType tbsElements = new SignElementsConfigType(this, null);
        this.setTbsElements(tbsElements);
    }

    public void removeTbsElements() throws ConfigurationException {
        if (this._tbsElements == null) {
            return;
        }
        this.setTbsElements(null);
    }

    public void setAddTimestamp(TimestampConfigType addTimestamp) throws ConfigurationException {
        TimestampConfigType oldValue = this._addTimestamp;
        this._addTimestamp = addTimestamp;
        this.firePropertyChange("addTimestamp", oldValue, this._addTimestamp);
    }

    public TimestampConfigType getAddTimestamp() {
        return this._addTimestamp;
    }

    public TimestampConfigType defaultAddTimestamp() throws ConfigurationException {
        try {
            return new TimestampConfigType(this, "add-timestamp", null);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void addAddTimestamp() throws ConfigurationException {
        if (this._addTimestamp != null) {
            return;
        }
        TimestampConfigType addTimestamp = new TimestampConfigType(this, "add-timestamp", null);
        this.setAddTimestamp(addTimestamp);
    }

    public void removeAddTimestamp() throws ConfigurationException {
        if (this._addTimestamp == null) {
            return;
        }
        this.setAddTimestamp(null);
    }

    public void setProperties(PropertyConfigBean[] properties) throws ConfigurationException {
        PropertyConfigBean[] oldValue = this._properties;
        this._properties = properties;
        this.firePropertyChange("properties", oldValue, this._properties);
    }

    public PropertyConfigBean[] getProperties() {
        return this._properties;
    }

    public PropertyConfigBean[] defaultProperties() {
        return new PropertyConfigBean[0];
    }

    public void addProperties() throws ConfigurationException {
        if (this._properties != null) {
            return;
        }
        PropertyConfigBean[] properties = new PropertyConfigBean[]{new PropertyConfigBean(this, null)};
        this.setProperties(properties);
    }

    public void removeProperties() throws ConfigurationException {
        if (this._properties == null) {
            return;
        }
        this.setProperties(null);
    }

    public void addProperty(PropertyConfigBean property) throws ConfigurationException {
        property.setParent(this);
        int existingPropertiesCnt = 0;
        if (this._properties != null) {
            existingPropertiesCnt = this._properties.length;
        }
        PropertyConfigBean[] newProperties = new PropertyConfigBean[existingPropertiesCnt + 1];
        for (int n = 0; n < existingPropertiesCnt; ++n) {
            newProperties[n] = this._properties[n];
        }
        newProperties[existingPropertiesCnt] = property;
        PropertyConfigBean[] oldValue = this._properties;
        this._properties = newProperties;
        this.firePropertyChange("properties", oldValue, this._properties);
    }

    public void removeProperty(PropertyConfigBean property) throws ConfigurationException {
        int existingPropertiesCnt = 0;
        if (this._properties != null) {
            existingPropertiesCnt = this._properties.length;
        }
        PropertyConfigBean[] newProperties = new PropertyConfigBean[existingPropertiesCnt - 1];
        int newIndex = 0;
        for (int n = 0; n < existingPropertiesCnt; ++n) {
            if (property.equals(this._properties[n])) continue;
            newProperties[newIndex++] = this._properties[n];
        }
        if (newProperties.length == 0) {
            newProperties = null;
        }
        PropertyConfigBean[] oldValue = this._properties;
        this._properties = newProperties;
        this.firePropertyChange("properties", oldValue, this._properties);
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagAttributeStart(out, indentation, "signature");
        XMLUtils.writeTagAttributeEnd(out, indentation, "signature");
        if (this._signatureMethod != null) {
            this._signatureMethod.writeXML(out, indentation + "\t");
        }
        if (this._tbsElements != null) {
            this._tbsElements.writeXML(out, indentation + "\t");
        }
        if (this._addTimestamp != null) {
            this._addTimestamp.writeXML(out, indentation + "\t");
        }
        SignatureConfigType.writeXML(out, indentation + "\t", this._properties);
        XMLUtils.writeTagEnd(out, indentation, "signature");
    }

    private void init() throws ConfigurationException {
        this.setXpath("signature");
        Vector<PropertyConfigBean> properties = new Vector<PropertyConfigBean>();
        if (this.getNode() != null) {
            Object val = null;
            Node node = this.getNode();
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                String name = node.getNodeName();
                if (name.equals("signature-method")) {
                    this.setSignatureMethod(new SignatureMethodConfigType(this, node));
                    continue;
                }
                if (name.equals("tbs-elements")) {
                    this.setTbsElements(new SignElementsConfigType(this, node));
                    continue;
                }
                if (name.equals("add-timestamp")) {
                    TimestampConfigType addTimestamp = new TimestampConfigType(this, "add-timestamp", node);
                    this.setAddTimestamp(addTimestamp);
                    continue;
                }
                if (!name.equals("property")) continue;
                PropertyConfigBean configBean = new PropertyConfigBean(this, node);
                properties.add(configBean);
            }
        }
        if (properties.size() > 0) {
            this.setProperties(properties.toArray(new PropertyConfigBean[0]));
        }
    }
}

