/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Set;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.StringTypeBase;
import oracle.oc4j.admin.deploy.spi.xml.UserType;
import oracle.oc4j.admin.management.shared.User;

public class UserNameType
extends StringTypeBase {
    protected String _description = null;
    private Set _users = null;

    public UserNameType() {
        this((ConfigBeanNode)null);
    }

    public UserNameType(ConfigBeanNode parent) {
        super(parent);
        this._validateToTags = false;
        this.setValue("");
    }

    public String[] getTags() {
        this._users = this.determineRoot().getUsers();
        if (this._users != null) {
            String[] newTags = new String[this._users.size()];
            Iterator it = this._users.iterator();
            for (int n = 0; n < this._users.size(); ++n) {
                User user = (User)it.next();
                newTags[n] = user.getName();
            }
            super.setTags(newTags);
        }
        return super.getTags();
    }

    public void setValue(String value) {
        super.setValue(value);
        if (this._users == null) {
            return;
        }
        Iterator it = this._users.iterator();
        for (int n = 0; n < this._users.size(); ++n) {
            User user = (User)it.next();
            if (!user.getName().equals(value)) continue;
            this._description = user.getDescription();
            if (this._description == null) {
                this._description = "";
            }
            ((UserType)this.getConfigParent()).setName(this);
            break;
        }
    }

    public String getDescription() {
        return this._description;
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        if (this.getValue() == null || this.getValue().length() == 0) {
            return;
        }
        XMLUtils.writeAttribute(out, indentation, "name", this.getValue());
    }

    public String toString() {
        return this.getValue();
    }
}

