/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.model.xml.WarModuleBean;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.xml.AccessMaskTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.AccessMaskType;
import oracle.oc4j.admin.deploy.spi.xml.ClasspathsTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.ExpirationSettingsTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.JaznWebAppTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.JaznWebAppType;
import oracle.oc4j.admin.deploy.spi.xml.MimeMappingsTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.MultipleType;
import oracle.oc4j.admin.deploy.spi.xml.OjspInitTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.OjspInitType;
import oracle.oc4j.admin.deploy.spi.xml.RequestTrackersTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.ServletChainingsTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.SessionTrackingTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.SessionTrackingType;
import oracle.oc4j.admin.deploy.spi.xml.VirtualDirectoriesTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.WarModuleConfigBean;
import oracle.oc4j.admin.deploy.spi.xml.WebAppClassLoaderTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.WebAppClassLoaderType;
import oracle.oc4j.admin.deploy.spi.xml.WebSiteBindingsTreeNode;

public class WebModuleMappingsTreeNode
extends ConfigTreeNode
implements ActionListener {
    private WarModuleConfigBean _bean;
    private static final String ADD_ACCESS_MASK_MENU_STRING = "Add Access Mask";
    private static final String ADD_JAZN_WEB_APP_MENU_STRING = "Add Jazn Web App";
    private static final String ADD_WEB_APP_CLASS_LOADER_MENU_STRING = "Add Web App Class Loader";
    private static final String ADD_SESSION_TRACKING_MENU_STRING = "Add Session Tracking";
    private static final String ADD_OJSP_INIT_MENU_STRING = "Add Ojsp Init";
    private JMenuItem _addAccessMaskMenuItem;
    private JMenuItem _addJaznWebAppMenuItem;
    private JMenuItem _addSessionTrackingMenuItem;
    private JMenuItem _addWebAppClassLoaderMenuItem;
    private JMenuItem _addOjspInitMenuItem;

    public WebModuleMappingsTreeNode(ConfigBeanNode bean) {
        super(bean);
        this.setRootNode(this);
        this._bean = (WarModuleConfigBean)bean;
        this._addAccessMaskMenuItem = new JMenuItem(ADD_ACCESS_MASK_MENU_STRING);
        this._addAccessMaskMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addAccessMaskMenuItem.setFont(WebModuleMappingsTreeNode.getFont());
        this._addAccessMaskMenuItem.addActionListener(this);
        if (this._bean.getAccessMask() != null) {
            this._addAccessMaskMenuItem.setEnabled(false);
        }
        this._addJaznWebAppMenuItem = new JMenuItem(ADD_JAZN_WEB_APP_MENU_STRING);
        this._addJaznWebAppMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addJaznWebAppMenuItem.setFont(WebModuleMappingsTreeNode.getFont());
        this._addJaznWebAppMenuItem.addActionListener(this);
        if (this._bean.getJaznWebApp() != null) {
            this._addJaznWebAppMenuItem.setEnabled(false);
        }
        this._addSessionTrackingMenuItem = new JMenuItem(ADD_SESSION_TRACKING_MENU_STRING);
        this._addSessionTrackingMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addSessionTrackingMenuItem.setFont(WebModuleMappingsTreeNode.getFont());
        this._addSessionTrackingMenuItem.addActionListener(this);
        if (this._bean.getSessionTracking() != null) {
            this._addSessionTrackingMenuItem.setEnabled(false);
        }
        this._addWebAppClassLoaderMenuItem = new JMenuItem(ADD_WEB_APP_CLASS_LOADER_MENU_STRING);
        this._addWebAppClassLoaderMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addWebAppClassLoaderMenuItem.setFont(WebModuleMappingsTreeNode.getFont());
        this._addWebAppClassLoaderMenuItem.addActionListener(this);
        if (this._bean.getWebAppClassLoader() != null) {
            this._addWebAppClassLoaderMenuItem.setEnabled(false);
        }
        this._addOjspInitMenuItem = new JMenuItem(ADD_OJSP_INIT_MENU_STRING);
        this._addOjspInitMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addOjspInitMenuItem.setFont(WebModuleMappingsTreeNode.getFont());
        this._addOjspInitMenuItem.addActionListener(this);
        if (this._bean.getOjspInit() != null) {
            this._addOjspInitMenuItem.setEnabled(false);
        }
        this._popup = new JPopupMenu();
        this._popup.add(this._addAccessMaskMenuItem);
        this._popup.add(this._addJaznWebAppMenuItem);
        this._popup.add(this._addSessionTrackingMenuItem);
        this._popup.add(this._addWebAppClassLoaderMenuItem);
        this._popup.add(this._addOjspInitMenuItem);
    }

    public String viewHeaderString() {
        return "Web Module Mappings";
    }

    public String toString() {
        return ((WarModuleBean)this._bean.getDDBean()).getDisplayName();
    }

    protected void buildChildJTree() {
        Method xmlMethod;
        Method xmlMethod2;
        Method xmlMethod3;
        AccessMaskType accessMask = this._bean.getAccessMask();
        if (accessMask != null) {
            AccessMaskTreeNode accessMaskTreeNode = new AccessMaskTreeNode(this.getRootNode(), accessMask);
            this.addChild(accessMaskTreeNode);
        }
        try {
            xmlMethod3 = WarModuleConfigBean.class.getMethod("writeClasspathsXML", PrintWriter.class, String.class);
            ClasspathsTreeNode classpathsTreeNode = new ClasspathsTreeNode(this.getRootNode(), new MultipleType(this._bean, xmlMethod3));
            this.addChild(classpathsTreeNode);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
        try {
            xmlMethod3 = WarModuleConfigBean.class.getMethod("writeExpirationSettingsXML", PrintWriter.class, String.class);
            ExpirationSettingsTreeNode expirationSettingsTreeNode = new ExpirationSettingsTreeNode(this.getRootNode(), new MultipleType(this._bean, xmlMethod3));
            this.addChild(expirationSettingsTreeNode);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
        JaznWebAppType jaznWebApp = this._bean.getJaznWebApp();
        if (jaznWebApp != null) {
            JaznWebAppTreeNode jaznWebAppTreeNode = new JaznWebAppTreeNode(this.getRootNode(), jaznWebApp);
            this.addChild(jaznWebAppTreeNode);
        }
        try {
            xmlMethod2 = WarModuleConfigBean.class.getMethod("writeMimeMappingsXML", PrintWriter.class, String.class);
            MimeMappingsTreeNode mimeMappingsTreeNode = new MimeMappingsTreeNode(this.getRootNode(), new MultipleType(this._bean, xmlMethod2));
            this.addChild(mimeMappingsTreeNode);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
        try {
            xmlMethod2 = WarModuleConfigBean.class.getMethod("writeRequestTrackersXML", PrintWriter.class, String.class);
            RequestTrackersTreeNode requestTrackersTreeNode = new RequestTrackersTreeNode(this.getRootNode(), new MultipleType(this._bean, xmlMethod2));
            this.addChild(requestTrackersTreeNode);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
        SessionTrackingType sessionTracking = this._bean.getSessionTracking();
        if (sessionTracking != null) {
            SessionTrackingTreeNode sessionTrackingTreeNode = new SessionTrackingTreeNode(this.getRootNode(), sessionTracking);
            this.addChild(sessionTrackingTreeNode);
        }
        try {
            xmlMethod = WarModuleConfigBean.class.getMethod("writeServletChainingXML", PrintWriter.class, String.class);
            ServletChainingsTreeNode servletChainingsTreeNode = new ServletChainingsTreeNode(this.getRootNode(), new MultipleType(this._bean, xmlMethod));
            this.addChild(servletChainingsTreeNode);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
        try {
            xmlMethod = WarModuleConfigBean.class.getMethod("writeVirtualDirectoriesXML", PrintWriter.class, String.class);
            VirtualDirectoriesTreeNode virtualDirectoriesTreeNode = new VirtualDirectoriesTreeNode(this.getRootNode(), new MultipleType(this._bean, xmlMethod));
            this.addChild(virtualDirectoriesTreeNode);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
        WebAppClassLoaderType webAppClassLoader = this._bean.getWebAppClassLoader();
        if (webAppClassLoader != null) {
            WebAppClassLoaderTreeNode webAppClassLoaderTreeNode = new WebAppClassLoaderTreeNode(this.getRootNode(), webAppClassLoader);
            this.addChild(webAppClassLoaderTreeNode);
        }
        try {
            Method xmlMethod4 = WarModuleConfigBean.class.getMethod("writeWebSiteBindingsXML", PrintWriter.class, String.class);
            WebSiteBindingsTreeNode webSiteBindingsTreeNode = new WebSiteBindingsTreeNode(this.getRootNode(), new MultipleType(this._bean, xmlMethod4));
            this.addChild(webSiteBindingsTreeNode);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
        OjspInitType ojspInit = this._bean.getOjspInit();
        if (ojspInit != null) {
            OjspInitTreeNode ojspInitTreeNode = new OjspInitTreeNode(this.getRootNode(), ojspInit);
            this.addChild(ojspInitTreeNode);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            OjspInitType newOjspInit;
            if (event.getActionCommand().equals(ADD_ACCESS_MASK_MENU_STRING)) {
                AccessMaskType newAccessMask = this._bean.defaultAccessMask();
                if (this.showAddDialog(newAccessMask, ADD_ACCESS_MASK_MENU_STRING)) {
                    this._bean.setAccessMask(newAccessMask);
                    AccessMaskTreeNode newNode = new AccessMaskTreeNode(this, newAccessMask);
                    this.insertNode(newNode);
                    this._addAccessMaskMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(ADD_JAZN_WEB_APP_MENU_STRING)) {
                JaznWebAppType newJaznWebApp = this._bean.defaultJaznWebApp();
                if (this.showAddDialog(newJaznWebApp, ADD_JAZN_WEB_APP_MENU_STRING)) {
                    this._bean.setJaznWebApp(newJaznWebApp);
                    JaznWebAppTreeNode newNode = new JaznWebAppTreeNode(this, newJaznWebApp);
                    this.insertNode(newNode);
                    this._addJaznWebAppMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(ADD_SESSION_TRACKING_MENU_STRING)) {
                SessionTrackingType newSessionTracking = this._bean.defaultSessionTracking();
                if (this.showAddDialog(newSessionTracking, ADD_SESSION_TRACKING_MENU_STRING)) {
                    this._bean.setSessionTracking(newSessionTracking);
                    SessionTrackingTreeNode newNode = new SessionTrackingTreeNode(this, newSessionTracking);
                    this.insertNode(newNode);
                    this._addSessionTrackingMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(ADD_WEB_APP_CLASS_LOADER_MENU_STRING)) {
                WebAppClassLoaderType newWebAppClassLoader = this._bean.defaultWebAppClassLoader();
                if (this.showAddDialog(newWebAppClassLoader, ADD_WEB_APP_CLASS_LOADER_MENU_STRING)) {
                    this._bean.setWebAppClassLoader(newWebAppClassLoader);
                    WebAppClassLoaderTreeNode newNode = new WebAppClassLoaderTreeNode(this, newWebAppClassLoader);
                    this.insertNode(newNode);
                    this._addWebAppClassLoaderMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(ADD_OJSP_INIT_MENU_STRING) && this.showAddDialog(newOjspInit = this._bean.defaultOjspInit(), ADD_OJSP_INIT_MENU_STRING)) {
                this._bean.setOjspInit(newOjspInit);
                OjspInitTreeNode newNode = new OjspInitTreeNode(this, newOjspInit);
                this.insertNode(newNode);
                this._addOjspInitMenuItem.setEnabled(false);
            }
        }
        catch (Throwable ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof AccessMaskTreeNode) {
            this._bean.removeAccessMask();
            this.removeNode(node);
            this._addAccessMaskMenuItem.setEnabled(true);
        } else if (node instanceof JaznWebAppTreeNode) {
            this._bean.removeJaznWebApp();
            this.removeNode(node);
            this._addJaznWebAppMenuItem.setEnabled(true);
        } else if (node instanceof SessionTrackingTreeNode) {
            this._bean.removeSessionTracking();
            this.removeNode(node);
            this._addSessionTrackingMenuItem.setEnabled(true);
        } else if (node instanceof WebAppClassLoaderTreeNode) {
            this._bean.removeWebAppClassLoader();
            this.removeNode(node);
            this._addWebAppClassLoaderMenuItem.setEnabled(true);
        } else if (node instanceof OjspInitTreeNode) {
            this._bean.removeOjspInit();
            this.removeNode(node);
            this._addOjspInitMenuItem.setEnabled(true);
        }
    }
}

