/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.model.xml.WebServicesBean;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.EjbTransportLoginConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.EjbTransportLoginConfigType;
import oracle.oc4j.admin.deploy.spi.xml.MultipleType;
import oracle.oc4j.admin.deploy.spi.xml.ProviderDescriptionsTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.WebServicesConfigBean;
import oracle.oc4j.admin.deploy.spi.xml.WebSiteEndpointTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.WebSiteEndpointType;

public class WebServicesTreeNode
extends ConfigTreeNode
implements ActionListener {
    private WebServicesConfigBean _bean;
    private static final String ADD_EJB_TRANSPORT_LOGIN_CONFIG_MENU_STRING = "Add Ejb Transport Login Config";
    private JMenuItem _addEjbTransportLoginConfigMenuItem;
    private static final String ADD_WEB_SITE_MENU_STRING = "Add Web Site";
    private JMenuItem _addWebSiteMenuItem;

    public WebServicesTreeNode(ConfigBeanNode bean) {
        super(bean);
        this.setRootNode(this);
        this._bean = (WebServicesConfigBean)bean;
        this._addEjbTransportLoginConfigMenuItem = new JMenuItem(ADD_EJB_TRANSPORT_LOGIN_CONFIG_MENU_STRING);
        this._addEjbTransportLoginConfigMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addEjbTransportLoginConfigMenuItem.setFont(WebServicesTreeNode.getFont());
        this._addEjbTransportLoginConfigMenuItem.addActionListener(this);
        if (this._bean.getEjbTransportLoginConfig() != null) {
            this._addEjbTransportLoginConfigMenuItem.setEnabled(false);
        }
        this._addWebSiteMenuItem = new JMenuItem(ADD_WEB_SITE_MENU_STRING);
        this._addWebSiteMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addWebSiteMenuItem.setFont(WebServicesTreeNode.getFont());
        this._addWebSiteMenuItem.addActionListener(this);
        if (this._bean.getWebSite() != null) {
            this._addWebSiteMenuItem.setEnabled(false);
        }
        this._popup = new JPopupMenu();
        this._popup.add(this._addEjbTransportLoginConfigMenuItem);
        this._popup.add(this._addWebSiteMenuItem);
    }

    public String viewHeaderString() {
        return "Web Services Mappings";
    }

    public String toString() {
        return ((WebServicesBean)this._bean.getDDBean()).getDisplayName();
    }

    protected void buildChildJTree() {
        WebSiteEndpointType webSite;
        EjbTransportLoginConfigType ejbTransportLoginConfig = this._bean.getEjbTransportLoginConfig();
        if (ejbTransportLoginConfig != null) {
            EjbTransportLoginConfigTreeNode ejbTransportLoginConfigTreeNode = new EjbTransportLoginConfigTreeNode(this.getRootNode(), ejbTransportLoginConfig);
            this.addChild(ejbTransportLoginConfigTreeNode);
        }
        if ((webSite = this._bean.getWebSite()) != null) {
            WebSiteEndpointTreeNode webSiteEndpointTreeNode = new WebSiteEndpointTreeNode(this.getRootNode(), webSite);
            this.addChild(webSiteEndpointTreeNode);
        }
        try {
            Method xmlMethod = WebServicesConfigBean.class.getMethod("writeProviderDescriptionsXML", PrintWriter.class, String.class);
            ProviderDescriptionsTreeNode providerDescriptionsTreeNode = new ProviderDescriptionsTreeNode(this.getRootNode(), new MultipleType(this._bean, xmlMethod));
            this.addChild(providerDescriptionsTreeNode);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public boolean showDefaults() {
        return true;
    }

    public void actionPerformed(ActionEvent event) {
        ConfigTreeNode newNode;
        try {
            EjbTransportLoginConfigType newEjbTransportLoginConfig;
            if (event.getActionCommand().equals(ADD_EJB_TRANSPORT_LOGIN_CONFIG_MENU_STRING) && this._bean.getEjbTransportLoginConfig() == null && this.showAddDialog(newEjbTransportLoginConfig = this._bean.defaultEjbTransportLoginConfig(), ADD_EJB_TRANSPORT_LOGIN_CONFIG_MENU_STRING)) {
                this._bean.setEjbTransportLoginConfig(newEjbTransportLoginConfig);
                newNode = new EjbTransportLoginConfigTreeNode(this, newEjbTransportLoginConfig);
                this.insertNode(newNode);
                this._addEjbTransportLoginConfigMenuItem.setEnabled(false);
            }
        }
        catch (Throwable ex) {
            throw new ExtendedRuntimeException(ex);
        }
        try {
            WebSiteEndpointType newWebSite;
            if (event.getActionCommand().equals(ADD_WEB_SITE_MENU_STRING) && this._bean.getWebSite() == null && this.showAddDialog(newWebSite = this._bean.defaultWebSite(), ADD_WEB_SITE_MENU_STRING)) {
                this._bean.setWebSite(newWebSite);
                newNode = new WebSiteEndpointTreeNode(this, newWebSite);
                this.insertNode(newNode);
                this._addWebSiteMenuItem.setEnabled(false);
            }
        }
        catch (Throwable ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof EjbTransportLoginConfigTreeNode) {
            this._bean.removeEjbTransportLoginConfig();
            this.removeNode(node);
            this._addEjbTransportLoginConfigMenuItem.setEnabled(true);
        } else if (node instanceof WebSiteEndpointTreeNode) {
            this._bean.removeWebSite();
            this.removeNode(node);
            this._addWebSiteMenuItem.setEnabled(true);
        }
    }
}

