/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.jmx.client;

import java.util.StringTokenizer;
import oracle.oc4j.admin.jmx.shared.Domain;
import oracle.oc4j.admin.jmx.shared.IasRmiDomain;

public class IasDomainFactory {
    public static Domain getDomain(String host, int rmiPort, String login, String pwd) {
        return new IasRmiDomain(host, rmiPort, login, pwd);
    }

    public static Domain getDomain(String host, int rmiPort) {
        return new IasRmiDomain(host, rmiPort);
    }

    public static Domain getDomain(String domain) {
        return new IasRmiDomain(domain);
    }

    public static Domain getDomain(String domain, String login, String pwd) {
        return new IasRmiDomain(domain, login, pwd);
    }

    public static Domain getDomainFromDeployerUrl(String deployerUrl, String login, String pwd) {
        String protocolProperty = null;
        StringTokenizer strTok = new StringTokenizer(deployerUrl, ":");
        if (strTok.countTokens() < 1) {
            throw new IllegalArgumentException("Invalid deployer url: " + deployerUrl);
        }
        if (strTok.countTokens() == 1) {
            return new IasRmiDomain("localhost", 23791, login, pwd);
        }
        strTok.nextToken();
        strTok.nextToken();
        String host = strTok.nextToken();
        if ("rmis".equalsIgnoreCase(host) || "ormis".equalsIgnoreCase(host)) {
            protocolProperty = "ormis";
            host = strTok.nextToken();
        }
        if ("rmi".equalsIgnoreCase(host) || "ormi".equalsIgnoreCase(host)) {
            host = strTok.nextToken();
        }
        int port = 23791;
        if (strTok.countTokens() > 0) {
            port = Integer.parseInt(strTok.nextToken());
        }
        IasRmiDomain domain = new IasRmiDomain(host, port, login, pwd);
        domain.setConnectionCaching(false);
        if (protocolProperty != null) {
            domain.addProperty("com.oracle.jmx.remote.oc4j.wireprotocol", protocolProperty);
        }
        return domain;
    }
}

