/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.jmx.client;

import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.NotificationListener;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.admin.jmx.client.RemoteListenerIdGenerator;
import oracle.oc4j.admin.jmx.shared.Domain;
import oracle.oc4j.admin.jmx.shared.RemoteListenerId;
import oracle.oc4j.admin.jmx.shared.RemoteListenerIdImpl;

public class ListenerIdManager {
    private static Logger logger_ = TraceLogger.getLogger((Class)ListenerIdManager.class);
    private Domain domain_ = null;
    private Hashtable IdToListenerAssociation_ = new Hashtable();
    private Hashtable ListenerToIdAssociation_ = new Hashtable();
    private static Hashtable DomainToListenerIdManagerAssociation_ = new Hashtable();

    private ListenerIdManager(Domain domain) {
        this.domain_ = domain;
        DomainToListenerIdManagerAssociation_.put(domain, this);
        if (logger_.isLoggable(Level.FINE)) {
            logger_.fine("ListenerIdManager created for domain: " + domain.toString());
            logger_.fine(DomainToListenerIdManagerAssociation_.size() + " domain are currently registered");
        }
    }

    public static ListenerIdManager getListenerIdManager(Domain domain) {
        ListenerIdManager res = (ListenerIdManager)DomainToListenerIdManagerAssociation_.get(domain);
        if (res == null) {
            res = new ListenerIdManager(domain);
        }
        return res;
    }

    public RemoteListenerId registerListener(NotificationListener listener) {
        RemoteListenerIdImpl id = new RemoteListenerIdImpl(this.domain_);
        if (logger_.isLoggable(Level.FINE)) {
            logger_.fine("Register listener: " + listener + " for domain: " + this.domain_.toString() + " under id: " + id);
        }
        this.IdToListenerAssociation_.put(id, listener);
        this.ListenerToIdAssociation_.put(listener, id);
        return id;
    }

    public void unregisterListener(NotificationListener listener) {
        RemoteListenerId id = (RemoteListenerId)this.ListenerToIdAssociation_.get(listener);
        if (logger_.isLoggable(Level.FINE)) {
            logger_.fine("Unregister listener: " + listener + " for domain: " + this.domain_.toString() + " under id: " + id);
        }
        this.ListenerToIdAssociation_.remove(listener);
        if (id != null) {
            this.IdToListenerAssociation_.remove(id);
            RemoteListenerIdGenerator.recycleId(id, this.domain_);
        }
    }

    public RemoteListenerId getListenerId(NotificationListener listener) {
        return (RemoteListenerId)this.ListenerToIdAssociation_.get(listener);
    }

    public NotificationListener getNotificationListener(RemoteListenerId id) {
        return (NotificationListener)this.IdToListenerAssociation_.get(id);
    }

    public int getListenerCount() {
        return this.IdToListenerAssociation_.size();
    }

    public static RemoteListenerId registerListener(NotificationListener listener, Domain domain) {
        ListenerIdManager manager = ListenerIdManager.getListenerIdManager(domain);
        return manager.registerListener(listener);
    }

    public static void unregisterListener(NotificationListener listener, Domain domain) {
        ListenerIdManager manager = ListenerIdManager.getListenerIdManager(domain);
        manager.unregisterListener(listener);
    }

    public static RemoteListenerId getListenerId(NotificationListener listener, Domain domain) {
        ListenerIdManager manager = ListenerIdManager.getListenerIdManager(domain);
        return manager.getListenerId(listener);
    }

    public static int getListenerCount(Domain domain) {
        ListenerIdManager manager = ListenerIdManager.getListenerIdManager(domain);
        return manager.getListenerCount();
    }

    public static NotificationListener getNotificationListener(RemoteListenerId id, Domain domain) {
        ListenerIdManager manager = ListenerIdManager.getListenerIdManager(domain);
        return manager.getNotificationListener(id);
    }
}

