/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.jmx.client.shell;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import oracle.oc4j.admin.jmx.client.ClientMBeanServerProxyFactory;
import oracle.oc4j.admin.jmx.client.Connector;
import oracle.oc4j.admin.jmx.client.IasDomainFactory;
import oracle.oc4j.admin.jmx.client.Oc4jDomainFactory;
import oracle.oc4j.admin.jmx.shared.Domain;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXRuntimeException;

public class JmxShell {
    private Connector serv = null;
    static InputStream s_input;
    static BufferedWriter s_output;
    static int s_exitCode;
    private static String CMD_LISTMBEANS;
    private static String CMD_LISTMBEANATTRIBUTES;
    private static String CMD_LISTMBEANINFO;
    private static String CMD_GETATTRIBUTE;
    private static String CMD_GETATTRIBUTES;
    private static String CMD_GETMBEANCOUNT;
    private static String CMD_GETDEFAULTDOMAIN;
    private static String CMD_GETOBJECTINSTANCE;
    private static String CMD_QUERYMBEANS;
    private static String CMD_QUERYNAMES;
    private static String CMD_SETATTRIBUTE;
    private static String CMD_INVOKEMETHOD;
    private static String CMD_DUMPSTATS;
    private static String CMD_PRINT;
    private static String CMD_ECHO;
    private static String CMD_EXIT;
    private static String CMD_HELP;
    private static final int OPT_ARRAY_SIZE = 10;
    private static boolean env_echo;
    private static boolean writeToFile;
    private static final int BUFSIZE = 4096;
    private static final String COMMENT = "#";
    private String host = "localhost";
    private int port = 23791;
    private String portRep = null;
    private String login = "oc4jadmin";
    private String pwd = "welcome";
    private boolean iasDomain_ = false;
    private String[] m_parameters = new String[10];

    private void invokeMethod(String mBeanName, String actionName) {
        block8: {
            if (mBeanName == null) {
                this.printLine("Name of the MBean is null.");
                this.printLine("Usage: invokeMethod <name of the MBean> <name of the method> ");
                return;
            }
            if (actionName == null) {
                this.printLine("Method name is null.");
                this.printLine("Usage: invokeMethod <name of the MBean> <name of the method> ");
                return;
            }
            try {
                ObjectName objectName = new ObjectName(mBeanName);
                this.serv.invoke(objectName, actionName, null, null);
            }
            catch (InstanceNotFoundException inf) {
                inf.printStackTrace();
            }
            catch (MBeanException mb) {
                mb.printStackTrace();
            }
            catch (ReflectionException re) {
                this.printLine("Note: Only support to invoke a method that has no parameters and returns void.");
                re.printStackTrace();
            }
            catch (Throwable e) {
                e.printStackTrace();
                if (!(e instanceof RuntimeException)) break block8;
                this.printLine("\nAn UnsupportedOperationException is caught. Initialize MBean Server....\n");
                if (this.serv != null) {
                    this.serv.release();
                }
                this.init();
            }
        }
    }

    private void dumpStats(String mBeanName) {
        block9: {
            if (mBeanName == null) {
                this.printLine("Name of the MBean is null.");
                this.printLine("Usage: dumpStats <name of the MBean>");
                return;
            }
            try {
                ObjectName objectName = new ObjectName(mBeanName);
                Boolean provideStatistics = (Boolean)this.serv.getAttribute(objectName, "statisticsProvider");
                if (!provideStatistics.booleanValue()) {
                    this.printLine("This MBean does not implement StatisticsProvider model.");
                    return;
                }
                Object stats = this.serv.getAttribute(objectName, "stats");
                this.printLine(stats.toString());
            }
            catch (AttributeNotFoundException afe) {
                this.printLine("Error: " + afe.getMessage());
            }
            catch (MBeanException mbe) {
                this.printLine("Error: " + mbe.getMessage());
            }
            catch (InstanceNotFoundException inf) {
                this.printLine("Error: " + inf.getMessage());
            }
            catch (ReflectionException re) {
                this.printLine("Error: " + re.getMessage());
            }
            catch (Throwable e) {
                e.printStackTrace();
                if (!(e instanceof RuntimeException)) break block9;
                this.printLine("\nAn UnsupportedOperationException is caught. Initialize MBean Server....\n");
                if (this.serv != null) {
                    this.serv.release();
                }
                this.init();
            }
        }
    }

    private void setAttribute(String mBeanName, String attrName, String attrValue) {
        block13: {
            if (mBeanName == null) {
                this.printLine("Name of the MBean is null.");
                this.printLine("Usage: setAttribute <name of the MBean> <name of the attribute> <value of the attribute>.");
                return;
            }
            if (attrName == null) {
                this.printLine("Should specify an attribute name. ");
                this.printLine("usage: setAttribute <name of the MBean> <name of the attribute> <value of the attribute>.");
                return;
            }
            if (attrValue == null) {
                this.printLine("Should specify an attribute value.");
                this.printLine("usage: setAttribute <name of the MBean> <name of the attribute> <value of the attribute>.");
                return;
            }
            try {
                ObjectName objectName = new ObjectName(mBeanName);
                MBeanInfo info = this.serv.getMBeanInfo(objectName);
                MBeanAttributeInfo[] attrInfo = info.getAttributes();
                for (int i = 0; i < attrInfo.length; ++i) {
                    if (!attrInfo[i].getName().equals(attrName)) continue;
                    if (attrInfo[i].isWritable()) {
                        Class<?> type = Class.forName(attrInfo[i].getType());
                        Class[] paramTypes = new Class[]{String.class};
                        Constructor<?> constructor = type.getConstructor(paramTypes);
                        Object[] paramValues = new Object[]{attrValue};
                        Object obj = constructor.newInstance(paramValues);
                        Attribute attribute = new Attribute(attrName, obj);
                        this.serv.setAttribute(objectName, attribute);
                        this.printLine("Attribute " + attrName + " has been changed to " + attrValue);
                        return;
                    }
                    this.printLine("Can not update attribute " + attrName + ". It's unwritable.");
                    break;
                }
            }
            catch (AttributeNotFoundException afe) {
                this.printLine("Error: " + afe.getMessage());
            }
            catch (MBeanException mbe) {
                this.printLine("Error: " + mbe.getMessage());
            }
            catch (InstanceNotFoundException inf) {
                this.printLine("Error: " + inf.getMessage());
            }
            catch (ReflectionException re) {
                this.printLine("Error: " + re.getMessage());
            }
            catch (InvalidAttributeValueException iae) {
                this.printLine("Error: " + iae.getMessage());
            }
            catch (Throwable e) {
                e.printStackTrace();
                if (!(e instanceof RuntimeException)) break block13;
                this.printLine("\nAn UnsupportedOperationException is caught. Initialize MBean Server....\n");
                if (this.serv != null) {
                    this.serv.release();
                }
                this.init();
            }
        }
    }

    private void queryNames(String type) {
        block7: {
            if (type == null) {
                this.printLine("Usage: queryNames <key property>,<key>property>,...");
                return;
            }
            String j2eeType = "*:" + type + ",*";
            this.printLine("\n");
            try {
                Set<ObjectName> managed_object_set = this.serv.queryNames(new ObjectName(j2eeType), null);
                if (managed_object_set.size() == 0) {
                    this.printLine("No matching managed object found with the key property: " + type);
                } else {
                    Iterator<ObjectName> iter = managed_object_set.iterator();
                    this.printLine("Found managed objects of the key property: " + type);
                    while (iter.hasNext()) {
                        this.printLine("    " + ((Object)iter.next()).toString());
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                if (!(e instanceof RuntimeException)) break block7;
                this.printLine("\nAn UnsupportedOperationException is caught. Initialize MBean Server....\n");
                if (this.serv != null) {
                    this.serv.release();
                }
                this.init();
            }
        }
    }

    private void getObjectInstance(String mBeanName) {
        block6: {
            if (mBeanName == null) {
                this.printLine("Usage: getObjectInstance <name of an MBean");
                return;
            }
            try {
                ObjectInstance instance = this.serv.getObjectInstance(new ObjectName(mBeanName));
                this.printLine("");
                String className = instance.getClassName();
                this.printLine("The class name: " + className);
                ObjectName objectName = instance.getObjectName();
                this.printLine("getCanonicalName():              " + objectName.getCanonicalName());
                this.printLine("getDomain():                     " + objectName.getDomain());
                this.printLine("getKeyPropertyListString():      " + objectName.getKeyPropertyListString());
                Hashtable<String, String> propList = objectName.getKeyPropertyList();
                Enumeration<String> e = propList.elements();
                while (e.hasMoreElements()) {
                    String property = e.nextElement();
                    this.printLine("getKeyProperty(" + property + "):     " + objectName.getKeyProperty(property));
                }
                this.printLine(objectName.toString() + " " + (objectName.isPattern() ? " is a pattern for a query." : " is not a pattern for a query."));
                this.printLine(objectName.toString() + " " + (objectName.isPropertyPattern() ? " is a pattern on the key property." : " is not a pattern on the key property."));
            }
            catch (InstanceNotFoundException inf) {
                this.printLine("Error: " + inf.getMessage());
            }
            catch (Throwable e) {
                e.printStackTrace();
                if (!(e instanceof RuntimeException)) break block6;
                this.printLine("\nAn UnsupportedOperationException is caught. Initialize MBean Server....\n");
                if (this.serv != null) {
                    this.serv.release();
                }
                this.init();
            }
        }
    }

    private void getDefaultDomain() {
        block3: {
            this.printLine("");
            try {
                this.printLine("The defaule domain for this MBean is " + this.serv.getDefaultDomain());
            }
            catch (Throwable e) {
                e.printStackTrace();
                if (!(e instanceof RuntimeException)) break block3;
                this.printLine("\nAn UnsupportedOperationException is caught. Initialize MBean Server....\n");
                if (this.serv != null) {
                    this.serv.release();
                }
                this.init();
            }
        }
    }

    private void getMBeanCount() {
        block3: {
            this.printLine("");
            try {
                this.printLine(this.serv.getMBeanCount());
            }
            catch (Throwable e) {
                e.printStackTrace();
                if (!(e instanceof RuntimeException)) break block3;
                this.printLine("\nAn UnsupportedOperationException is caught. Initialize MBean Server....\n");
                if (this.serv != null) {
                    this.serv.release();
                }
                this.init();
            }
        }
    }

    private void getAttributes(String mBeanName) {
        block8: {
            AttributeList atl = null;
            if (mBeanName == null) {
                this.printLine("Name of the MBean is null.");
                this.printLine("Usage: getAttributes <name of an MBean>");
                return;
            }
            try {
                int i;
                MBeanInfo info = this.serv.getMBeanInfo(new ObjectName(mBeanName));
                MBeanAttributeInfo[] attrInfo = info.getAttributes();
                String[] attributes = new String[attrInfo.length];
                for (i = 0; i < attrInfo.length; ++i) {
                    attributes[i] = null;
                }
                for (i = 0; i < attrInfo.length; ++i) {
                    attributes[i] = attrInfo[i].getName();
                }
                atl = this.serv.getAttributes(new ObjectName(mBeanName), attributes);
                this.printLine("");
                this.printLine("MBean with name: " + mBeanName + " has the following attributes:");
                this.printLine("");
                this.printLine("        Attribute Name                      Attribute Value");
                for (i = 0; i < atl.size(); ++i) {
                    this.print(i + 1 + ":    " + attributes[i]);
                    int len = 44 - (6 + attributes[i].length()) - 2;
                    for (int j = 0; j < len; ++j) {
                        this.print(" ");
                    }
                    this.print(((Attribute)atl.get(i)).getValue().toString());
                    this.print(attrInfo[i].isWritable() ? "  (writeable)" : "  (unwriteable)");
                    this.printLine("");
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                if (!(e instanceof RuntimeException)) break block8;
                this.printLine("\nAn UnsupportedOperationException is caught. Initialize MBean Server....\n");
                if (this.serv != null) {
                    this.serv.release();
                }
                this.init();
            }
        }
    }

    private void getAttribute(String mBeanName, String attribute) {
        block9: {
            if (mBeanName == null) {
                this.printLine("Name of the MBean is null.");
                this.printLine("Usage: getAttribute <name of an MBean> <an attribute>");
                return;
            }
            if (attribute == null) {
                this.printLine("There is no specific attribute. List the value of all of attributes.");
                this.getAttributes(mBeanName);
                return;
            }
            try {
                Object attri = this.serv.getAttribute(new ObjectName(mBeanName), attribute);
                this.printLine("attribute " + attribute + " = " + attri.toString());
            }
            catch (AttributeNotFoundException afe) {
                this.printLine("Error: " + afe.getMessage());
            }
            catch (MBeanException mbe) {
                this.printLine("Error: " + mbe.getMessage());
            }
            catch (InstanceNotFoundException inf) {
                this.printLine("Error: " + inf.getMessage());
            }
            catch (ReflectionException re) {
                this.printLine("Error: " + re.getMessage());
            }
            catch (Throwable e) {
                e.printStackTrace();
                if (!(e instanceof RuntimeException)) break block9;
                this.printLine("\nAn UnsupportedOperationException is caught. Initialize MBean Server....\n");
                if (this.serv != null) {
                    this.serv.release();
                }
                this.init();
            }
        }
    }

    private void listMBeanInfo(String mBeanName) {
        block12: {
            if (mBeanName == null) {
                this.printLine("Name of the MBean is null.");
                this.printLine("Usage: listMBeanINfo <name of an MBean>");
                return;
            }
            try {
                int j;
                int i;
                ObjectName objectName = new ObjectName(mBeanName);
                MBeanInfo info = this.serv.getMBeanInfo(objectName);
                this.printLine("\n");
                this.printLine("MBean with name: " + mBeanName + "'s information:");
                this.printLine("\n");
                this.printLine("    Name of the Java class of this MBean described by this MBeanInfo: \n        " + info.getClassName() + "\n");
                MBeanAttributeInfo[] attrInfo = info.getAttributes();
                this.printLine("    " + attrInfo.length + " attribute" + (attrInfo.length <= 1 ? ":\n" : "s:\n"));
                for (i = 0; i < attrInfo.length; ++i) {
                    this.printLine("        " + (i + 1) + ": " + attrInfo[i].getName() + "'s type: " + attrInfo[i].getType());
                    int len = 11 + attrInfo[i].getName().length() + 3;
                    for (j = 0; j < len; ++j) {
                        this.print(" ");
                    }
                    this.printLine("value: " + this.serv.getAttribute(objectName, attrInfo[i].getName()));
                    for (j = 0; j < len; ++j) {
                        this.print(" ");
                    }
                    this.printLine(attrInfo[i].isIs() ? "is an \"is\" getter" : "isn't an \"is\" getter");
                    for (j = 0; j < len; ++j) {
                        this.print(" ");
                    }
                    this.printLine((attrInfo[i].isReadable() ? "is readable " : "is unreadable ") + (attrInfo[i].isWritable() ? "and writeable" : "and unwriteable"));
                    this.printLine("");
                }
                this.printLine("\n");
                MBeanNotificationInfo[] notifInfo = info.getNotifications();
                this.printLine("    " + notifInfo.length + " notification class" + (notifInfo.length <= 1 ? ":\n" : "es:\n"));
                for (i = 0; i < notifInfo.length; ++i) {
                    this.printLine("        Notification class " + (i + 1) + ": " + notifInfo[i].getName() + " uses");
                    String[] notifTypes = notifInfo[i].getNotifTypes();
                    this.printLine("        " + notifTypes.length + " types of events:");
                    for (j = 0; j < notifTypes.length; ++j) {
                        this.printLine("            Type " + (j + 1) + ": " + notifTypes[j]);
                    }
                    this.printLine("\n");
                }
                MBeanOperationInfo[] operaInfo = info.getOperations();
                this.printLine("    " + operaInfo.length + " operation" + (operaInfo.length <= 1 ? ":\n" : "s:\n"));
                for (i = 0; i < operaInfo.length; ++i) {
                    this.print("        " + operaInfo[i].getReturnType() + " ");
                    this.print(operaInfo[i].getName() + "(");
                    MBeanParameterInfo[] paramInfo = operaInfo[i].getSignature();
                    for (j = 0; j < paramInfo.length; ++j) {
                        this.print(paramInfo[j].getType() + (j != paramInfo.length - 1 ? ", " : ""));
                    }
                    this.printLine(");");
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                if (!(e instanceof RuntimeException)) break block12;
                this.printLine("\nAn UnsupportedOperationException is caught. Initialize MBean Server....\n");
                if (this.serv != null) {
                    this.serv.release();
                }
                this.init();
            }
        }
    }

    private void listMBeanInfo() {
        block9: {
            try {
                Set<ObjectName> mBeans = this.serv.queryNames(null, null);
                Iterator<ObjectName> iter = mBeans.iterator();
                while (iter.hasNext()) {
                    int j;
                    int i;
                    String mBeanName = ((Object)iter.next()).toString();
                    MBeanInfo info = this.serv.getMBeanInfo(new ObjectName(mBeanName));
                    this.printLine("\n");
                    this.printLine("MBean with name: " + mBeanName + "'s information:");
                    this.printLine("\n");
                    this.printLine("    Name of the Java class of this MBean described by this MBeanInfo: \n        " + info.getClassName() + "\n");
                    MBeanAttributeInfo[] attrInfo = info.getAttributes();
                    this.printLine("    " + attrInfo.length + " attribute" + (attrInfo.length <= 1 ? ":\n" : "s:\n"));
                    for (i = 0; i < attrInfo.length; ++i) {
                        this.printLine("        Attribute " + (i + 1) + ": " + attrInfo[i].getName() + (attrInfo[i].isReadable() ? " is readable" : " is unreadable") + (attrInfo[i].isWritable() ? " and writeable" : " and unwriteable"));
                    }
                    this.printLine("\n");
                    MBeanNotificationInfo[] notifInfo = info.getNotifications();
                    this.printLine("    " + notifInfo.length + " notification class" + (notifInfo.length <= 1 ? ":\n" : "es:\n"));
                    for (i = 0; i < notifInfo.length; ++i) {
                        this.printLine("        Notification class " + (i + 1) + ": " + notifInfo[i].getName() + " uses");
                        String[] notifTypes = notifInfo[i].getNotifTypes();
                        this.printLine("        " + notifTypes.length + " types of events:");
                        for (j = 0; j < notifTypes.length; ++j) {
                            this.printLine("            Type " + (j + 1) + ": " + notifTypes[j]);
                        }
                        this.printLine("\n");
                    }
                    MBeanOperationInfo[] operaInfo = info.getOperations();
                    this.printLine("    " + operaInfo.length + " operation" + (operaInfo.length <= 1 ? ":\n" : "s:\n"));
                    for (i = 0; i < operaInfo.length; ++i) {
                        this.print("        " + operaInfo[i].getReturnType() + " ");
                        this.print(operaInfo[i].getName() + "(");
                        MBeanParameterInfo[] paramInfo = operaInfo[i].getSignature();
                        for (j = 0; j < paramInfo.length; ++j) {
                            this.print(paramInfo[j].getType() + (j != paramInfo.length - 1 ? ", " : ""));
                        }
                        this.printLine(");");
                    }
                    this.printLine("\n*******************************************");
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                if (!(e instanceof RuntimeException)) break block9;
                this.printLine("\nAn UnsupportedOperationException is caught. Initialize MBean Server....\n");
                if (this.serv != null) {
                    this.serv.release();
                }
                this.init();
            }
        }
    }

    private void listMBeanAttributes() {
        block5: {
            String mBeanName = null;
            AttributeList atl = null;
            String[] attributes = new String[]{"Version"};
            try {
                Set<ObjectName> mBeans = this.serv.queryNames(null, null);
                Iterator<ObjectName> iter = mBeans.iterator();
                while (iter.hasNext()) {
                    mBeanName = ((Object)iter.next()).toString();
                    atl = this.serv.getAttributes(new ObjectName(mBeanName), attributes);
                    this.printLine(mBeanName + " has the following attributes:");
                    for (int i = 0; i < atl.size(); ++i) {
                        this.printLine(i + ": " + attributes[i] + "->" + ((Attribute)atl.get(i)).getValue());
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                if (!(e instanceof RuntimeException)) break block5;
                this.printLine("\nAn UnsupportedOperationException is caught. Initialize MBean Server....\n");
                if (this.serv != null) {
                    this.serv.release();
                }
                this.init();
            }
        }
    }

    private void listMBeans() {
        block10: {
            boolean i = false;
            try {
                int j;
                if (this.serv == null) {
                    this.printLine("serv is null.");
                }
                Set<ObjectName> mbeanNames = this.serv.queryNames(null, null);
                ObjectName[] objectNames = mbeanNames.toArray(new ObjectName[0]);
                Object[] nameArray = new String[objectNames.length];
                for (j = 0; j < objectNames.length; ++j) {
                    nameArray[j] = objectNames[j].toString();
                }
                Arrays.sort(nameArray);
                this.printLine("\n");
                this.printLine("The following MBeans have been registered in MBeanServer.");
                this.printLine("\n");
                for (j = 0; j < nameArray.length; ++j) {
                    int width = 0;
                    width = j < 9 ? 140 : 139;
                    String name = ((String)nameArray[j]).toString();
                    if (name.length() < width) {
                        this.printLine(j + 1 + ":  " + name);
                    } else {
                        String temp = name.substring(0, width);
                        int middle = temp.lastIndexOf(44);
                        this.printLine(j + 1 + ":  " + name.substring(0, middle + 1));
                        if (j < 9) {
                            this.printLine("         " + name.substring(middle + 1));
                        } else {
                            this.printLine("          " + name.substring(middle + 1));
                        }
                    }
                    this.printLine("");
                }
                this.printLine("\nPlease use method 'listMBeanInfo' or 'listMBeanInfo <name of an MBean>' \nto view information of the MBeans.");
            }
            catch (Throwable e) {
                e.printStackTrace();
                if (!(e instanceof RuntimeException)) break block10;
                this.printLine("\nAn UnsupportedOperationException is caught. Initialize MBean Server....\n");
                if (this.serv != null) {
                    this.serv.release();
                }
                this.init();
            }
        }
    }

    protected void printException(JMXRuntimeException e) {
        e.printStackTrace();
    }

    protected int getOpt(String[] pars, int index) {
        int next = index;
        if (pars[index] == null) {
            this.printLine("This is an invalid option.");
            return 0;
        }
        if (!pars[index].startsWith("-")) {
            return ++next;
        }
        return 0;
    }

    protected String parseParameters(String[] arguments) {
        int i;
        int len = arguments.length;
        if (len == 0) {
            return null;
        }
        for (i = 0; i < 10; ++i) {
            this.m_parameters[i] = null;
        }
        for (i = 1; i < len; ++i) {
            this.m_parameters[i - 1] = arguments[i];
        }
        return arguments[0];
    }

    protected Connector getConnector() {
        return this.serv;
    }

    protected String[] getParsedParameters() {
        return this.m_parameters;
    }

    protected String parseParameters(List arguments) {
        int i;
        int len = arguments.size();
        if (len == 0) {
            this.printLine("There is no elements in arguments.");
            return null;
        }
        for (i = 0; i < 10; ++i) {
            this.m_parameters[i] = null;
        }
        for (i = 1; i < len; ++i) {
            this.m_parameters[i - 1] = (String)arguments.get(i);
        }
        return arguments.get(0).toString();
    }

    protected String parseInput(List input) {
        return this.parseParameters(input);
    }

    protected String parseInput(String input) {
        if (input.trim().length() == 0) {
            return null;
        }
        String cmdString = input;
        StringTokenizer st = new StringTokenizer(cmdString);
        int len = st.countTokens();
        String[] parameters = new String[len];
        for (int i = 0; i < len; ++i) {
            parameters[i] = st.nextToken();
        }
        return this.parseParameters(parameters);
    }

    protected void execute(String code) {
        if (code == null) {
            return;
        }
        try {
            if (code.equalsIgnoreCase(CMD_LISTMBEANS)) {
                if (env_echo) {
                    this.printLine("------- listMBeans");
                }
                this.listMBeans();
            } else if (code.equalsIgnoreCase(CMD_LISTMBEANATTRIBUTES)) {
                if (env_echo) {
                    this.printLine("------- listMBeanAttributes");
                }
                this.listMBeanAttributes();
            } else if (code.equalsIgnoreCase(CMD_LISTMBEANINFO)) {
                if (this.m_parameters[0] != null) {
                    if (env_echo) {
                        this.printLine("------- listMBeanInfo " + this.m_parameters[0]);
                    }
                    this.listMBeanInfo(this.m_parameters[0]);
                } else {
                    if (env_echo) {
                        this.printLine("------- listMBeanInfo");
                    }
                    this.listMBeanInfo();
                }
            } else if (code.equalsIgnoreCase(CMD_GETATTRIBUTE)) {
                if (env_echo) {
                    this.printLine("------- getAttribute");
                }
                this.getAttribute(this.m_parameters[0], this.m_parameters[1]);
            } else if (code.equalsIgnoreCase(CMD_GETATTRIBUTES)) {
                if (env_echo) {
                    this.printLine("------- getAttributes");
                }
                this.getAttributes(this.m_parameters[0]);
            } else if (code.equalsIgnoreCase(CMD_GETMBEANCOUNT)) {
                if (env_echo) {
                    this.printLine("------- getMBeanCount");
                }
                this.getMBeanCount();
            } else if (code.equalsIgnoreCase(CMD_GETDEFAULTDOMAIN)) {
                if (env_echo) {
                    this.printLine("------- getDefaultDomain");
                }
                this.getDefaultDomain();
            } else if (code.equalsIgnoreCase(CMD_GETOBJECTINSTANCE)) {
                if (env_echo) {
                    this.printLine("------- getObjectInstance");
                }
                this.getObjectInstance(this.m_parameters[0]);
            } else if (code.equalsIgnoreCase(CMD_QUERYNAMES)) {
                if (env_echo) {
                    this.printLine("------- queryNames");
                }
                this.queryNames(this.m_parameters[0]);
            } else if (code.equalsIgnoreCase(CMD_SETATTRIBUTE)) {
                if (env_echo) {
                    this.printLine("------- setAttribute");
                }
                this.setAttribute(this.m_parameters[0], this.m_parameters[1], this.m_parameters[2]);
            } else if (code.equalsIgnoreCase(CMD_INVOKEMETHOD)) {
                if (env_echo) {
                    this.printLine("------- invokeMethod");
                }
                this.invokeMethod(this.m_parameters[0], this.m_parameters[1]);
            } else if (code.equalsIgnoreCase(CMD_DUMPSTATS)) {
                if (env_echo) {
                    this.printLine("------- dumpStats");
                }
                this.dumpStats(this.m_parameters[0]);
            } else if (code.equalsIgnoreCase(CMD_PRINT)) {
                if (this.m_parameters[0] != null) {
                    if (env_echo) {
                        this.printLine("------- print " + this.m_parameters[0]);
                    }
                    this.setOutput(this.m_parameters[0]);
                }
            } else if (code.equalsIgnoreCase(CMD_ECHO)) {
                if (this.m_parameters[0] != null) {
                    if (env_echo) {
                        this.printLine("------- echo " + this.m_parameters[0]);
                    }
                } else if (env_echo) {
                    this.printLine("------- echo ");
                }
                this.echo();
            } else if (code.equalsIgnoreCase(CMD_HELP)) {
                if (env_echo) {
                    this.printLine("------- help");
                }
                this.showShellHelp();
            } else if (code.equalsIgnoreCase(CMD_EXIT)) {
                if (env_echo) {
                    this.printLine("------- exit");
                }
                this.exit();
            } else {
                this.printLine("Unrecognized command: " + code);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getNextArgument(List arguments, String argumentDescription) {
        if (arguments.isEmpty()) {
            this.printLine("Invalid usage: " + (argumentDescription == null ? "Missing argument" : "Missing " + argumentDescription));
            System.exit(1);
        }
        return (String)arguments.remove(0);
    }

    protected void init(List arguments) {
        String temp = null;
        String jmxUrl = null;
        String command = null;
        jmxUrl = this.getNextArgument(arguments, "<jmx-url>");
        if (jmxUrl != null) {
            if (!jmxUrl.startsWith("-")) {
                if (!jmxUrl.startsWith("jmx:")) {
                    this.printLine("Missing jmx:[ias]//<host>:<port>");
                    System.exit(1);
                }
                int urlLen = jmxUrl.length();
                int temp1 = jmxUrl.lastIndexOf("//");
                int temp2 = jmxUrl.lastIndexOf(":");
                if (temp2 < temp1) {
                    temp2 = urlLen;
                }
                if (temp1 == -1) {
                    this.printLine("url format should be: jmx:[ias]//<host>[:<port>]");
                    System.exit(1);
                } else {
                    this.host = jmxUrl.substring(temp1 + 2, temp2);
                    if (temp2 != urlLen && temp2 + 1 < urlLen) {
                        this.port = Integer.parseInt(jmxUrl.substring(temp2 + 1));
                    }
                }
                int iasIndex = jmxUrl.lastIndexOf("ias");
                if (iasIndex != -1) {
                    if (iasIndex == jmxUrl.indexOf(":") + 1 && iasIndex == jmxUrl.indexOf("//") - 3) {
                        this.iasDomain_ = true;
                    } else {
                        this.printLine("url format should be: jmx:[ias]//<host>[:<port>]");
                        System.exit(1);
                    }
                }
                if (!arguments.isEmpty()) {
                    temp = this.getNextArgument(arguments, "username");
                    if (temp.startsWith("-")) {
                        if (temp.equalsIgnoreCase("-help")) {
                            this.showUsage();
                            System.exit(1);
                        } else {
                            this.init();
                            arguments.add(0, temp.substring(1));
                            command = this.parseInput(arguments);
                            this.execute(command);
                            this.exit();
                        }
                    } else {
                        this.login = temp;
                    }
                    temp = this.getNextArgument(arguments, "password");
                    if (temp.startsWith("-")) {
                        this.printLine("Need to input password if specify a user.");
                        System.exit(1);
                    } else {
                        this.pwd = temp;
                    }
                    if (!arguments.isEmpty()) {
                        jmxUrl = this.getNextArgument(arguments, null);
                        if (jmxUrl != null && jmxUrl.startsWith("-")) {
                            if (jmxUrl.equalsIgnoreCase("-help")) {
                                this.showUsage();
                                System.exit(1);
                            } else {
                                this.init();
                                arguments.add(0, jmxUrl.substring(1));
                                command = this.parseInput(arguments);
                                this.execute(command);
                                this.exit();
                            }
                        } else {
                            this.printLine("The command '" + jmxUrl + "' should begin with a '-'");
                        }
                    } else {
                        this.init();
                    }
                } else {
                    this.init();
                }
            } else if (jmxUrl.equalsIgnoreCase("-help")) {
                this.showUsage();
                System.exit(1);
            } else {
                this.init();
                arguments.add(0, jmxUrl.substring(1));
                command = this.parseInput(arguments);
                this.execute(command);
                this.exit();
            }
        } else {
            this.init();
        }
    }

    private void init() {
        try {
            this.printLine("Connecting to MBean server with jmx:" + (this.iasDomain_ ? "ias" : "") + "//" + this.host + ":" + this.port + " " + this.login + " " + this.pwd + "...");
            Domain domain = null;
            domain = this.iasDomain_ ? IasDomainFactory.getDomain(this.host, this.port, this.login, this.pwd) : Oc4jDomainFactory.getDomain(this.host, this.port, this.login, this.pwd);
            this.serv = ClientMBeanServerProxyFactory.getMBeanServer(domain);
        }
        catch (Exception e) {
            this.printLine("Can not get MBeanServer. Please check whether the host and the port are correct or not.");
            if (this.serv != null) {
                this.serv.release();
            }
            System.exit(1);
        }
    }

    private void setOutput(String parameter) {
        if (parameter.equalsIgnoreCase("off")) {
            this.printLine("Send output to standard output only");
            if (writeToFile) {
                if (s_output != null) {
                    try {
                        s_output.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                s_output = new BufferedWriter(new OutputStreamWriter(System.out));
                writeToFile = false;
            }
        } else {
            try {
                File outputFile = new File(parameter);
                if (outputFile.exists()) {
                    if (!outputFile.canWrite()) {
                        this.printLine("Destination file is unwriteable: " + parameter);
                        this.printLine("Please try again.");
                        return;
                    }
                    System.out.println("Overwrite existing file " + outputFile.getName() + "? (Y/N): ");
                    System.out.flush();
                    BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
                    String response = in.readLine();
                    if (!response.equalsIgnoreCase("y")) {
                        this.printLine("existing file was not overwritten: " + parameter);
                        this.printLine("Please try again.");
                        return;
                    }
                } else {
                    File dir;
                    String parent = outputFile.getParent();
                    if (parent == null) {
                        parent = System.getProperty("user.dir");
                    }
                    if (!(dir = new File(parent)).exists()) {
                        this.printLine("Destination directory doesn't exist: " + parent);
                        this.printLine("Please try again.");
                        return;
                    }
                    if (dir.isFile()) {
                        this.printLine("Destination is not a directory: " + parent);
                        this.printLine("Please try again.");
                        return;
                    }
                    if (!dir.canWrite()) {
                        this.printLine("Destination directory is unwriteable: " + parent);
                        this.printLine("Please try again.");
                        return;
                    }
                }
                this.printLine("Send output to the file and standard output at the same time: " + parameter);
                s_output = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(parameter)));
                writeToFile = true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected void print(Object object) {
        this.print(object.toString());
    }

    protected void print(String result) {
        if (!writeToFile) {
            try {
                s_output.write(result, 0, result.length());
                s_output.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try {
                s_output.write(result, 0, result.length());
                s_output.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            System.out.print(result);
        }
    }

    private void printLine(Object object) {
        this.printLine(object.toString());
    }

    protected void printLine(String result) {
        if (!writeToFile) {
            try {
                s_output.write(result, 0, result.length());
                s_output.newLine();
                s_output.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try {
                s_output.write(result, 0, result.length());
                s_output.newLine();
                s_output.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            System.out.println(result);
        }
    }

    protected synchronized void echo() {
        if (this.m_parameters[0] != null) {
            if (this.m_parameters[0].equalsIgnoreCase("on")) {
                env_echo = true;
            } else if (this.m_parameters[0].equalsIgnoreCase("off")) {
                env_echo = false;
            }
        } else {
            this.printLine("Wrong usage: echo on|off");
        }
    }

    protected void exit() {
        if (this.serv != null) {
            this.serv.release();
        }
        if (s_output != null) {
            try {
                s_output.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            Thread.sleep(2000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(1);
    }

    protected void showCommandHelp(String command) {
    }

    private void showShellHelp() {
        this.printLine("\n Command                     Description\n\nlistMBeans        lists all the MBeans registered on MBean Server\nlistMBeanInfo     gets information of MBeans registered on MBean Server\nlistMBeanInfo <name of an MBean> \n                  gets information of the MBean specified\nqueryNames <key property>,<key property>,... \n                  finds managed objects with a list of key properties\n                  where a key property is a property-value pair. e.g.\n                  j2eeType=J2EEApplication\n                  j2eeType=J2EEApplication,J2EEServer=BankServer\ngetAttributes <name of an MBean> \n                  enables values of several attributes on a named MBean\ngetAttribute <name of an MBean> <an attribute>\n                  gets the value of specific attribute on a named MBean\nsetAttribute <name of an MBean> <name of the attribute> <value of the attribute>\n                  sets the value of specific attribute on a named MBean\ngetMBeanCount     returns the number of MBeans controlled by the MBeanServer\ngetDefaultDomain  returns the default domain used for naming MBean\ngetObjectInstance <name of an MBean> \n                  gets the ObjectInstance for a given MBean registed with the MBean Server\ninvokeMethod <name of an MBean> <name of an method> \n                  invokes the method on the MBean that has no parameters and returns void\ndumpStats <name of an MBean> \n                  displays performance data for a named MBean\n\nprint <path to a file> \n                  prints output to a specified file and standard output\nprint off         prints output to standard output only\necho on|off       echoes input beginning with \"------- \"\nhelp              prints this help message\nexit              exits this command line shell\n\n");
    }

    protected void showUsage() {
        this.printLine("\n Syntax:  java -jar admin-client.jar [[[jmx:[ias]//<host>]:<port>] <username> <password>]\n               (to run in a command line shell)\n     or   java -jar admin-client.jar [[[jmx:[ias]//<host>]:<port>] <username> <password>] [command]\n               (to execute a command)\n\n where commands are:\n     -listMBeans      get list of MBeans registered on MBean Server\n     -listMBeanInfo   get information of MBeans\n     -listMBeanInfo <name of an MBean> \n                      gets information of the MBean specified\n     -help            print this help message\n\n Examples: \n     Running in a shell:\n         java -jar admin-client.jar\n         java -jar admin-client.jar jmx:[ias]//localhost\n     Executing a command only:\n         java -jar admin-client.jar -listMBeans\n         java -jar admin-client.jar jmx:[ias]//localhost -listMBeans\n\n");
    }

    public static void main(String[] args) {
        String command = null;
        String input = null;
        int nextByte = 0;
        byte[] buf = new byte[4096];
        JmxShell shell = new JmxShell();
        if (args == null || args.length == 0) {
            shell.init();
        } else {
            ArrayList<String> arguments = new ArrayList<String>(Arrays.asList(args));
            shell.init(arguments);
        }
        shell.printLine("JMX CLIENT is ready.");
        s_input = System.in;
        while (true) {
            try {
                int cnt;
                do {
                    System.out.print("\njmxshell > ");
                    for (cnt = 0; cnt < 4096 && (nextByte = s_input.read()) != -1 && (char)nextByte != '\n'; ++cnt) {
                        buf[cnt] = (byte)nextByte;
                    }
                    if (nextByte != -1) continue;
                    input = CMD_EXIT;
                    break;
                } while ((input = new String(buf, 0, cnt)).startsWith(COMMENT));
                command = shell.parseInput(input);
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            shell.execute(command);
            shell.printLine("");
        }
    }

    static {
        s_output = new BufferedWriter(new OutputStreamWriter(System.out));
        CMD_LISTMBEANS = "listMBeans";
        CMD_LISTMBEANATTRIBUTES = "listMBeanAttributes";
        CMD_LISTMBEANINFO = "listMBeanInfo";
        CMD_GETATTRIBUTE = "getAttribute";
        CMD_GETATTRIBUTES = "getAttributes";
        CMD_GETMBEANCOUNT = "getMBeanCount";
        CMD_GETDEFAULTDOMAIN = "getDefaultDomain";
        CMD_GETOBJECTINSTANCE = "getObjectInstance";
        CMD_QUERYMBEANS = "queryMBeans";
        CMD_QUERYNAMES = "queryNames";
        CMD_SETATTRIBUTE = "setAttribute";
        CMD_INVOKEMETHOD = "invokeMethod";
        CMD_DUMPSTATS = "dumpStats";
        CMD_PRINT = "print";
        CMD_ECHO = "Echo";
        CMD_EXIT = "Exit";
        CMD_HELP = "help";
        env_echo = false;
        writeToFile = false;
    }
}

