/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.jmx.remote;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.remote.JMXConnectionNotification;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXServiceURL;
import javax.security.auth.Subject;
import oracle.oc4j.admin.jmx.client.Connector;
import oracle.oc4j.admin.jmx.client.HeartBeatEvent;
import oracle.oc4j.admin.jmx.client.HeartBeatListener;
import oracle.oc4j.admin.jmx.remote.api.JMXConnectorConstant;
import oracle.oc4j.admin.jmx.shared.Domain;

public abstract class JMXConnectorImpl
implements JMXConnector,
HeartBeatListener {
    protected static final int OC4J_DOMAIN = 1;
    protected static final int IAS_DOMAIN = 2;
    private Connector mbeanServercon_ = null;
    private Domain serverConDomain_ = null;
    private String conId_ = null;
    protected JMXServiceURL jmxUrl_ = null;
    private Map env_ = null;
    protected int domain_ = 1;
    protected String appName_ = null;
    protected String opmnOC4JInstance_ = null;
    protected String opmnASInstance_ = null;
    protected boolean opmnLookup_ = false;
    protected int opmnPort_ = 6003;
    protected String opmnHost_ = null;
    private NotificationBroadcasterSupport broadcaster_ = null;
    private long nextNotif_ = 0L;

    public JMXConnectorImpl(JMXServiceURL url, Map environment) {
        StringTokenizer stok;
        this.jmxUrl_ = url;
        this.env_ = environment;
        String urlpart = this.jmxUrl_.getURLPath();
        if (urlpart != null && (urlpart.indexOf("opmn") != -1 || urlpart.indexOf("OPMN") != -1)) {
            this.opmnLookup_ = true;
            StringTokenizer stok2 = new StringTokenizer(urlpart, ":");
            stok2.nextToken();
            String host = stok2.nextToken();
            if (host == null || host.length() < 2) {
                throw new IllegalArgumentException("Invalid URL: " + url);
            }
            this.opmnHost_ = host.substring(2);
            if (stok2.countTokens() > 0) {
                String portAndInstance = stok2.nextToken();
                StringTokenizer strTokb = new StringTokenizer(portAndInstance, "/");
                if (strTokb.countTokens() < 2) {
                    throw new IllegalArgumentException("Missing OPMN port or OC4J instance parameter in URL: " + url);
                }
                try {
                    this.opmnPort_ = Integer.parseInt(strTokb.nextToken());
                }
                catch (NumberFormatException ne) {
                    IllegalArgumentException iae = new IllegalArgumentException("Invalid OPMN port format in URL: " + url);
                    iae.initCause(ne);
                }
                this.opmnOC4JInstance_ = strTokb.nextToken();
                if ("cluster".equalsIgnoreCase(this.opmnOC4JInstance_)) {
                    this.opmnOC4JInstance_ = null;
                    this.domain_ = 2;
                    if (strTokb.countTokens() > 2) {
                        throw new IllegalArgumentException("Invalid JMX cluster URL: " + url);
                    }
                    if (strTokb.countTokens() == 2) {
                        this.opmnASInstance_ = strTokb.nextToken();
                        this.opmnOC4JInstance_ = strTokb.nextToken();
                    } else if (strTokb.countTokens() == 1) {
                        this.opmnOC4JInstance_ = strTokb.nextToken();
                    }
                } else if (strTokb.countTokens() > 0) {
                    this.appName_ = strTokb.nextToken();
                }
            } else {
                StringTokenizer strTokb = new StringTokenizer(this.opmnHost_, "/");
                if (strTokb.countTokens() < 2) {
                    throw new IllegalArgumentException("Missing OPMN host or OC4J instance parameter in URL: " + url);
                }
                this.opmnHost_ = strTokb.nextToken();
                this.opmnOC4JInstance_ = strTokb.nextToken();
                if ("cluster".equalsIgnoreCase(this.opmnOC4JInstance_)) {
                    this.opmnOC4JInstance_ = null;
                    this.domain_ = 2;
                    if (strTokb.countTokens() > 2) {
                        throw new IllegalArgumentException("Invalid JMX cluster URL: " + url);
                    }
                    if (strTokb.countTokens() == 2) {
                        this.opmnASInstance_ = strTokb.nextToken();
                        this.opmnOC4JInstance_ = strTokb.nextToken();
                    } else if (strTokb.countTokens() == 1) {
                        this.opmnOC4JInstance_ = strTokb.nextToken();
                    }
                } else if (strTokb.countTokens() > 0) {
                    this.appName_ = strTokb.nextToken();
                }
            }
            if (this.opmnHost_ == null || this.opmnHost_.length() == 0) {
                throw new IllegalArgumentException("Missing host parameter in URL: " + url);
            }
            if (this.domain_ == 1 && (this.opmnOC4JInstance_ == null || this.opmnOC4JInstance_.length() == 0)) {
                throw new IllegalArgumentException("Missing OC4J instance parameter in URL: " + url);
            }
        } else if (urlpart != null && urlpart.length() > 1 && (stok = new StringTokenizer(urlpart, "/")).hasMoreTokens()) {
            String md = stok.nextToken();
            if ("cluster".equalsIgnoreCase(md)) {
                this.domain_ = 2;
            }
            if ("oc4j".equalsIgnoreCase(md)) {
                if (stok.hasMoreTokens()) {
                    this.appName_ = stok.nextToken();
                }
            } else {
                throw new IllegalArgumentException("Invalid JMX URL: " + url);
            }
        }
        this.broadcaster_ = new NotificationBroadcasterSupport();
    }

    public final void addConnectionNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        this.broadcaster_.addNotificationListener(listener, filter, handback);
    }

    public final void removeConnectionNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.broadcaster_.removeNotificationListener(listener);
    }

    public final void removeConnectionNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.broadcaster_.removeNotificationListener(listener, filter, handback);
    }

    public final synchronized MBeanServerConnection getMBeanServerConnection() throws IOException {
        if (this.mbeanServercon_ == null) {
            throw new IOException("No connection currently established");
        }
        return this.mbeanServercon_;
    }

    public MBeanServerConnection getMBeanServerConnection(Subject delegateSubject) throws IOException {
        throw new UnsupportedOperationException("This method is currently not supported");
    }

    public final void connect() throws IOException {
        this.connect(this.env_);
    }

    public final synchronized void connect(Map env) throws IOException {
        Object credentials;
        String httpTunneling;
        if (this.mbeanServercon_ != null) {
            return;
        }
        Domain domain = this.getDomain(env);
        Locale loc = (Locale)env.get("com.oracle.jmx.remote.oc4j.locale");
        if (loc == null) {
            loc = Locale.getDefault();
        }
        domain.setLocale(loc);
        Boolean connectionCaching = (Boolean)env.get("com.oracle.jmx.remote.oc4j.connectioncaching");
        if (connectionCaching != null && Boolean.FALSE.equals(connectionCaching)) {
            domain.setConnectionCaching(false);
        }
        if ((httpTunneling = (String)env.get("com.oracle.jmx.remote.oc4j.httptunneling")) != null) {
            domain.setHttpTunnelingPath(httpTunneling);
        }
        this.copyProperties(domain, env, JMXConnectorConstant.RMI_PROPERTIES);
        this.mbeanServercon_ = this.getConnector(domain);
        this.serverConDomain_ = domain;
        this.mbeanServercon_.setJMXConnector(this);
        if (env == null) {
            throw new SecurityException("Missing credentials");
        }
        Object credentialsObj = env.get("jmx.remote.credentials");
        if (credentialsObj == null) {
            throw new SecurityException("Missing credentials");
        }
        String clientName = null;
        if (credentialsObj instanceof String[]) {
            credentials = (String[])credentialsObj;
            if (((String[])credentials).length > 0) {
                clientName = credentials[0];
            }
        } else if (credentialsObj instanceof Map) {
            credentials = (Map)credentialsObj;
            clientName = (String)credentials.get("login");
        }
        this.conId_ = this.jmxUrl_.getProtocol() + "://" + domain.getHost() + ':' + domain.getPort() + ' ' + clientName;
        JMXConnectionNotification notif = new JMXConnectionNotification("jmx.remote.connection.opened", this, this.getConnectionId(), this.nextNotif_++, "Connected", null);
        this.broadcaster_.sendNotification(notif);
    }

    private void copyProperties(Domain domain, Map env, String[] propertyNames) {
        if (propertyNames != null) {
            int propertyCount = propertyNames.length;
            for (int i = 0; i < propertyCount; ++i) {
                String propertyValue = (String)env.get(propertyNames[i]);
                if (propertyValue == null) continue;
                domain.addProperty(propertyNames[i], propertyValue);
            }
        }
    }

    public final synchronized void close() throws IOException {
        if (this.mbeanServercon_ == null) {
            return;
        }
        this.mbeanServercon_.release();
        JMXConnectionNotification notif = new JMXConnectionNotification("jmx.remote.connection.closed", this, this.getConnectionId(), this.nextNotif_++, "Disconnected", null);
        this.serverConDomain_ = null;
        this.mbeanServercon_ = null;
        this.conId_ = null;
        this.broadcaster_.sendNotification(notif);
    }

    public final String getConnectionId() throws IOException {
        if (this.serverConDomain_ != null) {
            return this.conId_;
        }
        throw new IOException("Connection not established");
    }

    public void handleEvent(HeartBeatEvent event) {
        JMXConnectionNotification notif = new JMXConnectionNotification("jmx.remote.connection.failed", this, this.conId_, this.nextNotif_++, "Connection failure", null);
        this.broadcaster_.sendNotification(notif);
        if (this.mbeanServercon_ != null) {
            this.mbeanServercon_.release();
        }
        this.serverConDomain_ = null;
        this.mbeanServercon_ = null;
        this.conId_ = null;
    }

    protected abstract Domain getDomain(Map var1);

    protected abstract Connector getConnector(Domain var1);
}

