/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.jmx.shared.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXRuntimeException;
import oracle.oc4j.util.FileUtils;

public class JarTool {
    private File _archive;
    private JarFile _jarFile;
    private String _unpackDirName = null;
    private Hashtable _tmpFiles;

    public JarTool(String archiveName) throws JMXRuntimeException {
        try {
            this.initArchiveFile(archiveName);
            this._tmpFiles = new Hashtable();
        }
        catch (Throwable t) {
            throw new JMXRuntimeException(t);
        }
    }

    public JarTool(File archive) throws JMXRuntimeException {
        try {
            this._archive = archive;
            this._jarFile = new JarFile(this._archive);
            this._tmpFiles = new Hashtable();
        }
        catch (Throwable t) {
            throw new JMXRuntimeException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JarTool createNewJarFile(String jarName) throws JMXRuntimeException {
        try {
            File jarFile = new File(jarName);
            if (!jarFile.createNewFile()) {
                throw new JMXRuntimeException("Cannot create jar file " + jarName + " since it already exists!");
            }
            ZipOutputStream jout = null;
            try {
                jout = new JarOutputStream((OutputStream)new FileOutputStream(jarFile), new Manifest());
            }
            finally {
                if (jout != null) {
                    jout.close();
                }
            }
            return new JarTool(jarFile);
        }
        catch (JMXRuntimeException e) {
            throw (JMXRuntimeException)e.fillInStackTrace();
        }
        catch (Throwable t) {
            throw new JMXRuntimeException(t);
        }
    }

    private void initArchiveFile(String archiveName) throws IllegalArgumentException, IOException {
        boolean canRead = false;
        try {
            this._archive = new File(archiveName);
            if (this._jarFile != null) {
                this._jarFile.close();
            }
            this._jarFile = new JarFile(this._archive);
        }
        catch (Exception e) {
            throw new JMXRuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean unjar(String dirName) throws JMXRuntimeException {
        File directory = null;
        boolean canAccess = false;
        try {
            directory = new File(dirName);
            if (directory.canWrite()) {
                canAccess = true;
            }
        }
        catch (NullPointerException npe) {
            throw new JMXRuntimeException("noArchiveName");
        }
        catch (SecurityException se) {
            throw new JMXRuntimeException(se);
        }
        if (!canAccess) {
            throw new JMXRuntimeException("File " + dirName + " not exist or does not have write access!");
        }
        if (dirName.charAt(dirName.length() - 1) != File.separatorChar) {
            dirName = dirName + File.separatorChar;
        }
        byte[] buf = new byte[1024];
        try {
            Enumeration<JarEntry> e = this._jarFile.entries();
            while (e.hasMoreElements()) {
                InputStream entryStream;
                block17: {
                    Object var12_15;
                    JarEntry entry = new JarEntry((ZipEntry)e.nextElement());
                    String entryName = dirName + entry.getName();
                    if (entry.isDirectory()) {
                        new File(entryName).mkdir();
                        continue;
                    }
                    File entryFile = new File(entryName);
                    if (!entryFile.exists()) {
                        try {
                            FileUtils.createNewFileRecursive((File)entryFile);
                        }
                        catch (IOException ioe) {
                            return false;
                        }
                    }
                    entryStream = null;
                    FileOutputStream fileStream = null;
                    try {
                        entryStream = this._jarFile.getInputStream(entry);
                        fileStream = new FileOutputStream(entryFile);
                        this.copy(entryStream, fileStream, buf);
                        var12_15 = null;
                        if (fileStream == null) break block17;
                    }
                    catch (Throwable throwable) {
                        var12_15 = null;
                        if (fileStream != null) {
                            fileStream.close();
                        }
                        if (entryStream != null) {
                            entryStream.close();
                        }
                        throw throwable;
                    }
                    fileStream.close();
                }
                if (entryStream == null) continue;
                entryStream.close();
            }
        }
        catch (Throwable t) {
            throw new JMXRuntimeException(t);
        }
        this._unpackDirName = dirName;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean rejar() throws JMXRuntimeException {
        if (this._unpackDirName == null) {
            return false;
        }
        File jarFile = this.createTemporaryJarFile();
        ZipOutputStream jos = null;
        try {
            jos = new JarOutputStream((OutputStream)new FileOutputStream(jarFile), this._jarFile.getManifest());
            this.addDirectoryContents(new File(this._unpackDirName), "", (JarOutputStream)jos, new byte[1024]);
            if (jos == null) return this.replaceArchive(jarFile);
        }
        catch (FileNotFoundException fnfe) {
            boolean bl;
            try {
                jarFile.delete();
                bl = false;
                if (jos == null) return bl;
            }
            catch (Throwable throwable) {
                try {
                    if (jos == null) throw throwable;
                    jos.close();
                    throw throwable;
                }
                catch (Throwable t) {
                    throw new JMXRuntimeException(t);
                }
            }
            jos.close();
            return bl;
        }
        jos.close();
        return this.replaceArchive(jarFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean rejar(String jarName) throws JMXRuntimeException {
        if (this._unpackDirName == null) {
            return false;
        }
        File jarFile = new File(jarName);
        try {
            FileUtils.createNewFileRecursive((File)jarFile);
        }
        catch (IOException e) {
            return false;
        }
        ZipOutputStream jos = null;
        try {
            jos = new JarOutputStream((OutputStream)new FileOutputStream(jarFile), this._jarFile.getManifest());
            this.addDirectoryContents(new File(this._unpackDirName), "", (JarOutputStream)jos, new byte[1024]);
            if (jos == null) return true;
        }
        catch (FileNotFoundException fnfe) {
            boolean bl;
            try {
                bl = false;
                if (jos == null) return bl;
            }
            catch (Throwable throwable) {
                try {
                    if (jos == null) throw throwable;
                    jos.close();
                    throw throwable;
                }
                catch (Throwable t) {
                    throw new JMXRuntimeException(t);
                }
            }
            jos.close();
            return bl;
        }
        jos.close();
        return true;
    }

    public String getJarName() {
        return this._archive.getPath();
    }

    public String getJarPath() {
        return this._archive.getAbsolutePath();
    }

    public Manifest getManifest() throws JMXRuntimeException {
        try {
            return this._jarFile.getManifest();
        }
        catch (Throwable t) {
            throw new JMXRuntimeException(t);
        }
    }

    public void delete() throws JMXRuntimeException {
        try {
            this._archive.delete();
        }
        catch (Throwable t) {
            throw new JMXRuntimeException(t);
        }
    }

    public Enumeration entries() {
        return this._jarFile.entries();
    }

    public Vector getEntryNames() {
        Enumeration<JarEntry> entries = this._jarFile.entries();
        Vector<String> entryNames = new Vector<String>();
        while (entries.hasMoreElements()) {
            ZipEntry zipEntry = entries.nextElement();
            entryNames.add(zipEntry.getName());
        }
        return entryNames;
    }

    public boolean hasEntry(String entryName) {
        return this._jarFile.getEntry(entryName) != null;
    }

    public InputStream readEntry(String entryName) throws JMXRuntimeException {
        try {
            ZipEntry entry = this._jarFile.getEntry(entryName);
            if (entry != null) {
                return this._jarFile.getInputStream(entry);
            }
            return null;
        }
        catch (Throwable t) {
            throw new JMXRuntimeException(t);
        }
    }

    public InputStream readEntry(String uri, String entryName) throws JMXRuntimeException {
        JarInputStream jis = null;
        try {
            InputStream uis = this.readEntry(uri);
            if (uis == null) {
                return null;
            }
            jis = new JarInputStream(uis);
            entryName = entryName.replace('\\', '/');
            JarEntry entry = null;
            boolean foundIt = false;
            while ((entry = jis.getNextJarEntry()) != null) {
                if (entry.getName().equals(entryName)) {
                    foundIt = true;
                    break;
                }
                entry = null;
                jis.closeEntry();
            }
            if (!foundIt) {
                return null;
            }
        }
        catch (Throwable t) {
            throw new JMXRuntimeException(t);
        }
        return jis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateEntry(String entryName, File file) throws JMXRuntimeException {
        try {
            File jarFile;
            ZipOutputStream jos;
            block14: {
                if (!this.hasEntry(entryName)) {
                    return false;
                }
                entryName = entryName.replace('\\', '/');
                JarInputStream jis = null;
                jos = null;
                jarFile = this.createTemporaryJarFile();
                try {
                    JarEntry entry;
                    jis = new JarInputStream(new FileInputStream(this._archive));
                    Manifest man = jis.getManifest();
                    jos = man == null ? new JarOutputStream(new FileOutputStream(jarFile)) : new JarOutputStream((OutputStream)new FileOutputStream(jarFile), man);
                    byte[] buffer = new byte[1024];
                    while ((entry = jis.getNextJarEntry()) != null) {
                        ((JarOutputStream)jos).putNextEntry(new JarEntry(entry.getName()));
                        if (entry.getName().equals(entryName)) {
                            FileInputStream fis = null;
                            try {
                                fis = new FileInputStream(file);
                                this.copy(fis, jos, buffer);
                                continue;
                            }
                            finally {
                                if (fis != null) {
                                    fis.close();
                                }
                                continue;
                            }
                        }
                        this.copy(jis, jos, buffer);
                    }
                    Object var13_12 = null;
                    if (jis == null) break block14;
                }
                catch (Throwable throwable) {
                    Object var13_13 = null;
                    if (jis != null) {
                        jis.close();
                    }
                    if (jos != null) {
                        jos.close();
                    }
                    throw throwable;
                }
                jis.close();
            }
            if (jos != null) {
                jos.close();
            }
            this.replaceArchive(jarFile);
            return true;
        }
        catch (Throwable t) {
            throw new JMXRuntimeException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeEntry(String entryName) throws JMXRuntimeException {
        try {
            File jarFile;
            ZipOutputStream jos;
            block9: {
                if (!this.hasEntry(entryName)) {
                    return false;
                }
                entryName = entryName.replace('\\', '/');
                JarInputStream jis = null;
                jos = null;
                jarFile = this.createTemporaryJarFile();
                try {
                    JarEntry entry;
                    jis = new JarInputStream(new FileInputStream(this._archive));
                    Manifest man = jis.getManifest();
                    jos = man == null ? new JarOutputStream(new FileOutputStream(jarFile)) : new JarOutputStream((OutputStream)new FileOutputStream(jarFile), man);
                    byte[] buffer = new byte[1024];
                    while ((entry = jis.getNextJarEntry()) != null) {
                        if (entry.getName().equals(entryName)) continue;
                        ((JarOutputStream)jos).putNextEntry(new JarEntry(entry.getName()));
                        this.copy(jis, jos, buffer);
                    }
                    Object var10_9 = null;
                    if (jis == null) break block9;
                }
                catch (Throwable throwable) {
                    Object var10_10 = null;
                    if (jis != null) {
                        jis.close();
                    }
                    if (jos != null) {
                        jos.close();
                    }
                    throw throwable;
                }
                jis.close();
            }
            if (jos != null) {
                jos.close();
            }
            this.replaceArchive(jarFile);
            return true;
        }
        catch (Throwable t) {
            throw new JMXRuntimeException(t);
        }
    }

    public File extractFile(String entryName, String destDir) throws JMXRuntimeException {
        try {
            if (destDir.charAt(destDir.length() - 1) != File.separatorChar) {
                destDir = destDir + File.separatorChar;
            }
            File extractedFile = new File(destDir + entryName);
            try {
                FileUtils.createNewFileRecursive((File)extractedFile);
                if (!this.extractFile(entryName, extractedFile)) {
                    extractedFile.delete();
                    return null;
                }
            }
            catch (FileNotFoundException fnfe) {
                extractedFile.delete();
                throw new JMXRuntimeException(fnfe);
            }
            catch (IOException ioe) {
                extractedFile.delete();
                throw new JMXRuntimeException(ioe);
            }
            return extractedFile;
        }
        catch (Throwable t) {
            throw new JMXRuntimeException(t);
        }
    }

    public File extractFile(String entryName) throws JMXRuntimeException {
        try {
            File tmp = (File)this._tmpFiles.get(entryName);
            if (tmp != null) {
                return tmp;
            }
            tmp = File.createTempFile("jar", ".tmp");
            if (this.extractFile(entryName, tmp)) {
                this._tmpFiles.put(entryName, tmp);
            } else {
                tmp.delete();
                tmp = null;
            }
            return tmp;
        }
        catch (Throwable t) {
            throw new JMXRuntimeException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean extractFile(String entryName, File file) throws JMXRuntimeException {
        try {
            ZipInputStream jis;
            FileInputStream fin;
            block16: {
                boolean bl;
                block14: {
                    block15: {
                        if (!this.hasEntry(entryName)) {
                            return false;
                        }
                        fin = null;
                        jis = null;
                        entryName = entryName.replace('\\', '/');
                        try {
                            fin = new FileInputStream(this._archive);
                            jis = new JarInputStream(fin);
                            JarEntry entry = null;
                            boolean foundIt = false;
                            while ((entry = ((JarInputStream)jis).getNextJarEntry()) != null) {
                                if (entry.getName().equals(entryName)) {
                                    foundIt = true;
                                    break;
                                }
                                entry = null;
                                jis.closeEntry();
                            }
                            if (!foundIt) {
                                bl = false;
                                Object var10_10 = null;
                                if (jis == null) break block14;
                                break block15;
                            }
                            FileOutputStream fos = null;
                            try {
                                fos = new FileOutputStream(file);
                                this.copy(jis, fos);
                                break block16;
                            }
                            finally {
                                if (fos != null) {
                                    fos.close();
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            Object var10_12 = null;
                            if (jis != null) {
                                jis.closeEntry();
                                jis.close();
                            }
                            if (fin == null) throw throwable;
                            fin.close();
                            throw throwable;
                        }
                    }
                    jis.closeEntry();
                    jis.close();
                }
                if (fin == null) return bl;
                fin.close();
                return bl;
            }
            Object var10_11 = null;
            if (jis != null) {
                jis.closeEntry();
                jis.close();
            }
            if (fin == null) return true;
            fin.close();
            return true;
        }
        catch (Throwable t) {
            throw new JMXRuntimeException(t);
        }
    }

    public void addFile(File file) throws JMXRuntimeException {
        try {
            this.addEntry(file.getPath(), file);
        }
        catch (Throwable t) {
            throw new JMXRuntimeException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntry(String entryName, File file) throws JMXRuntimeException {
        try {
            JarOutputStream jos = null;
            File tmpJar = this.createTemporaryJarFile();
            try {
                jos = this.copyContents(tmpJar);
                this.addFile(file, entryName.replace('\\', '/'), jos, new byte[1024]);
            }
            finally {
                if (jos != null) {
                    jos.close();
                }
            }
            this.replaceArchive(tmpJar);
        }
        catch (Throwable t) {
            throw new JMXRuntimeException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileRecursive(File file) throws JMXRuntimeException {
        try {
            JarOutputStream jos = null;
            File tmpJar = this.createTemporaryJarFile();
            byte[] buffer = new byte[1024];
            try {
                jos = this.copyContents(tmpJar);
                this.addFile(file, file.getPath(), jos, buffer);
                if (file.isDirectory()) {
                    this.addDirectoryContents(file, "", jos, buffer);
                }
            }
            finally {
                if (jos != null) {
                    jos.close();
                }
            }
            this.replaceArchive(tmpJar);
        }
        catch (Throwable t) {
            throw new JMXRuntimeException(t);
        }
    }

    public void addDirectoryContents(String dir) throws JMXRuntimeException {
        try {
            this.addDirectoryContents(new File(dir));
        }
        catch (Throwable t) {
            throw new JMXRuntimeException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDirectoryContents(File dir) throws JMXRuntimeException {
        try {
            if (!dir.isDirectory()) {
                throw new JMXRuntimeException(dir.getPath() + " is not a directory!");
            }
            JarOutputStream jos = null;
            File tmpJar = this.createTemporaryJarFile();
            try {
                jos = this.copyContents(tmpJar);
                this.addDirectoryContents(dir, "", jos, new byte[1024]);
            }
            finally {
                if (jos != null) {
                    jos.close();
                }
            }
            this.replaceArchive(tmpJar);
        }
        catch (Throwable t) {
            throw new JMXRuntimeException(t);
        }
    }

    public void close() {
        if (this._tmpFiles != null) {
            Enumeration e = this._tmpFiles.elements();
            while (e.hasMoreElements()) {
                File tmp = (File)e.nextElement();
                tmp.delete();
            }
            this._tmpFiles = null;
        }
        this._archive = null;
        if (this._jarFile != null) {
            try {
                this._jarFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this._jarFile = null;
        }
        System.gc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFile(File file, String entryName, JarOutputStream jos, byte[] buffer) throws FileNotFoundException, IOException, ZipException {
        entryName = entryName.replace('\\', '/');
        if (file.isDirectory() && entryName.charAt(entryName.length() - 1) != '/') {
            entryName = entryName + "/";
        }
        if (!entryName.equals("META-INF/") && !entryName.equals("META-INF/MANIFEST.MF")) {
            jos.putNextEntry(new JarEntry(entryName));
            if (!file.isDirectory()) {
                FileInputStream fileStream = null;
                try {
                    fileStream = new FileInputStream(file);
                    this.copy(fileStream, jos, buffer);
                }
                finally {
                    if (fileStream != null) {
                        fileStream.close();
                    }
                }
            }
        }
    }

    private void addDirectoryContents(File dir, String dirPrefix, JarOutputStream jos, byte[] buffer) throws IOException, ZipException {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File tmp = files[i];
            this.addFile(tmp, dirPrefix + tmp.getName(), jos, buffer);
            if (!tmp.isDirectory()) continue;
            String name = dirPrefix + tmp.getName() + "/";
            this.addDirectoryContents(tmp, name, jos, buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JarOutputStream copyContents(File jarFile) throws FileNotFoundException, IOException, ZipException {
        ZipInputStream jis = null;
        JarOutputStream jos = null;
        try {
            JarEntry entry;
            jis = new JarInputStream(new FileInputStream(this._archive));
            Manifest man = ((JarInputStream)jis).getManifest();
            jos = man == null ? new JarOutputStream(new FileOutputStream(jarFile)) : new JarOutputStream((OutputStream)new FileOutputStream(jarFile), man);
            byte[] buffer = new byte[1024];
            while ((entry = ((JarInputStream)jis).getNextJarEntry()) != null) {
                jos.putNextEntry(new JarEntry(entry.getName()));
                this.copy(jis, jos, buffer);
            }
        }
        finally {
            if (jis != null) {
                jis.close();
            }
        }
        return jos;
    }

    private File createTemporaryJarFile() throws IOException {
        int index = this._archive.getPath().lastIndexOf(File.separatorChar);
        File archiveDir = null;
        archiveDir = index > 0 ? new File(this._archive.getPath().substring(0, index)) : new File(".");
        File tmp = File.createTempFile("jar", ".jar", archiveDir);
        return tmp;
    }

    private boolean replaceArchive(File jarFile) throws IOException {
        this._jarFile.close();
        if (!this._archive.delete()) {
            return false;
        }
        if (!jarFile.renameTo(this._archive)) {
            return false;
        }
        this._jarFile = new JarFile(this._archive);
        return true;
    }

    private void copy(InputStream is, OutputStream os) throws IOException {
        this.copy(is, os, new byte[4096]);
    }

    private void copy(InputStream is, OutputStream os, byte[] buffer) throws IOException {
        int bytes;
        while ((bytes = is.read(buffer)) != -1) {
            os.write(buffer, 0, bytes);
        }
    }
}

