/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.api;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.factories.DeploymentFactoryManager;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import javax.management.MBeanException;
import javax.management.ObjectName;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.admin.deploy.api.J2EEDeploymentException;
import oracle.oc4j.admin.deploy.shared.util.DeploymentUtils;
import oracle.oc4j.admin.deploy.shared.util.FormattingResourceBundle;
import oracle.oc4j.admin.deploy.spi.ClusterDeploymentManager;
import oracle.oc4j.admin.deploy.spi.ClusterHelper;
import oracle.oc4j.admin.deploy.spi.ProprietaryConnectedDeploymentManager;
import oracle.oc4j.admin.deploy.spi.ProprietaryTarget;
import oracle.oc4j.admin.deploy.spi.TargetModuleIDImpl;
import oracle.oc4j.admin.deploy.spi.exceptions.DeploymentRuntimeException;
import oracle.oc4j.admin.deploy.spi.status.CmdlineProgressListener;
import oracle.oc4j.admin.deploy.spi.status.ProprietaryClientConfigurationImpl;
import oracle.oc4j.admin.jmx.client.Oc4jDomainFactory;
import oracle.oc4j.admin.jmx.shared.Domain;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXRuntimeException;
import oracle.oc4j.admin.management.shared.ImportSharedLibrary;
import oracle.oc4j.admin.management.shared.SharedLibrary;
import oracle.oc4j.admin.management.shared.SharedModuleType;

public class J2EEDeploymentManager {
    private String _uri;
    private String _user;
    private String _pwd;
    private ProprietaryConnectedDeploymentManager _deplMgr;
    private Target[] _targets;
    private Domain _domain;
    private Logger _logger = TraceLogger.getLogger((Class)J2EEDeploymentManager.class);
    private OutputStream _out = System.out;
    private static final String DEFAULT_TIMEOUT_VAL = "0";
    private static final String DEFAULT_GRACEFUL_VAL = "true";
    private static final String TIMEOUT = "timeout";
    private static final String GRACEFUL = "graceful";

    public J2EEDeploymentManager(String uri, String user, String pwd) throws J2EEDeploymentException {
        this._uri = uri;
        this._user = user;
        this._pwd = pwd;
        if (System.getProperty("java.util.logging.config.file") == null && System.getProperty("java.util.logging.config.class") == null) {
            this._logger.getParent().setLevel(Level.OFF);
        }
        try {
            DeploymentFactoryManager facMgr = DeploymentUtils.getDeploymentFactoryManager();
            this._deplMgr = (ProprietaryConnectedDeploymentManager)facMgr.getDeploymentManager(uri, user, pwd);
            this._targets = this._deplMgr.getTargets();
        }
        catch (DeploymentManagerCreationException de) {
            String msg = FormattingResourceBundle.DeploymentMessages.getString("validateuri_failed", new String[]{de.getMessage()});
            if (this._logger.isLoggable(Level.SEVERE)) {
                this._logger.log(Level.SEVERE, msg, de);
            }
            throw new J2EEDeploymentException(msg, de);
        }
        try {
            this._domain = Oc4jDomainFactory.getDomainFromDeployerUrl(uri, user, pwd);
        }
        catch (Throwable t) {
            String msg = FormattingResourceBundle.DeploymentMessages.getString("unable_to_get_domain", new String[]{uri, t.getMessage()});
            if (this._logger.isLoggable(Level.SEVERE)) {
                this._logger.log(Level.SEVERE, msg, t);
            }
            throw new J2EEDeploymentException(msg, t);
        }
    }

    public void release() {
        if (this._deplMgr != null) {
            this._deplMgr.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(String deployFilePath, String deployName, Map extraParams, boolean serialized) throws J2EEDeploymentException {
        block25: {
            if (!(this._deplMgr instanceof ClusterDeploymentManager) && serialized) {
                String msg = FormattingResourceBundle.DeploymentMessages.getString("sequential_not_for_noncluster");
                if (this._logger.isLoggable(Level.WARNING)) {
                    this._logger.log(Level.WARNING, msg);
                }
                serialized = false;
            }
            try {
                File deployFile = new File(deployFilePath);
                if (!deployFile.exists()) {
                    throw new J2EEDeploymentException(FormattingResourceBundle.DeploymentMessages.getString("unable_to_find_archive", new String[]{deployFilePath}));
                }
                SharedModuleType type = this.validateModuleType(deployFilePath);
                ByteArrayInputStream deploymentPlanIn = DeploymentUtils.getDeploymentPlan(deployName, extraParams, type);
                ProgressObject po = null;
                if (!serialized) {
                    String monitor = "monitor";
                    CmdlineProgressListener listener = new CmdlineProgressListener(this._out, monitor);
                    po = this._deplMgr.distribute(this._targets, deployFile, (InputStream)deploymentPlanIn, (ProgressListener)listener);
                    String string = monitor;
                    synchronized (string) {
                        block24: {
                            if (!listener.isCompleted()) {
                                try {
                                    monitor.wait();
                                }
                                catch (InterruptedException ie) {
                                    if (!this._logger.isLoggable(Level.FINEST)) break block24;
                                    this._logger.log(Level.FINEST, "Ignored InterrupedException.");
                                }
                            }
                        }
                    }
                    DeploymentStatus status = po.getDeploymentStatus();
                    if (status.isFailed()) {
                        throw new J2EEDeploymentException(status.getMessage());
                    }
                    if (extraParams != null && extraParams.get("iiopClientJarPath") != null) {
                        this.writeIIOPClientJar(po, deployName, (String)extraParams.get("iiopClientJarPath"));
                    }
                    break block25;
                }
                DeploymentManager[] deplMgrs = ClusterHelper.getConfigSetDeploymentManagers(this._uri, this._user, this._pwd, Locale.getDefault());
                for (int i = 0; i < deplMgrs.length; ++i) {
                    String monitor = "monitor";
                    ProprietaryConnectedDeploymentManager mgr = (ProprietaryConnectedDeploymentManager)deplMgrs[i];
                    CmdlineProgressListener listener = new CmdlineProgressListener(this._out, monitor);
                    po = mgr.distribute(this._targets, deployFile, (InputStream)deploymentPlanIn, (ProgressListener)listener);
                    String string = monitor;
                    synchronized (string) {
                        block26: {
                            if (!listener.isCompleted()) {
                                try {
                                    monitor.wait();
                                }
                                catch (InterruptedException ie) {
                                    if (!this._logger.isLoggable(Level.FINEST)) break block26;
                                    this._logger.log(Level.FINEST, "Ignored InterrupedException.");
                                }
                            }
                        }
                    }
                    DeploymentStatus status = po.getDeploymentStatus();
                    if (status.isFailed()) {
                        throw new J2EEDeploymentException(status.getMessage());
                    }
                    if (extraParams != null && extraParams.get("iiopClientJarPath") != null && i == 0) {
                        this.writeIIOPClientJar(po, deployName, (String)extraParams.get("iiopClientJarPath"));
                    }
                    if (i >= deplMgrs.length - 1) continue;
                    this.waitDelay(this._out, extraParams);
                }
            }
            catch (Throwable t) {
                String msg = FormattingResourceBundle.DeploymentMessages.getString("deploy_error", new String[]{t.getMessage()});
                if (this._logger.isLoggable(Level.SEVERE)) {
                    this._logger.log(Level.SEVERE, msg, t);
                }
                throw new J2EEDeploymentException(msg, t);
            }
        }
    }

    public void deploy(String deployFilePath, String deployName, Map extraParams, String deploymentPlanPath, boolean serialized) throws J2EEDeploymentException {
        File deploymentPlan = new File(deploymentPlanPath);
        if (!deploymentPlan.exists()) {
            throw new J2EEDeploymentException(FormattingResourceBundle.DeploymentMessages.getString("unable_to_find_deployment_plan", new String[]{deploymentPlanPath}));
        }
        if (deploymentPlan.isDirectory()) {
            throw new J2EEDeploymentException(FormattingResourceBundle.DeploymentMessages.getString("deployment_plan_can_not_be_directory", new String[]{deploymentPlanPath}));
        }
        FileInputStream planStream = null;
        try {
            planStream = new FileInputStream(new File(deploymentPlanPath));
        }
        catch (FileNotFoundException ex) {
            throw new J2EEDeploymentException(ex);
        }
        this.deploy(deployFilePath, deployName, extraParams, planStream, serialized);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(String deployFilePath, String deployName, Map extraParams, InputStream deploymentPlan, boolean serialized) throws J2EEDeploymentException {
        block25: {
            if (!(this._deplMgr instanceof ClusterDeploymentManager) && serialized) {
                String msg = FormattingResourceBundle.DeploymentMessages.getString("sequential_not_for_noncluster");
                if (this._logger.isLoggable(Level.WARNING)) {
                    this._logger.log(Level.WARNING, msg);
                }
                serialized = false;
            }
            try {
                File deployFile = new File(deployFilePath);
                if (!deployFile.exists()) {
                    throw new J2EEDeploymentException(FormattingResourceBundle.DeploymentMessages.getString("unable_to_find_archive", new String[]{deployFilePath}));
                }
                ProgressObject po = null;
                if (!serialized) {
                    HashMap params;
                    String monitor = "monitor";
                    CmdlineProgressListener listener = new CmdlineProgressListener(this._out, monitor);
                    po = this._deplMgr.distribute(this._targets, deployFile, deploymentPlan, (ProgressListener)listener);
                    String string = monitor;
                    synchronized (string) {
                        block24: {
                            if (!listener.isCompleted()) {
                                try {
                                    monitor.wait();
                                }
                                catch (InterruptedException ie) {
                                    if (!this._logger.isLoggable(Level.FINEST)) break block24;
                                    this._logger.log(Level.FINEST, "Ignored InterrupedException.");
                                }
                            }
                        }
                    }
                    DeploymentStatus status = po.getDeploymentStatus();
                    if (status.isFailed()) {
                        throw new J2EEDeploymentException(status.getMessage());
                    }
                    HashMap planAttributes = DeploymentUtils.parseDeploymentPlan((Object)deploymentPlan, deployName);
                    if (planAttributes != null && planAttributes.get("extraParams") != null && (params = (HashMap)planAttributes.get("extraParams")) != null && params.get("iiopClientJarPath") != null) {
                        this.writeIIOPClientJar(po, deployName, (String)params.get("iiopClientJarPath"));
                    }
                    break block25;
                }
                DeploymentManager[] deplMgrs = ClusterHelper.getConfigSetDeploymentManagers(this._uri, this._user, this._pwd, Locale.getDefault());
                for (int i = 0; i < deplMgrs.length; ++i) {
                    HashMap params;
                    String monitor = "monitor";
                    ProprietaryConnectedDeploymentManager mgr = (ProprietaryConnectedDeploymentManager)deplMgrs[i];
                    CmdlineProgressListener listener = new CmdlineProgressListener(this._out, monitor);
                    po = mgr.distribute(this._targets, deployFile, deploymentPlan, (ProgressListener)listener);
                    String string = monitor;
                    synchronized (string) {
                        block26: {
                            if (!listener.isCompleted()) {
                                try {
                                    monitor.wait();
                                }
                                catch (InterruptedException ie) {
                                    if (!this._logger.isLoggable(Level.FINEST)) break block26;
                                    this._logger.log(Level.FINEST, "Ignored InterrupedException.");
                                }
                            }
                        }
                    }
                    DeploymentStatus status = po.getDeploymentStatus();
                    if (status.isFailed()) {
                        throw new J2EEDeploymentException(status.getMessage());
                    }
                    HashMap planAttributes = DeploymentUtils.parseDeploymentPlan((Object)deploymentPlan, deployName);
                    if (planAttributes != null && planAttributes.get("extraParams") != null && (params = (HashMap)planAttributes.get("extraParams")) != null && params.get("iiopClientJarPath") != null) {
                        this.writeIIOPClientJar(po, deployName, (String)params.get("iiopClientJarPath"));
                    }
                    if (i >= deplMgrs.length - 1) continue;
                    this.waitDelay(this._out, extraParams);
                }
            }
            catch (Throwable t) {
                String msg = FormattingResourceBundle.DeploymentMessages.getString("deploy_error", new String[]{t.getMessage()});
                if (this._logger.isLoggable(Level.SEVERE)) {
                    this._logger.log(Level.SEVERE, msg, t);
                }
                throw new J2EEDeploymentException(msg, t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redeploy(String deployFilePath, String deployName, Map extraParams, boolean keepsettings, boolean serialized) throws J2EEDeploymentException {
        block26: {
            if (!(this._deplMgr instanceof ClusterDeploymentManager) && serialized) {
                String msg = FormattingResourceBundle.DeploymentMessages.getString("sequential_not_for_noncluster");
                if (this._logger.isLoggable(Level.WARNING)) {
                    this._logger.log(Level.WARNING, msg);
                }
                serialized = false;
            }
            try {
                File deployFile = new File(deployFilePath);
                if (!deployFile.exists()) {
                    throw new J2EEDeploymentException(FormattingResourceBundle.DeploymentMessages.getString("unable_to_find_archive", new String[]{deployFilePath}));
                }
                SharedModuleType moduleType = this.validateModuleType(deployFilePath);
                TargetModuleID[] tmids = null;
                if (moduleType.isRar()) {
                    String pattn = "*:j2eeType=ResourceAdapterModule,name=" + deployName + ",J2EEApplication=default,J2EEServer=";
                    tmids = this.getTargetModuleIDsForPattern(pattn, this._targets);
                } else {
                    tmids = this.getTargetModuleIDsForApplication(deployName, this._targets);
                }
                if (tmids == null || tmids.length == 0) {
                    String type = moduleType.isRar() ? "Connector" : "Application";
                    throw new J2EEDeploymentException(FormattingResourceBundle.DeploymentMessages.getString("application_not_exist", new String[]{"redeploy", type, deployName}));
                }
                ByteArrayInputStream configInputStream = deployFile.isDirectory() || !keepsettings ? DeploymentUtils.getDeploymentPlan(deployName, extraParams, moduleType) : DeploymentUtils.getDeploymentPlan(this._deplMgr, deployFile, tmids, extraParams, deployName);
                ProgressObject po = null;
                if (!serialized) {
                    String monitor = "monitor";
                    CmdlineProgressListener listener = new CmdlineProgressListener(this._out, monitor);
                    po = this._deplMgr.redeploy(tmids, deployFile, configInputStream, (ProgressListener)listener, keepsettings);
                    String string = monitor;
                    synchronized (string) {
                        block25: {
                            if (!listener.isCompleted()) {
                                try {
                                    monitor.wait();
                                }
                                catch (InterruptedException ie) {
                                    if (!this._logger.isLoggable(Level.FINEST)) break block25;
                                    this._logger.log(Level.FINEST, "Ignored InterrupedException.");
                                }
                            }
                        }
                    }
                    DeploymentStatus status = po.getDeploymentStatus();
                    if (status.isFailed()) {
                        throw new J2EEDeploymentException(status.getMessage());
                    }
                    break block26;
                }
                DeploymentManager[] deplMgrs = ClusterHelper.getConfigSetDeploymentManagers(this._uri, this._user, this._pwd, Locale.getDefault());
                for (int i = 0; i < deplMgrs.length; ++i) {
                    String monitor = "monitor";
                    CmdlineProgressListener listener = new CmdlineProgressListener(this._out, monitor);
                    po = ((ProprietaryConnectedDeploymentManager)deplMgrs[i]).redeploy(tmids, deployFile, configInputStream, (ProgressListener)listener, keepsettings);
                    String string = monitor;
                    synchronized (string) {
                        block27: {
                            if (!listener.isCompleted()) {
                                try {
                                    monitor.wait();
                                }
                                catch (InterruptedException ie) {
                                    if (!this._logger.isLoggable(Level.FINEST)) break block27;
                                    this._logger.log(Level.FINEST, "Ignored InterrupedException.");
                                }
                            }
                        }
                    }
                    DeploymentStatus status = po.getDeploymentStatus();
                    if (status.isFailed()) {
                        throw new J2EEDeploymentException(status.getMessage());
                    }
                    if (i >= deplMgrs.length - 1) continue;
                    this.waitDelay(this._out, extraParams);
                }
            }
            catch (Throwable t) {
                String msg = FormattingResourceBundle.DeploymentMessages.getString("redeploy_failed", new String[]{t.getMessage()});
                if (this._logger.isLoggable(Level.SEVERE)) {
                    this._logger.log(Level.SEVERE, msg, t);
                }
                throw new J2EEDeploymentException(msg, t);
            }
        }
    }

    protected SharedModuleType validateModuleType(String deployFilePath) throws J2EEDeploymentException {
        SharedModuleType type;
        if (deployFilePath == null) {
            return SharedModuleType.EAR;
        }
        File deployFile = new File(deployFilePath);
        if (deployFile.isDirectory()) {
            type = SharedModuleType.EAR;
        } else {
            if (!deployFile.exists()) {
                throw new J2EEDeploymentException(FormattingResourceBundle.DeploymentMessages.getString("unable_to_find_archive", new String[]{deployFilePath}));
            }
            type = DeploymentUtils.getSharedModuleType(deployFilePath);
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeploy(String deployName, boolean isConnector) throws J2EEDeploymentException {
        try {
            TargetModuleID[] tids;
            if (isConnector) {
                String pattn = "*:j2eeType=ResourceAdapterModule,name=" + deployName + ",J2EEApplication=default,J2EEServer=";
                tids = this.getTargetModuleIDsForPattern(pattn, this._targets);
            } else {
                tids = this.getTargetModuleIDsForApplication(deployName, this._targets);
            }
            if (tids == null || tids.length == 0) {
                String type = isConnector ? "Connector" : "Application";
                throw new J2EEDeploymentException(FormattingResourceBundle.DeploymentMessages.getString("undeploy_application_not_exist", new String[]{type, deployName}));
            }
            String monitor = "monitor";
            CmdlineProgressListener listener = new CmdlineProgressListener(this._out, monitor);
            ProgressObject progObject = this._deplMgr.undeploy(tids, listener);
            String string = monitor;
            synchronized (string) {
                block13: {
                    if (!listener.isCompleted()) {
                        try {
                            monitor.wait();
                        }
                        catch (InterruptedException ie) {
                            if (!this._logger.isLoggable(Level.FINEST)) break block13;
                            this._logger.log(Level.FINEST, "Ignored InterrupedException.");
                        }
                    }
                }
            }
            DeploymentStatus status = progObject.getDeploymentStatus();
            if (status.isFailed()) {
                throw new J2EEDeploymentException(status.getMessage());
            }
        }
        catch (Throwable t) {
            String msg = FormattingResourceBundle.DeploymentMessages.getString("undeploy_failed", new String[]{t.getMessage()});
            if (this._logger.isLoggable(Level.SEVERE)) {
                this._logger.log(Level.SEVERE, msg, t);
            }
            throw new J2EEDeploymentException(msg, t);
        }
    }

    public void bindWebApp(String appName, String siteName) throws J2EEDeploymentException {
        this.bindWebApp(appName, siteName, null);
    }

    public void bindWebApp(String appName, String siteName, HashMap optionalParams) throws J2EEDeploymentException {
        try {
            TargetModuleID[] tids = this.getTargetModuleIDsForApplication(appName, this._targets);
            if (tids == null || tids.length == 0) {
                throw new J2EEDeploymentException(FormattingResourceBundle.DeploymentMessages.getString("application_not_exist", new String[]{"bindWebApp", "", appName}));
            }
            this._deplMgr.bindWebApp(tids, siteName, optionalParams);
        }
        catch (JMXRuntimeException e) {
            MBeanException cause = (MBeanException)e.getCause();
            Exception tgtCause = cause.getTargetException();
            String msg = FormattingResourceBundle.DeploymentMessages.getString("bindwebapp_failed", new String[]{cause.getMessage() + "\n" + tgtCause.getMessage()});
            if (this._logger.isLoggable(Level.SEVERE)) {
                this._logger.log(Level.SEVERE, msg, e);
            }
            throw new J2EEDeploymentException(msg, e);
        }
        catch (Throwable t) {
            String msg = FormattingResourceBundle.DeploymentMessages.getString("bindwebapp_failed", new String[]{t.getMessage()});
            if (this._logger.isLoggable(Level.SEVERE)) {
                this._logger.log(Level.SEVERE, msg, t);
            }
            throw new J2EEDeploymentException(msg, t);
        }
    }

    public void bindWebApp(String appName, String webModuleName, String siteName, String contextRoot) throws J2EEDeploymentException {
        this.bindWebApp(appName, webModuleName, siteName, contextRoot, null);
    }

    public void bindWebApp(String appName, String webModuleName, String siteName, String contextRoot, HashMap optionalParams) throws J2EEDeploymentException {
        try {
            TargetModuleID[] tids = this.getTargetModuleIDsForApplication(appName, this._targets);
            if (tids == null || tids.length == 0) {
                throw new J2EEDeploymentException(FormattingResourceBundle.DeploymentMessages.getString("application_not_exist", new String[]{"updateEJBModule", "", appName}));
            }
            String pattn = "*:j2eeType=WebModule,name=" + webModuleName + ",J2EEApplication=" + appName + ",J2EEServer=";
            tids = this.getTargetModuleIDsForPattern(pattn, this._targets);
            if (tids == null || tids.length == 0) {
                pattn = "*:j2eeType=EJBModule,name=" + ObjectName.quote(webModuleName) + ",J2EEApplication=" + appName + ",J2EEServer=";
                tids = this.getTargetModuleIDsForPattern(pattn, this._targets);
            }
            if (tids == null || tids.length == 0) {
                throw new J2EEDeploymentException(FormattingResourceBundle.DeploymentMessages.getString("module_does_not_exist", new String[]{webModuleName, appName}));
            }
            this._deplMgr.bindWebApp(tids, siteName, contextRoot, optionalParams);
        }
        catch (JMXRuntimeException e) {
            MBeanException cause = (MBeanException)e.getCause();
            Exception tgtCause = cause.getTargetException();
            String msg = FormattingResourceBundle.DeploymentMessages.getString("bindwebapp_failed", new String[]{cause.getMessage() + "\n" + tgtCause.getMessage()});
            if (this._logger.isLoggable(Level.SEVERE)) {
                this._logger.log(Level.SEVERE, msg, e);
            }
            throw new J2EEDeploymentException(msg, e);
        }
        catch (Throwable t) {
            String msg = FormattingResourceBundle.DeploymentMessages.getString("bindwebapp_failed", new String[]{t.getMessage()});
            if (this._logger.isLoggable(Level.SEVERE)) {
                this._logger.log(Level.SEVERE, msg, t);
            }
            throw new J2EEDeploymentException(msg, t);
        }
    }

    public void restartApplication(String appName, Map params) throws J2EEDeploymentException {
        this.stopApplication(appName, params);
        this.startApplication(appName);
    }

    public void unbindWebApp(String appName, String webModuleName, String siteName) throws J2EEDeploymentException {
        try {
            TargetModuleID[] tids = this.getTargetModuleIDsForApplication(appName, this._targets);
            if (tids == null || tids.length == 0) {
                throw new J2EEDeploymentException(FormattingResourceBundle.DeploymentMessages.getString("application_not_exist", new String[]{"unbindWebApp", "", appName}));
            }
            String pattn = "*:j2eeType=WebModule,name=" + webModuleName + ",J2EEApplication=" + appName + ",J2EEServer=";
            tids = this.getTargetModuleIDsForPattern(pattn, this._targets);
            if (tids == null || tids.length == 0) {
                pattn = "*:j2eeType=EJBModule,name=" + ObjectName.quote(webModuleName) + ",J2EEApplication=" + appName + ",J2EEServer=";
                tids = this.getTargetModuleIDsForPattern(pattn, this._targets);
            }
            if (tids == null || tids.length == 0) {
                throw new J2EEDeploymentException(FormattingResourceBundle.DeploymentMessages.getString("module_does_not_exist", new String[]{webModuleName, appName}));
            }
            this._deplMgr.unbindWebApp(tids, siteName);
        }
        catch (JMXRuntimeException e) {
            MBeanException cause = (MBeanException)e.getCause();
            Exception tgtCause = cause.getTargetException();
            String msg = FormattingResourceBundle.DeploymentMessages.getString("unbindwebapp_failed", new String[]{cause.getMessage() + "\n" + tgtCause.getMessage()});
            if (this._logger.isLoggable(Level.SEVERE)) {
                this._logger.log(Level.SEVERE, msg, e);
            }
            throw new J2EEDeploymentException(msg, e);
        }
        catch (Throwable t) {
            String msg = FormattingResourceBundle.DeploymentMessages.getString("unbindwebapp_failed", new String[]{t.getMessage()});
            if (this._logger.isLoggable(Level.SEVERE)) {
                this._logger.log(Level.SEVERE, msg, t);
            }
            throw new J2EEDeploymentException(msg, t);
        }
    }

    public void unbindWebApp(String appName, String siteName) throws J2EEDeploymentException {
        try {
            TargetModuleID[] tids = this.getTargetModuleIDsForApplication(appName, this._targets);
            if (tids == null || tids.length == 0) {
                throw new J2EEDeploymentException(FormattingResourceBundle.DeploymentMessages.getString("application_not_exist", new String[]{"unbindWebApp", "", appName}));
            }
            this._deplMgr.unbindWebApp(tids, siteName);
        }
        catch (JMXRuntimeException e) {
            MBeanException cause = (MBeanException)e.getCause();
            Exception tgtCause = cause.getTargetException();
            String msg = FormattingResourceBundle.DeploymentMessages.getString("unbindwebapp_failed", new String[]{cause.getMessage() + "\n" + tgtCause.getMessage()});
            if (this._logger.isLoggable(Level.SEVERE)) {
                this._logger.log(Level.SEVERE, msg, e);
            }
            throw new J2EEDeploymentException(msg, e);
        }
        catch (Throwable t) {
            String msg = FormattingResourceBundle.DeploymentMessages.getString("unbindwebapp_failed", new String[]{t.getMessage()});
            if (this._logger.isLoggable(Level.SEVERE)) {
                this._logger.log(Level.SEVERE, msg, t);
            }
            throw new J2EEDeploymentException(msg, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startApplication(String appName) throws J2EEDeploymentException {
        try {
            TargetModuleID[] tids = this.getTargetModuleIDsForApplication(appName, this._targets);
            if (tids == null || tids.length == 0) {
                throw new J2EEDeploymentException(FormattingResourceBundle.DeploymentMessages.getString("application_not_exist", new String[]{"start", "", appName}));
            }
            String monitor = "monitor";
            CmdlineProgressListener listener = new CmdlineProgressListener(this._out, monitor);
            ProgressObject progObject = this._deplMgr.start(tids, (ProgressListener)listener);
            String string = monitor;
            synchronized (string) {
                block11: {
                    if (!listener.isCompleted()) {
                        try {
                            monitor.wait();
                        }
                        catch (InterruptedException ie) {
                            if (!this._logger.isLoggable(Level.FINEST)) break block11;
                            this._logger.log(Level.FINEST, "Ignored InterrupedException.");
                        }
                    }
                }
            }
            DeploymentStatus status = progObject.getDeploymentStatus();
            if (status.isFailed()) {
                throw new J2EEDeploymentException(status.getMessage());
            }
        }
        catch (JMXRuntimeException je) {
            Throwable t = je.getCause();
            String msg = FormattingResourceBundle.DeploymentMessages.getString("cannot_start_application", new String[]{appName, t.getMessage()});
            if (this._logger.isLoggable(Level.SEVERE)) {
                this._logger.log(Level.SEVERE, msg, t);
            }
            throw new J2EEDeploymentException(msg, t);
        }
    }

    public void stopApplication(String appName) throws J2EEDeploymentException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(TIMEOUT, DEFAULT_TIMEOUT_VAL);
        params.put(GRACEFUL, DEFAULT_GRACEFUL_VAL);
        this.stopApplication(appName, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopApplication(String appName, Map params) throws J2EEDeploymentException {
        try {
            TargetModuleID[] tids = this.getTargetModuleIDsForApplication(appName, this._targets);
            if (tids == null || tids.length == 0) {
                throw new J2EEDeploymentException(FormattingResourceBundle.DeploymentMessages.getString("application_not_exist", new String[]{"stop", "", appName}));
            }
            String monitor = "monitor";
            CmdlineProgressListener listener = new CmdlineProgressListener(this._out, monitor);
            ProgressObject progObject = this._deplMgr.stop(tids, listener, params);
            String string = monitor;
            synchronized (string) {
                block11: {
                    if (!listener.isCompleted()) {
                        try {
                            monitor.wait();
                        }
                        catch (InterruptedException ie) {
                            if (!this._logger.isLoggable(Level.FINEST)) break block11;
                            this._logger.log(Level.FINEST, "Ignored InterrupedException.");
                        }
                    }
                }
            }
            DeploymentStatus status = progObject.getDeploymentStatus();
            if (status.isFailed()) {
                throw new J2EEDeploymentException(status.getMessage());
            }
        }
        catch (JMXRuntimeException je) {
            Throwable t = je.getCause();
            String msg = FormattingResourceBundle.DeploymentMessages.getString("cannot_stop_application", new String[]{appName, t.getMessage()});
            if (this._logger.isLoggable(Level.SEVERE)) {
                this._logger.log(Level.SEVERE, msg, t);
            }
            throw new J2EEDeploymentException(msg, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEJBModule(String appName, String moduleName, String jarFilePath) throws J2EEDeploymentException {
        try {
            String pattn;
            TargetModuleID[] tids = this.getTargetModuleIDsForApplication(appName, this._targets);
            if (tids == null || tids.length == 0) {
                throw new J2EEDeploymentException(FormattingResourceBundle.DeploymentMessages.getString("application_not_exist", new String[]{"updateEJBModule", "", appName}));
            }
            String shortModuleName = moduleName;
            if (moduleName.endsWith(".jar")) {
                shortModuleName = moduleName.substring(0, moduleName.length() - 4);
            }
            if ((tids = this.getTargetModuleIDsForPattern(pattn = "*:j2eeType=EJBModule,name=\"" + shortModuleName + "\",J2EEApplication=" + appName + ",J2EEServer=", this._targets)) == null || tids.length == 0) {
                throw new J2EEDeploymentException(FormattingResourceBundle.DeploymentMessages.getString("ejbmodule_not_exist", new String[]{moduleName, appName}));
            }
            String monitor = "monitor";
            CmdlineProgressListener listener = new CmdlineProgressListener(this._out, monitor);
            ProgressObject progObject = this._deplMgr.updateEJBModule(appName, moduleName, jarFilePath, listener);
            String string = monitor;
            synchronized (string) {
                block13: {
                    if (!listener.isCompleted()) {
                        try {
                            monitor.wait();
                        }
                        catch (InterruptedException ie) {
                            if (!this._logger.isLoggable(Level.FINEST)) break block13;
                            this._logger.log(Level.FINEST, "Ignored InterrupedException.");
                        }
                    }
                }
            }
            DeploymentStatus status = progObject.getDeploymentStatus();
            if (status.isFailed()) {
                throw new J2EEDeploymentException(status.getMessage());
            }
        }
        catch (Throwable t) {
            String msg = FormattingResourceBundle.DeploymentMessages.getString("updateEJBModule_failed", new String[]{t.getMessage()});
            if (this._logger.isLoggable(Level.SEVERE)) {
                this._logger.log(Level.SEVERE, msg, t);
            }
            throw new J2EEDeploymentException(msg, t);
        }
    }

    public boolean modifySharedLibrary(String name, String version, Boolean libraryCompatible, String[] installCodeSources, String[] addCodeSources, String[] removeCodeSources, ImportSharedLibrary[] addImports, String[] removeImports) throws J2EEDeploymentException {
        File[] codeSourceFiles = new File[installCodeSources.length];
        for (int i = 0; i < installCodeSources.length; ++i) {
            File codeSourceFile = new File(installCodeSources[i]);
            if (!codeSourceFile.exists()) {
                String msg = FormattingResourceBundle.DeploymentMessages.getString("modifysharedlibrary_not_find_archive", new String[]{codeSourceFile.getAbsolutePath()});
                throw new J2EEDeploymentException(msg);
            }
            if (codeSourceFile.isDirectory()) {
                String msg = FormattingResourceBundle.DeploymentMessages.getString("modifycodesource_not_be_directory", new String[]{codeSourceFile.getAbsolutePath()});
                throw new J2EEDeploymentException(msg);
            }
            codeSourceFiles[i] = codeSourceFile;
        }
        try {
            return this._deplMgr.modifySharedLibrary(this._deplMgr.getTargets(), name, version, libraryCompatible, codeSourceFiles, addCodeSources, removeCodeSources, addImports, removeImports);
        }
        catch (Throwable t) {
            String msg = FormattingResourceBundle.DeploymentMessages.getString("modifysharedlibrary_failed", new String[]{t.getMessage()});
            if (this._logger.isLoggable(Level.SEVERE)) {
                this._logger.log(Level.SEVERE, msg, t);
            }
            throw new J2EEDeploymentException(msg, t);
        }
    }

    public SharedLibrary[] getSharedLibraries() throws J2EEDeploymentException {
        SharedLibrary[] libs = null;
        try {
            libs = this._deplMgr.getSharedLibraries(this._deplMgr.getTargets());
        }
        catch (Throwable t) {
            String msg = FormattingResourceBundle.DeploymentMessages.getString("getsharedlibraries_failed", new String[]{t.getMessage()});
            if (this._logger.isLoggable(Level.SEVERE)) {
                this._logger.log(Level.SEVERE, msg, t);
            }
            throw new J2EEDeploymentException(msg, t);
        }
        return libs;
    }

    public void publishSharedLibrary(String name, String version, String parentName, String parentVersion, Boolean libraryCompatible, String[] installCodeSources, String[] addCodeSources, ImportSharedLibrary[] imports) throws J2EEDeploymentException {
        File[] codeSourceFiles = new File[installCodeSources.length];
        for (int i = 0; i < installCodeSources.length; ++i) {
            File codeSourceFile = new File(installCodeSources[i]);
            if (!codeSourceFile.exists()) {
                String msg = FormattingResourceBundle.DeploymentMessages.getString("publishsharedlibrary_not_find_archive", new String[]{codeSourceFile.getAbsolutePath()});
                throw new J2EEDeploymentException(msg);
            }
            if (codeSourceFile.isDirectory()) {
                String msg = FormattingResourceBundle.DeploymentMessages.getString("publishsharedlibrary_not_be_directory", new String[]{codeSourceFile.getAbsolutePath()});
                throw new J2EEDeploymentException(msg);
            }
            codeSourceFiles[i] = codeSourceFile;
        }
        try {
            this._deplMgr.publishSharedLibrary(this._deplMgr.getTargets(), name, version, parentName, parentVersion, libraryCompatible, codeSourceFiles, addCodeSources, imports);
        }
        catch (Throwable t) {
            String msg = FormattingResourceBundle.DeploymentMessages.getString("publishsharedlibrary_failed", new String[]{t.getMessage()});
            if (this._logger.isLoggable(Level.SEVERE)) {
                this._logger.log(Level.SEVERE, msg, t);
            }
            throw new J2EEDeploymentException(msg, t);
        }
    }

    public void addImportSharedLibrary(String appName, String name, String minVersion, String maxVersion) throws J2EEDeploymentException {
        TargetModuleID[] tids = this.getTargetModuleIDsForApplication(appName, this._targets);
        if (tids == null || tids.length == 0) {
            throw new J2EEDeploymentException(FormattingResourceBundle.DeploymentMessages.getString("application_not_exist", new String[]{"addImportSharedLibrary", "", appName}));
        }
        try {
            this._deplMgr.addImportSharedLibrary(tids, name, minVersion, maxVersion);
        }
        catch (Throwable t) {
            String msg = FormattingResourceBundle.DeploymentMessages.getString("addimportsharedlibrary_failed", new String[]{t.getMessage()});
            if (this._logger.isLoggable(Level.SEVERE)) {
                this._logger.log(Level.SEVERE, msg, t);
            }
            throw new J2EEDeploymentException(msg, t);
        }
    }

    public void deleteImportSharedLibrary(String appName, String name) throws J2EEDeploymentException {
        TargetModuleID[] tids = this.getTargetModuleIDsForApplication(appName, this._targets);
        if (tids == null || tids.length == 0) {
            throw new J2EEDeploymentException(FormattingResourceBundle.DeploymentMessages.getString("application_not_exist", new String[]{"deleteImportSharedLibrary", "", appName}));
        }
        try {
            this._deplMgr.deleteImportSharedLibrary(tids, name);
        }
        catch (Throwable t) {
            String msg = FormattingResourceBundle.DeploymentMessages.getString("deleteimportsharedlibrary_failed", new String[]{t.getMessage()});
            if (this._logger.isLoggable(Level.SEVERE)) {
                this._logger.log(Level.SEVERE, msg, t);
            }
            throw new J2EEDeploymentException(msg, t);
        }
    }

    public void addRemoveInheritedSharedLibrary(String appName, String name) throws J2EEDeploymentException {
        TargetModuleID[] tids = this.getTargetModuleIDsForApplication(appName, this._targets);
        if (tids == null || tids.length == 0) {
            throw new J2EEDeploymentException(FormattingResourceBundle.DeploymentMessages.getString("application_not_exist", new String[]{"addRemoveInheritedSharedLibrary", "", appName}));
        }
        try {
            this._deplMgr.addRemoveInheritedSharedLibrary(tids, name);
        }
        catch (Throwable t) {
            String msg = FormattingResourceBundle.DeploymentMessages.getString("addremoveinheritedsharedlibrary_failed", new String[]{t.getMessage()});
            if (this._logger.isLoggable(Level.SEVERE)) {
                this._logger.log(Level.SEVERE, msg, t);
            }
            throw new J2EEDeploymentException(msg, t);
        }
    }

    public void deleteRemoveInheritedSharedLibrary(String appName, String name) throws J2EEDeploymentException {
        TargetModuleID[] tids = this.getTargetModuleIDsForApplication(appName, this._targets);
        if (tids == null || tids.length == 0) {
            throw new J2EEDeploymentException(FormattingResourceBundle.DeploymentMessages.getString("application_not_exist", new String[]{"deleteRemoveInheritedSharedLibrary", "", appName}));
        }
        try {
            this._deplMgr.deleteRemoveInheritedSharedLibrary(tids, name);
        }
        catch (Throwable t) {
            String msg = FormattingResourceBundle.DeploymentMessages.getString("deleteremoveinheritedsharedlibrary_failed", new String[]{t.getMessage()});
            if (this._logger.isLoggable(Level.SEVERE)) {
                this._logger.log(Level.SEVERE, msg, t);
            }
            throw new J2EEDeploymentException(msg, t);
        }
    }

    public void removeSharedLibrary(String name, String version) throws J2EEDeploymentException {
        try {
            this._deplMgr.removeSharedLibrary(this._deplMgr.getTargets(), name, version);
        }
        catch (Throwable t) {
            String msg = FormattingResourceBundle.DeploymentMessages.getString("removesharedlibrary_failed", new String[]{t.getMessage()});
            if (this._logger.isLoggable(Level.SEVERE)) {
                this._logger.log(Level.SEVERE, msg, t);
            }
            throw new J2EEDeploymentException(msg, t);
        }
    }

    public void setLogOutput(OutputStream out) {
        if (out != null) {
            this._out = out;
        } else {
            this._logger.log(Level.WARNING, FormattingResourceBundle.DeploymentMessages.getString("setlogoutput_not_null"));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String validateURI(String uri, String user, String pwd) {
        StringBuffer buff = new StringBuffer();
        ProprietaryConnectedDeploymentManager deplMgr = null;
        try {
            DeploymentFactoryManager facMgr = DeploymentUtils.getDeploymentFactoryManager();
            deplMgr = (ProprietaryConnectedDeploymentManager)facMgr.getDeploymentManager(uri, user, pwd);
        }
        catch (DeploymentManagerCreationException de) {
            buff.append(FormattingResourceBundle.DeploymentMessages.getString("validateuri_failed", new String[]{de.getMessage()}));
            buff.append("\n" + DeploymentUtils.getValidURIMsg());
            return buff.toString();
        }
        String state = deplMgr.isConnected() ? FormattingResourceBundle.DeploymentMessages.getString("connected") : FormattingResourceBundle.DeploymentMessages.getString("disconnected");
        buff.append(FormattingResourceBundle.DeploymentMessages.getString("uri_valid", new String[]{uri, state}));
        if (deplMgr instanceof ClusterDeploymentManager) {
            void var6_9;
            try {
                Set configSetUrls = ClusterHelper.getConfigSetDeployerURLs(uri);
                Iterator iter = configSetUrls.iterator();
            }
            catch (Exception e) {
                buff.append(FormattingResourceBundle.DeploymentMessages.getString("unable_to_get_deployer_uris", new String[]{e.getMessage()}));
                return buff.toString();
            }
            while (var6_9.hasNext()) {
                String instanceUrl = (String)var6_9.next();
                try {
                    ClusterHelper.getConfigSetDeploymentManager(instanceUrl, user, pwd, deplMgr.getCurrentLocale());
                    buff.append(FormattingResourceBundle.DeploymentMessages.getString("instance_is_up", new String[]{instanceUrl}));
                }
                catch (DeploymentRuntimeException dre) {
                    buff.append(FormattingResourceBundle.DeploymentMessages.getString("instance_is_down", new String[]{instanceUrl}));
                }
            }
        }
        return buff.toString();
    }

    private TargetModuleID[] getTargetModuleIDsForApplication(String deployName, Target[] targets) {
        String pattn = "*:j2eeType=J2EEApplication,name=" + deployName + ",J2EEServer=";
        return this.getTargetModuleIDsForPattern(pattn, targets);
    }

    private TargetModuleID[] getTargetModuleIDsForPattern(String pattn, Target[] targets) {
        if (this._deplMgr instanceof ClusterDeploymentManager) {
            return ((ClusterDeploymentManager)this._deplMgr).getTargetModuleIDsForPattern(pattn, targets);
        }
        TargetModuleID tid = this._deplMgr.getTargetModuleIDForPattern(pattn, targets[0]);
        if (tid == null) {
            return null;
        }
        TargetModuleID[] result = new TargetModuleIDImpl[]{tid};
        return result;
    }

    private void writeIIOPClientJar(ProgressObject po, String appName, String clientJarPath) {
        block3: {
            try {
                TargetModuleID[] tids = this.getTargetModuleIDsForApplication(appName, this._targets);
                if (tids == null || tids.length == 0) {
                    this._logger.log(Level.INFO, FormattingResourceBundle.DeploymentMessages.getString("app_not_exist", new String[]{appName}));
                    return;
                }
                ProprietaryClientConfigurationImpl clntConf = (ProprietaryClientConfigurationImpl)po.getClientConfiguration(tids[0]);
                byte[] clientJarBytes = clntConf.getClientIIOPStubs();
                FileOutputStream clientJarOutput = new FileOutputStream(clientJarPath);
                clientJarOutput.write(clientJarBytes);
                clientJarOutput.close();
            }
            catch (IOException e) {
                if (!this._logger.isLoggable(Level.WARNING)) break block3;
                this._logger.log(Level.WARNING, FormattingResourceBundle.DeploymentMessages.getString("iiopClientJar_failed", new String[]{e.getMessage()}), e);
            }
        }
    }

    public boolean checkSharedLibraryExists(String name, String version) throws InstantiationException {
        return this._deplMgr.checkSharedLibraryExists(this._deplMgr.getTargets(), name, version);
    }

    public void createJDBCConnectionPool(String applicationName, String name, String factoryClass, String user, String password, String url, List properties) throws J2EEDeploymentException {
        try {
            this._deplMgr.createJDBCConnectionPool(this._deplMgr.getTargets(), applicationName, name, factoryClass, user, password, url, properties);
        }
        catch (Throwable t) {
            String msg = FormattingResourceBundle.DeploymentMessages.getString("createJDBCConnectionPool_failed", new String[]{t.getMessage()});
            if (this._logger.isLoggable(Level.SEVERE)) {
                this._logger.log(Level.SEVERE, msg, t);
            }
            throw new J2EEDeploymentException(msg, t);
        }
    }

    public void removeDataSourceConnectionPool(String applicationName, String name) throws J2EEDeploymentException {
        try {
            this._deplMgr.removeDataSourceConnectionPool(this._deplMgr.getTargets(), applicationName, name);
        }
        catch (Throwable t) {
            String msg = FormattingResourceBundle.DeploymentMessages.getString("removeDataSourceConnectionPool_failed", new String[]{t.getMessage()});
            if (this._logger.isLoggable(Level.SEVERE)) {
                this._logger.log(Level.SEVERE, msg, t);
            }
            throw new J2EEDeploymentException(msg, t);
        }
    }

    public void createManagedDataSource(String applicationName, String dataSourceName, String user, String password, String jndiLocation, Integer loginTimeout, String connectionPoolName, String txLevel, String dbSchema, Boolean manageLocalTransactions) throws J2EEDeploymentException {
        try {
            this._deplMgr.createManagedDataSource(this._deplMgr.getTargets(), applicationName, dataSourceName, user, password, jndiLocation, loginTimeout, connectionPoolName, txLevel, dbSchema, manageLocalTransactions);
        }
        catch (Throwable t) {
            String msg = FormattingResourceBundle.DeploymentMessages.getString("createManagedDataSource_failed", new String[]{t.getMessage()});
            if (this._logger.isLoggable(Level.SEVERE)) {
                this._logger.log(Level.SEVERE, msg, t);
            }
            throw new J2EEDeploymentException(msg, t);
        }
    }

    public void removeManagedDataSource(String applicationName, String dataSourceName) throws J2EEDeploymentException {
        try {
            this._deplMgr.removeManagedDataSource(this._deplMgr.getTargets(), applicationName, dataSourceName);
        }
        catch (Throwable t) {
            String msg = FormattingResourceBundle.DeploymentMessages.getString("removeManagedDataSource_failed", new String[]{t.getMessage()});
            if (this._logger.isLoggable(Level.SEVERE)) {
                this._logger.log(Level.SEVERE, msg, t);
            }
            throw new J2EEDeploymentException(msg, t);
        }
    }

    public void createNativeDataSource(String applicationName, String dataSourceName, String user, String password, String jndiLocation, Integer loginTimeout, String dataSourceClass, String url, Map properties) throws J2EEDeploymentException {
        try {
            this._deplMgr.createNativeDataSource(this._deplMgr.getTargets(), applicationName, dataSourceName, user, password, jndiLocation, loginTimeout, dataSourceClass, url, properties);
        }
        catch (Throwable t) {
            String msg = FormattingResourceBundle.DeploymentMessages.getString("createNativeDataSource_failed", new String[]{t.getMessage()});
            if (this._logger.isLoggable(Level.SEVERE)) {
                this._logger.log(Level.SEVERE, msg, t);
            }
            throw new J2EEDeploymentException(msg, t);
        }
    }

    public void removeNativeDataSource(String applicationName, String dataSourceName) throws J2EEDeploymentException {
        try {
            this._deplMgr.removeNativeDataSource(this._deplMgr.getTargets(), applicationName, dataSourceName);
        }
        catch (Throwable t) {
            String msg = FormattingResourceBundle.DeploymentMessages.getString("removeNativeDataSource_failed", new String[]{t.getMessage()});
            if (this._logger.isLoggable(Level.SEVERE)) {
                this._logger.log(Level.SEVERE, msg, t);
            }
            throw new J2EEDeploymentException(msg, t);
        }
    }

    public String getDataSourcesDescriptor(String applicationName) throws J2EEDeploymentException {
        try {
            return this._deplMgr.getDataSourcesDescriptor(this._deplMgr.getTargets(), applicationName);
        }
        catch (Throwable t) {
            String msg = FormattingResourceBundle.DeploymentMessages.getString("getDataSourcesDescriptor_failed", new String[]{t.getMessage()});
            if (this._logger.isLoggable(Level.SEVERE)) {
                this._logger.log(Level.SEVERE, msg, t);
            }
            throw new J2EEDeploymentException(msg, t);
        }
    }

    public String listDataSources(String applicationName) throws J2EEDeploymentException {
        try {
            return this._deplMgr.listDataSources(this._deplMgr.getTargets(), applicationName);
        }
        catch (Throwable t) {
            String msg = FormattingResourceBundle.DeploymentMessages.getString("getDataSourcesDescriptor_failed", new String[]{t.getMessage()});
            if (this._logger.isLoggable(Level.SEVERE)) {
                this._logger.log(Level.SEVERE, msg, t);
            }
            throw new J2EEDeploymentException(msg, t);
        }
    }

    public String listDataSourceConnectionPools(String applicationName) throws J2EEDeploymentException {
        try {
            return this._deplMgr.listDataSourceConnectionPools(this._deplMgr.getTargets(), applicationName);
        }
        catch (Throwable t) {
            String msg = FormattingResourceBundle.DeploymentMessages.getString("getDataSourcesDescriptor_failed", new String[]{t.getMessage()});
            if (this._logger.isLoggable(Level.SEVERE)) {
                this._logger.log(Level.SEVERE, msg, t);
            }
            throw new J2EEDeploymentException(msg, t);
        }
    }

    public String testDatabaseConnection(String applicationName, String sqlStatement, String factoryClass, String user, String password, String url) throws J2EEDeploymentException {
        try {
            return this._deplMgr.testDatabaseConnection(this._deplMgr.getTargets(), applicationName, sqlStatement, factoryClass, user, password, url);
        }
        catch (Throwable t) {
            String msg = FormattingResourceBundle.DeploymentMessages.getString("testDatabaseConnection_failed", new String[]{t.getMessage()});
            if (this._logger.isLoggable(Level.SEVERE)) {
                this._logger.log(Level.SEVERE, msg, t);
            }
            throw new J2EEDeploymentException(msg, t);
        }
    }

    public String testDataSource(String applicationName, String datasourceName, String sqlStatement, String user, String password) throws J2EEDeploymentException {
        try {
            return this._deplMgr.testDataSource(this._deplMgr.getTargets(), applicationName, datasourceName, sqlStatement, user, password);
        }
        catch (Throwable t) {
            String msg = FormattingResourceBundle.DeploymentMessages.getString("testDataSource_failed", new String[]{t.getMessage()});
            if (this._logger.isLoggable(Level.SEVERE)) {
                this._logger.log(Level.SEVERE, msg, t);
            }
            throw new J2EEDeploymentException(msg, t);
        }
    }

    public String testConnectionPool(String applicationName, String connectionPoolName, String sqlStatement, String user, String password) throws J2EEDeploymentException {
        try {
            return this._deplMgr.testConnectionPool(this._deplMgr.getTargets(), applicationName, connectionPoolName, sqlStatement, user, password);
        }
        catch (Throwable t) {
            String msg = FormattingResourceBundle.DeploymentMessages.getString("testConnectionPool_failed", new String[]{t.getMessage()});
            if (this._logger.isLoggable(Level.SEVERE)) {
                this._logger.log(Level.SEVERE, msg, t);
            }
            throw new J2EEDeploymentException(msg, t);
        }
    }

    public void addFactory(String domain, String location, String host, String port, String username, String password, String clientID, Boolean isXA) throws J2EEDeploymentException {
        try {
            this._deplMgr.addFactory(this._deplMgr.getTargets(), domain, location, host, port, username, password, clientID, isXA);
        }
        catch (Throwable t) {
            String msg = FormattingResourceBundle.DeploymentMessages.getString("addFactory_failed", new String[]{t.getMessage()});
            if (this._logger.isLoggable(Level.SEVERE)) {
                this._logger.log(Level.SEVERE, msg, t);
            }
            throw new J2EEDeploymentException(msg, t);
        }
    }

    public void removeFactory(String location) throws J2EEDeploymentException {
        try {
            this._deplMgr.removeFactory(this._deplMgr.getTargets(), location);
        }
        catch (Throwable t) {
            String msg = FormattingResourceBundle.DeploymentMessages.getString("removeFactory_failed", new String[]{t.getMessage()});
            if (this._logger.isLoggable(Level.SEVERE)) {
                this._logger.log(Level.SEVERE, msg, t);
            }
            throw new J2EEDeploymentException(msg, t);
        }
    }

    public List getConnectionFactories() throws J2EEDeploymentException {
        try {
            return this._deplMgr.getConnectionFactories(this._deplMgr.getTargets());
        }
        catch (Throwable t) {
            String msg = FormattingResourceBundle.DeploymentMessages.getString("getConnectionFactories_failed", new String[]{t.getMessage()});
            if (this._logger.isLoggable(Level.SEVERE)) {
                this._logger.log(Level.SEVERE, msg, t);
            }
            throw new J2EEDeploymentException(msg, t);
        }
    }

    public void addDestination(String domain, String name, String location, String persistenceFile, String description) throws J2EEDeploymentException {
        try {
            this._deplMgr.addDestination(this._deplMgr.getTargets(), domain, name, location, persistenceFile, description);
        }
        catch (Throwable t) {
            String msg = FormattingResourceBundle.DeploymentMessages.getString("addDestination_failed", new String[]{t.getMessage()});
            if (this._logger.isLoggable(Level.SEVERE)) {
                this._logger.log(Level.SEVERE, msg, t);
            }
            throw new J2EEDeploymentException(msg, t);
        }
    }

    public void removeDestination(String name, Boolean force, Boolean removePFile) throws J2EEDeploymentException {
        try {
            this._deplMgr.removeDestination(this._deplMgr.getTargets(), name, force, removePFile);
        }
        catch (Throwable t) {
            String msg = FormattingResourceBundle.DeploymentMessages.getString("removeDestination_failed", new String[]{t.getMessage()});
            if (this._logger.isLoggable(Level.SEVERE)) {
                this._logger.log(Level.SEVERE, msg, t);
            }
            throw new J2EEDeploymentException(msg, t);
        }
    }

    public List getDestinations() throws J2EEDeploymentException {
        try {
            return this._deplMgr.getDestinations(this._deplMgr.getTargets());
        }
        catch (Throwable t) {
            String msg = FormattingResourceBundle.DeploymentMessages.getString("getDestinations_failed", new String[]{t.getMessage()});
            if (this._logger.isLoggable(Level.SEVERE)) {
                this._logger.log(Level.SEVERE, msg, t);
            }
            throw new J2EEDeploymentException(msg, t);
        }
    }

    public void restart() throws J2EEDeploymentException {
        try {
            this._deplMgr.restart(this._deplMgr.getTargets());
        }
        catch (Throwable t) {
            String msg = FormattingResourceBundle.DeploymentMessages.getString("restart_failed", new String[]{t.getMessage()});
            if (this._logger.isLoggable(Level.SEVERE)) {
                this._logger.log(Level.SEVERE, msg, t);
            }
            throw new J2EEDeploymentException(msg, t);
        }
    }

    public void shutdown() throws J2EEDeploymentException {
        try {
            this._deplMgr.shutdown(this._deplMgr.getTargets());
        }
        catch (Throwable t) {
            String msg = FormattingResourceBundle.DeploymentMessages.getString("shutdown_failed", new String[]{t.getMessage()});
            if (this._logger.isLoggable(Level.SEVERE)) {
                this._logger.log(Level.SEVERE, msg, t);
            }
            throw new J2EEDeploymentException(msg, t);
        }
    }

    public Map getApplications(boolean verbose) throws J2EEDeploymentException {
        Map apps = null;
        try {
            apps = this._deplMgr.getApplications(this._deplMgr.getTargets(), verbose);
        }
        catch (Throwable t) {
            String msg = FormattingResourceBundle.DeploymentMessages.getString("listApplications_failed", new String[]{t.getMessage()});
            if (this._logger.isLoggable(Level.SEVERE)) {
                this._logger.log(Level.SEVERE, msg, t);
            }
            throw new J2EEDeploymentException(msg, t);
        }
        return apps;
    }

    public Map getWebBindings(String websitename, boolean verbose) throws J2EEDeploymentException {
        Map bindings = null;
        try {
            bindings = this._deplMgr.getWebBindings(this._deplMgr.getTargets(), websitename, verbose);
        }
        catch (Throwable t) {
            String msg = FormattingResourceBundle.DeploymentMessages.getString("listWebBindings_failed", new String[]{t.getMessage()});
            if (this._logger.isLoggable(Level.SEVERE)) {
                this._logger.log(Level.SEVERE, msg, t);
            }
            throw new J2EEDeploymentException(msg, t);
        }
        return bindings;
    }

    private int getDelayValue(Map extraParams) {
        int delay = 0;
        if (extraParams != null && extraParams.get("sequentialDelay") != null) {
            String delayString = (String)extraParams.get("sequentialDelay");
            try {
                delay = Integer.parseInt(delayString);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return delay;
    }

    private void waitDelay(OutputStream out, Map extraParams) {
        int delay = this.getDelayValue(extraParams);
        if (delay > 0) {
            PrintWriter pw = new PrintWriter(out, true);
            try {
                String delayString = String.valueOf(delay);
                String msg = FormattingResourceBundle.DeploymentMessages.getString("delayOfSequential", new String[]{delayString});
                pw.println(msg);
                pw.flush();
                Thread.sleep(delay * 1000);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    public void addWebSite(String name, String protocol, int port, String keystorePath, String keystorePassword, String sslProvider) throws J2EEDeploymentException {
        Target[] targets = this._deplMgr.getTargets();
        for (int i = 0; i < targets.length; ++i) {
            ((ProprietaryTarget)targets[i]).addWebSite(name, protocol.toLowerCase(), port, keystorePath, keystorePassword, sslProvider);
        }
    }
}

