/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.cmdline;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PushbackInputStream;
import java.util.Arrays;
import java.util.List;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandException;
import oracle.oc4j.admin.deploy.cmdline.ConsoleObfuscator;
import oracle.oc4j.admin.deploy.shared.util.FormattingResourceBundle;

public class AdminCommandUtils {
    public static String getNextArgument(List args, String description) throws AdminCommandException {
        if (args == null || args.isEmpty()) {
            throw new AdminCommandException(FormattingResourceBundle.DeploymentMessages.getString("miss_argument", new String[]{description}));
        }
        return (String)args.remove(0);
    }

    public static String readNextArgument(List args) {
        if (args == null || args.isEmpty()) {
            return null;
        }
        return (String)args.get(0);
    }

    public static String queryPasswordFromUser() throws AdminCommandException, IOException {
        String pwdPrompt = "Enter password: ";
        char[] password = AdminCommandUtils.readPassword(System.out, System.in, pwdPrompt);
        if (password == null) {
            throw new AdminCommandException("Empty password.");
        }
        if (!AdminCommandUtils.isValidPwd(password)) {
            throw new AdminCommandException("Should not contain special characters in the password.");
        }
        return new String(password);
    }

    private static char[] readPassword(PrintStream outs, InputStream ins, String prompt) throws IOException {
        int c;
        char[] lineBuffer;
        ConsoleObfuscator obfuscator = new ConsoleObfuscator(outs, prompt);
        obfuscator.start();
        InputStream in = ins;
        char[] buf = lineBuffer = new char[128];
        int room = buf.length;
        int offset = 0;
        while ((c = in.read()) != -1 && c != 10) {
            if (c == 13) {
                int c2 = in.read();
                if (c2 == -1 || c2 == 10) break;
                if (!(in instanceof PushbackInputStream)) {
                    in = new PushbackInputStream(in);
                }
                ((PushbackInputStream)in).unread(c2);
            }
            if (--room < 0) {
                buf = new char[offset + 128];
                room = buf.length - offset - 1;
                System.arraycopy(lineBuffer, 0, buf, 0, offset);
                Arrays.fill(lineBuffer, ' ');
                lineBuffer = buf;
            }
            buf[offset++] = (char)c;
        }
        obfuscator.finishObfuscate();
        if (offset == 0) {
            return null;
        }
        char[] ret = new char[offset];
        System.arraycopy(buf, 0, ret, 0, offset);
        Arrays.fill(buf, ' ');
        return ret;
    }

    private static boolean isValidPwd(char[] c) {
        char[] specialPwd = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '_', '-'};
        boolean found = false;
        for (int i = 0; i < c.length; ++i) {
            found = false;
            for (int j = 0; j < specialPwd.length; ++j) {
                if (c[i] != specialPwd[j]) continue;
                found = true;
                break;
            }
            if (!found) break;
        }
        return found;
    }
}

