/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.cmdline;

import java.util.List;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandBase;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandException;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandUsageException;
import oracle.oc4j.admin.deploy.shared.util.FormattingResourceBundle;

public class CreateManagedDataSourceCommand
extends AdminCommandBase {
    static final String COMMANDNAME = "-addManagedDatasource";
    static final String APPNAME = "-applicationName";
    static final String DATASOURCENAME = "-name";
    static final String FACTORYCLASS = "-factoryClass";
    static final String USER = "-dbUser";
    static final String PASSWORD = "-dbPassword";
    static final String URL = "-url";
    static final String JNDILOCATION = "-jndiLocation";
    static final String LOGINTIMEOUT = "-loginTimeout";
    static final String CONNECTIONPOOLNAME = "-connectionPoolName";
    static final String TXLEVEL = "-txLevel";
    static final String DBSCHEMA = "-dbSchema";
    static final String MANAGEDLOCALTRANSACTIONS = "-manageLocalTransactions";
    static final String COMMANDMENU = "-addManagedDataSource -name <name> -jndiLocation <jndiLocation> \n                          -connectionPoolName <connectionPoolName> [options]";
    public static final String COMMANDUSAGE = "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -addManagedDataSource\n   - Add a new Managed Data Source.\n\nValid switches are: \n   -applicationName <applicationName>                  - Required  The name of the application to deploy the datasource to.\n   -name <name>                                        - Required  The name of the new data source.\n   -jndiLocation <jndiLocation>                        - Required  The location to use to bind the new data source into JNDI.\n   -connectionPoolName <connectionPoolName>            - Required  The name of the connection pool with which the data source interacts.\n   -dbUser <dbUser>                                    - Optional  The default user for the new data source.\n   -dbPassword <dbPassword>                            - Optional  The default password for the new data source.\n   -loginTimeout <loginTimeout>                        - Optional  The login timeout for the new data source.\n   -txLevel <txLevel>                                  - Optional  The transaction level ('local' or 'global').\n   -dbSchema <dbSchema>                                - Optional  The db schema to use if the EJB CMP implementation being used is Orion CMP (TopLink CMP is the default.).\n   -manageLocalTransactions <manageLocalTransactions>  - Optional  Indicates whether or not OC4J should manage local transactions. Default value is true.\n\n";
    String _applicationName;
    String _dataSourceName;
    String _user;
    String _password;
    String _jndiLocation;
    String _loginTimeout;
    String _connectionPoolName;
    String _txLevel;
    String _dbSchema;
    String _manageLocalTransactions;

    public CreateManagedDataSourceCommand(List args) throws AdminCommandException {
        super(args);
        while (!this.isArgsEmpty()) {
            String command = this.getNextArgument("addManagedDataSource subcommand");
            if (command.equalsIgnoreCase(APPNAME)) {
                this._applicationName = this.getNextArgument(APPNAME);
                continue;
            }
            if (command.equalsIgnoreCase(DATASOURCENAME)) {
                this._dataSourceName = this.getNextArgument(DATASOURCENAME);
                continue;
            }
            if (command.equalsIgnoreCase(USER)) {
                this._user = this.getNextArgument(USER);
                continue;
            }
            if (command.equalsIgnoreCase(PASSWORD)) {
                this._password = this.getNextArgument(PASSWORD);
                continue;
            }
            if (command.equalsIgnoreCase(JNDILOCATION)) {
                this._jndiLocation = this.getNextArgument(JNDILOCATION);
                continue;
            }
            if (command.equalsIgnoreCase(LOGINTIMEOUT)) {
                this._loginTimeout = this.getNextArgument(LOGINTIMEOUT);
                continue;
            }
            if (command.equalsIgnoreCase(CONNECTIONPOOLNAME)) {
                this._connectionPoolName = this.getNextArgument(CONNECTIONPOOLNAME);
                continue;
            }
            if (command.equalsIgnoreCase(TXLEVEL)) {
                this._txLevel = this.getNextArgument(TXLEVEL);
                continue;
            }
            if (command.equalsIgnoreCase(DBSCHEMA)) {
                this._dbSchema = this.getNextArgument(DBSCHEMA);
                continue;
            }
            if (command.equalsIgnoreCase(MANAGEDLOCALTRANSACTIONS)) {
                this._manageLocalTransactions = this.getNextArgument(MANAGEDLOCALTRANSACTIONS);
                continue;
            }
            throw new AdminCommandUsageException(FormattingResourceBundle.DeploymentMessages.getString("unknown_createManagedDataSource_switch", new String[]{command}), "-addManagedDataSource");
        }
        this.checkArgIsNull(this._dataSourceName, DATASOURCENAME);
        this.checkArgIsNull(this._jndiLocation, JNDILOCATION);
        this.checkArgIsNull(this._connectionPoolName, CONNECTIONPOOLNAME);
    }

    protected void doExecute() throws AdminCommandException {
        try {
            this._j2eeDeplMgr.createManagedDataSource(this._applicationName, this._dataSourceName, this._user, this._password, this._jndiLocation, this._loginTimeout == null ? null : new Integer(this._loginTimeout), this._connectionPoolName, this._txLevel, this._dbSchema, this._manageLocalTransactions == null ? null : new Boolean(this._manageLocalTransactions));
            System.out.println("AddManagedDataSource command was successful");
        }
        catch (Exception e) {
            throw new AdminCommandException(FormattingResourceBundle.DeploymentMessages.getString("createManagedDataSource_error", new String[]{e.getMessage()}), e);
        }
    }
}

