/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.cmdline;

import java.util.List;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandBase;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandException;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandUsageException;
import oracle.oc4j.admin.deploy.shared.util.FormattingResourceBundle;
import oracle.oc4j.admin.management.shared.CodeSource;
import oracle.oc4j.admin.management.shared.ImportSharedLibrary;
import oracle.oc4j.admin.management.shared.SharedLibrary;

public class DescribeSharedLibraryCommand
extends AdminCommandBase {
    public static final String COMMANDNAME = "-describeSharedLibrary";
    public static final String COMMANDMENU = "-describeSharedLibrary -name <name> -version <version>";
    public static final String COMMANDUSAGE = "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -describeSharedLibrary [<switch>]\n   - Lists all of the code sources and imports of the specified shared library.\n\nValid switches are: \n   -name <name>         - Required  The name of the shared library.\n   -version <version>   - Required  The version of the shared library.\n\n";
    private String _name;
    private String _version;

    public DescribeSharedLibraryCommand(List args) throws AdminCommandException {
        super(args);
        while (!this.isArgsEmpty()) {
            String command = this.getNextArgument("describeSharedLibrary subcommand");
            if (command.equalsIgnoreCase("-name")) {
                this._name = this.getNextArgument("describeSharedLibrary -name name");
                continue;
            }
            if (command.equalsIgnoreCase("-version")) {
                this._version = this.getNextArgument("version");
                continue;
            }
            String msg = FormattingResourceBundle.DeploymentMessages.getString("unknown_describesharedlibrary_switch", new String[]{command});
            throw new AdminCommandUsageException(msg, COMMANDNAME);
        }
        this.checkArgIsNull(this._name, "-name");
        this.checkArgIsNull(this._version, "-version");
    }

    protected void doExecute() throws AdminCommandException {
        try {
            if (!this._j2eeDeplMgr.checkSharedLibraryExists(this._name, this._version)) {
                String msg = FormattingResourceBundle.DeploymentMessages.getString("shared_library_not_exist", new String[]{this._name, this._version});
                throw new AdminCommandException(msg);
            }
        }
        catch (Exception e) {
            String msg = FormattingResourceBundle.DeploymentMessages.getString("describesharedlibrary_error", new String[]{e.getMessage()});
            throw new AdminCommandException(msg, e);
        }
        SharedLibrary[] libs = null;
        try {
            libs = this._j2eeDeplMgr.getSharedLibraries();
        }
        catch (Exception e) {
            throw new AdminCommandException(FormattingResourceBundle.DeploymentMessages.getString("describesharedlibraries_error", new String[]{e.getMessage()}), e);
        }
        SharedLibrary theLib = null;
        for (int i = 0; i < libs.length; ++i) {
            if (!libs[i].getName().equals(this._name) || !libs[i].getVersion().equals(this._version)) continue;
            theLib = libs[i];
            break;
        }
        System.out.println("\n  Shared Library Name:    " + this._name);
        System.out.println("  Shared Library Version: " + this._version);
        System.out.println("  Parent Name:    " + theLib.getParentName());
        System.out.println("  Parent Version: " + theLib.getParentVersion() + "\n");
        System.out.println("  Modifiable: " + (theLib.isModifiable() ? "yes" : "no") + "\n");
        System.out.println("  Library Compatible: " + (theLib.isLibraryCompatible() ? "yes" : "no") + "\n");
        System.out.println("  Code Sources:");
        CodeSource[] sources = theLib.getCodeSources();
        for (int i = 0; i < sources.length; ++i) {
            System.out.println("      " + sources[i].getPath());
        }
        System.out.println("\n  Imported Shared Libraries:");
        ImportSharedLibrary[] imports = theLib.getImports();
        for (int i = 0; i < imports.length; ++i) {
            System.out.println("    name: " + imports[i].getName() + "    min-version: " + imports[i].getMinVersion() + "    max-version: " + imports[i].getMaxVersion());
        }
        System.out.println("");
    }
}

