/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.cmdline;

import java.util.List;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandBase;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandException;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandUsageException;
import oracle.oc4j.admin.deploy.shared.util.FormattingResourceBundle;

public class GetDataSourcesDescriptorCommand
extends AdminCommandBase {
    static final String COMMANDNAME = "-getDataSourcesDescriptor";
    static final String APPNAME = "-applicationName";
    static final String COMMANDMENU = "-getDataSourcesDescriptor";
    static final String COMMANDUSAGE = "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -getDataSourcesDescriptor\n   - Get the application's data sources as data-sources.xml.\n\nValid switches are: \n   -applicationName <applicationName>                        - Optional  The name of the application the descriptor belongs to.\n\n";
    String _applicationName;

    public GetDataSourcesDescriptorCommand(List args) throws AdminCommandException {
        super(args);
        while (!this.isArgsEmpty()) {
            String command = this.getNextArgument("-getDataSourcesDescriptor subcommand");
            if (command.equalsIgnoreCase(APPNAME)) {
                this._applicationName = this.getNextArgument("-applicationName ");
                continue;
            }
            throw new AdminCommandUsageException(FormattingResourceBundle.DeploymentMessages.getString("unknown_getDataSourcesDescriptor_switch", new String[]{command}), "-getDataSourcesDescriptor");
        }
    }

    protected void doExecute() throws AdminCommandException {
        try {
            System.out.println(this._j2eeDeplMgr.getDataSourcesDescriptor(this._applicationName));
        }
        catch (Exception e) {
            throw new AdminCommandException(FormattingResourceBundle.DeploymentMessages.getString("getDataSourcesDescriptor_error", new String[]{e.getMessage()}), e);
        }
    }
}

