/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.cmdline;

import java.util.List;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandBase;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandException;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandUsageException;
import oracle.oc4j.admin.deploy.shared.util.FormattingResourceBundle;

public class ListDataSourceConnectionPoolsCommand
extends AdminCommandBase {
    static final String COMMANDNAME = "-listDataSourceConnectionPools";
    static final String APPNAME = "-applicationName";
    static final String COMMANDMENU = "-listDataSourceConnectionPools";
    static final String COMMANDUSAGE = "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -listDataSourceConnectionPools\n   - List the application's data source connection pools.\n\nValid switches are: \n   -applicationName <applicationName>                        - Optional  The name of the application for which to list the data sources.\n\n";
    String _applicationName;

    public ListDataSourceConnectionPoolsCommand(List args) throws AdminCommandException {
        super(args);
        while (!this.isArgsEmpty()) {
            String command = this.getNextArgument("-listDataSourceConnectionPools subcommand");
            if (command.equalsIgnoreCase(APPNAME)) {
                this._applicationName = this.getNextArgument("-applicationName ");
                continue;
            }
            throw new AdminCommandUsageException(FormattingResourceBundle.DeploymentMessages.getString("unknown_listDataSourceConnectionPools_switch", new String[]{command}), "-listDataSourceConnectionPools");
        }
    }

    protected void doExecute() throws AdminCommandException {
        try {
            System.out.println(this._j2eeDeplMgr.listDataSourceConnectionPools(this._applicationName));
        }
        catch (Exception e) {
            throw new AdminCommandException(FormattingResourceBundle.DeploymentMessages.getString("listDataSourceConnectionPools_error", new String[]{e.getMessage()}), e);
        }
    }
}

