/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.cmdline;

import java.util.List;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandBase;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandException;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandUsageException;
import oracle.oc4j.admin.deploy.shared.util.FormattingResourceBundle;

public class ListDataSourcesCommand
extends AdminCommandBase {
    static final String COMMANDNAME = "-listDataSources";
    static final String APPNAME = "-applicationName";
    static final String COMMANDMENU = "-listDataSources";
    static final String COMMANDUSAGE = "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -listDataSources\n   - List the application's data sources.\n\nValid switches are: \n   -applicationName <applicationName>                        - Optional  The name of the application for which to list the data sources.\n\n";
    String _applicationName;

    public ListDataSourcesCommand(List args) throws AdminCommandException {
        super(args);
        while (!this.isArgsEmpty()) {
            String command = this.getNextArgument("-listDataSources subcommand");
            if (command.equalsIgnoreCase(APPNAME)) {
                this._applicationName = this.getNextArgument("-applicationName ");
                continue;
            }
            throw new AdminCommandUsageException(FormattingResourceBundle.DeploymentMessages.getString("unknown_listDataSources_switch", new String[]{command}), "-listDataSources");
        }
    }

    protected void doExecute() throws AdminCommandException {
        try {
            System.out.println(this._j2eeDeplMgr.listDataSources(this._applicationName));
        }
        catch (Exception e) {
            throw new AdminCommandException(FormattingResourceBundle.DeploymentMessages.getString("listDataSources_error", new String[]{e.getMessage()}), e);
        }
    }
}

