/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.cmdline;

import java.util.List;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandBase;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandException;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandUsageException;
import oracle.oc4j.admin.deploy.shared.util.FormattingResourceBundle;
import oracle.oc4j.admin.management.shared.SharedLibrary;

public class ListSharedLibrariesCommand
extends AdminCommandBase {
    public static final String COMMANDNAME = "-listSharedLibraries";
    public static final String COMMANDMENU = "-listSharedLibraries";
    public static final String COMMANDUSAGE = "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -listSharedLibraries\n   - Lists all of the shared libraries in the OC4J instance(s).\n\n";

    public ListSharedLibrariesCommand(List args) throws AdminCommandException {
        super(args);
        if (!this.isArgsEmpty()) {
            String command = this.getNextArgument("invalid listSharedLibraries subcommand");
            throw new AdminCommandUsageException(FormattingResourceBundle.DeploymentMessages.getString("unknown_listsharedlibraries_switch", new String[]{command}), "-listSharedLibraries");
        }
    }

    protected void doExecute() throws AdminCommandException {
        int i;
        SharedLibrary[] libs = null;
        try {
            libs = this._j2eeDeplMgr.getSharedLibraries();
        }
        catch (Exception e) {
            throw new AdminCommandException(FormattingResourceBundle.DeploymentMessages.getString("listsharedlibraries_error", new String[]{e.getMessage()}), e);
        }
        System.out.println("\nFound " + libs.length + " shared libraries:\n");
        System.out.println("Modifiable libraries: ");
        for (i = 0; i < libs.length; ++i) {
            if (!libs[i].isModifiable()) continue;
            System.out.println("    " + libs[i].getName() + " version " + libs[i].getVersion());
        }
        System.out.println("\nNon-modifiable (system) libraries: ");
        for (i = 0; i < libs.length; ++i) {
            if (libs[i].isModifiable()) continue;
            System.out.println("    " + libs[i].getName() + " version " + libs[i].getVersion());
        }
        System.out.println("");
    }
}

