/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.cmdline;

import java.util.List;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandBase;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandException;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandUsageException;
import oracle.oc4j.admin.deploy.shared.util.FormattingResourceBundle;

public class RemoveManagedDataSourceCommand
extends AdminCommandBase {
    static final String COMMANDNAME = "-removeManagedDatasource";
    static final String APPNAME = "-applicationName";
    static final String DATASOURCENAME = "-name";
    static final String COMMANDMENU = "-removeManagedDatasource -name <dataSourceName>";
    public static final String COMMANDUSAGE = "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -removeManagedDataSource\n   - Remove a Managed Data Source.\n\nValid switches are: \n   -name <name>                                        - Required  The name of the data source to remove.\n   -applicationName <applicationName>                  - Optional  The name of the application to remove the datasource from .\n\n";
    String _applicationName;
    String _dataSourceName;

    public RemoveManagedDataSourceCommand(List args) throws AdminCommandException {
        super(args);
        while (!this.isArgsEmpty()) {
            String command = this.getNextArgument("-removeManagedDatasource subcommand");
            if (command.equalsIgnoreCase(APPNAME)) {
                this._applicationName = this.getNextArgument(APPNAME);
                continue;
            }
            if (command.equalsIgnoreCase(DATASOURCENAME)) {
                this._dataSourceName = this.getNextArgument(DATASOURCENAME);
                continue;
            }
            throw new AdminCommandUsageException(FormattingResourceBundle.DeploymentMessages.getString("unknown_removeManagedDataSource_switch", new String[]{command}), "-removeManagedDataSource");
        }
        this.checkArgIsNull(this._dataSourceName, DATASOURCENAME);
    }

    protected void doExecute() throws AdminCommandException {
        try {
            this._j2eeDeplMgr.removeManagedDataSource(this._applicationName, this._dataSourceName);
            System.out.println("Command was successful");
        }
        catch (Exception e) {
            throw new AdminCommandException(FormattingResourceBundle.DeploymentMessages.getString("removeManagedDataSource_error", new String[]{e.getMessage()}), e);
        }
    }
}

