/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.cmdline;

import java.util.List;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandBase;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandException;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandUsageException;
import oracle.oc4j.admin.deploy.shared.util.FormattingResourceBundle;

public class RemoveNativeDataSourceCommand
extends AdminCommandBase {
    static final String COMMANDNAME = "-removeNativeDataSource";
    static final String APPNAME = "-applicationName";
    static final String DATASOURCENAME = "-name";
    static final String COMMANDMENU = "-removeNativeDataSource -name <name>";
    public static final String COMMANDUSAGE = "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -removeNativeDataSource \n   - Remove a Native Data Source.\n\nValid switches are: \n   -name <name>                                        - Required  The name of the data source to remove.\n   -applicationName <applicationName>                  - Optional  The name of the application.\n\n";
    String _applicationName;
    String _dataSourceName;

    public RemoveNativeDataSourceCommand(List args) throws AdminCommandException {
        super(args);
        while (!this.isArgsEmpty()) {
            String command = this.getNextArgument("-removeNativeDataSource subcommand");
            if (command.equalsIgnoreCase(APPNAME)) {
                this._applicationName = this.getNextArgument("-applicationName ");
                continue;
            }
            if (command.equalsIgnoreCase(DATASOURCENAME)) {
                this._dataSourceName = this.getNextArgument("-name ");
                continue;
            }
            throw new AdminCommandUsageException(FormattingResourceBundle.DeploymentMessages.getString("unknown_removeNativeDataSource_switch", new String[]{command}), COMMANDNAME);
        }
        this.checkArgIsNull(this._dataSourceName, DATASOURCENAME);
    }

    protected void doExecute() throws AdminCommandException {
        try {
            this._j2eeDeplMgr.removeNativeDataSource(this._applicationName, this._dataSourceName);
            System.out.println("Command was successful");
        }
        catch (Exception e) {
            throw new AdminCommandException(FormattingResourceBundle.DeploymentMessages.getString("removeNativeDataSource_error", new String[]{e.getMessage()}), e);
        }
    }
}

