/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.cmdline;

import java.util.List;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandBase;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandException;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandUsageException;
import oracle.oc4j.admin.deploy.shared.util.FormattingResourceBundle;

public class UndeployCommand
extends AdminCommandBase {
    public static final String COMMANDNAME = "-undeploy";
    public static final String COMMANDMENU = "-undeploy <appname> [options]";
    public static final String COMMANDUSAGE = "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -undeploy <appname> [<switch>]\n   - Undeploys an application, standalone WAR or standalone RAR.\n\nValid switches are:\n   -isConnector         - Optional  Required to undeploy a standalone RAR.\n\n";
    private String _deployName = this.getNextArgument("j2ee application name for -undeploy");
    private boolean _isConnector = false;

    public UndeployCommand(List args) throws AdminCommandException {
        super(args);
        while (!this.isArgsEmpty()) {
            String command = this.getNextArgument("undeployment subcommand");
            if (command.equalsIgnoreCase("-isconnector")) {
                this._isConnector = true;
                continue;
            }
            throw new AdminCommandUsageException(FormattingResourceBundle.DeploymentMessages.getString("unknown_undeploy_switch", new String[]{command}), COMMANDNAME);
        }
        this.checkArgIsNull(this._deployName, "<deploy name>");
    }

    protected void doExecute() throws AdminCommandException {
        try {
            this._j2eeDeplMgr.undeploy(this._deployName, this._isConnector);
        }
        catch (Exception e) {
            throw new AdminCommandException(FormattingResourceBundle.DeploymentMessages.getString("undeploy_error", new String[]{e.getMessage()}), e);
        }
    }
}

