/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.gui;

import java.util.Enumeration;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import oracle.oc4j.admin.deploy.gui.ApplicationJTree;
import oracle.oc4j.admin.deploy.gui.DeployTargetNode;
import oracle.oc4j.admin.deploy.gui.Oc4jNode;
import oracle.oc4j.admin.deploy.gui.ResourceJTree;
import oracle.oc4j.admin.deploy.gui.ViewableJTree;
import oracle.oc4j.admin.deploy.gui.ViewableJTreeNodeSupport;

public class ClusterNode
extends ViewableJTreeNodeSupport
implements DeployTargetNode {
    private DeploymentManager _manager = null;
    private String _clusterName = null;
    private String _url = null;
    private boolean _isTargeted = false;
    private ApplicationJTree _appTree;
    private ResourceJTree _resourceTree;

    public ClusterNode(DeploymentManager manager, String name, String url) {
        this._manager = manager;
        this._clusterName = name;
        this._url = url;
        this._appTree = ApplicationJTree.createApplicationJTree(manager, manager.getTargets(), name);
        this._resourceTree = null;
    }

    public Oc4jNode getOc4jNode(Target target) {
        Enumeration e = this.children();
        while (e.hasMoreElements()) {
            Oc4jNode onode = (Oc4jNode)e.nextElement();
            if (!onode.returnTargets()[0].equals(target)) continue;
            return onode;
        }
        return null;
    }

    public String getName() {
        return this._clusterName;
    }

    public String getURL() {
        return this._url;
    }

    public void buildChildJTree() {
        Target[] targets = this._manager.getTargets();
        for (int i = 0; i < targets.length; ++i) {
            this.addJTreeChild(new Oc4jNode(targets[i], this._manager, this._clusterName));
        }
    }

    public String jtreeIconName() {
        return "cluster";
    }

    public boolean leaf() {
        return false;
    }

    public String jtreeToolTip() {
        return this.viewHeaderString();
    }

    public String viewHeaderString() {
        return "OC4J Cluster";
    }

    public String toString() {
        return this._clusterName;
    }

    public void targeted(boolean targeted) {
        this._isTargeted = targeted;
        this._appTree.setTargeted(targeted);
    }

    public boolean targeted() {
        return this._isTargeted;
    }

    public Target[] returnTargets() {
        Target[] targets = new Target[this.getChildCount()];
        int i = 0;
        Enumeration e = this.children();
        while (e.hasMoreElements()) {
            Oc4jNode node = (Oc4jNode)e.nextElement();
            targets[i++] = node.returnTargets()[0];
        }
        return targets;
    }

    public ApplicationJTree appTree() {
        return this._appTree;
    }

    public ResourceJTree resourceTree() {
        return this._resourceTree;
    }

    public ViewableJTree[] subTrees() {
        return new ViewableJTree[]{this.appTree()};
    }

    public String targetName() {
        return this.toString();
    }
}

