/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.oc4j.admin.deploy.gui.AppInfoManager;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.gui.J2eeArchiveFileFilter;

public class ConfirmRedeployDialog
extends JDialog
implements ActionListener {
    protected static final String OK_STRING = "Begin Redeploy";
    protected static final String CANCEL_STRING = "Cancel";
    protected static final String CHANGE_STRING = "Change Archive";
    protected String _appName;
    protected JLabel _titleLabel;
    protected JFrame _parent;
    protected File _archiveFile;
    protected boolean _response;

    public ConfirmRedeployDialog(JFrame parent, String appName, File archiveFile, boolean canChangeArchive) {
        super((Frame)parent, "Confirm Redeploy");
        this.setModal(true);
        this._appName = appName;
        this._parent = parent;
        this._archiveFile = archiveFile;
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setBackground(Deployer.TreeBackgroundColor);
        contentPane.setLayout(new BorderLayout());
        contentPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this._titleLabel = new JLabel("", 0);
        this._titleLabel.setOpaque(true);
        this._titleLabel.setBackground(Color.white);
        contentPane.add((Component)this._titleLabel, "North");
        JPanel buttonPane = new JPanel();
        buttonPane.setOpaque(false);
        buttonPane.setBorder(BorderFactory.createEmptyBorder(20, 0, 0, 0));
        JButton okButton = new JButton(OK_STRING);
        okButton.setActionCommand(OK_STRING);
        okButton.addActionListener(this);
        JButton cancelButton = new JButton(CANCEL_STRING);
        cancelButton.setActionCommand(CANCEL_STRING);
        cancelButton.addActionListener(this);
        if (canChangeArchive) {
            JButton changeButton = new JButton(CHANGE_STRING);
            changeButton.setActionCommand(CHANGE_STRING);
            changeButton.addActionListener(this);
            buttonPane.add(changeButton);
        }
        buttonPane.add(okButton);
        buttonPane.add(cancelButton);
        contentPane.add((Component)buttonPane, "South");
        if (this._archiveFile != null) {
            this.setTitleText();
        }
    }

    protected void setTitleText() {
        String titleString = "<html>Redeploying application <font color=red>" + this._appName + "</font> using J2EE archive " + "<font color=red>" + this._archiveFile.getName() + "</font></html>";
        this._titleLabel.setText(titleString);
        this._titleLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(3, 0, 3, 0)));
        Dimension size = this.getContentPane().getPreferredSize();
        this.setSize(new Dimension(size.width + 20, size.height + 20));
        this.setLocationRelativeTo(this._parent);
    }

    public boolean confirmRedeployment() {
        if (this._archiveFile == null) {
            this.promptUserToSpecifyArchive();
        }
        if (this._archiveFile == null) {
            return false;
        }
        this.show();
        return this._response;
    }

    protected void promptUserToSpecifyArchive() {
        int retVal;
        JFileChooser chooser = new JFileChooser();
        String title = "Please choose a J2ee Archive to associate with " + this._appName;
        chooser.setDialogTitle(title);
        chooser.setFileFilter(new J2eeArchiveFileFilter());
        File lastDir = (File)AppInfoManager.getStoredObject(JFileChooser.class.getName());
        if (lastDir != null) {
            chooser.setCurrentDirectory(lastDir);
        }
        if ((retVal = chooser.showDialog(this, "Select Archive")) == 1 || retVal == -1) {
            return;
        }
        AppInfoManager.storeObject(JFileChooser.class, chooser.getCurrentDirectory());
        if (this._archiveFile == null) {
            this.setTitleText();
        }
        this._archiveFile = chooser.getSelectedFile();
    }

    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (actionCommand.equals(CANCEL_STRING)) {
            this._response = false;
            this.dispose();
        } else if (actionCommand.equals(OK_STRING)) {
            this._response = true;
            this.dispose();
        } else {
            this.promptUserToSpecifyArchive();
        }
    }

    public File getArchiveFile() {
        return this._archiveFile;
    }
}

