/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.gui;

import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import oracle.oc4j.admin.deploy.gui.DataChangeEvent;
import oracle.oc4j.admin.deploy.gui.DataChangeListener;
import oracle.oc4j.admin.deploy.gui.DataElement;
import oracle.oc4j.admin.deploy.gui.DataElementBase;
import oracle.oc4j.admin.deploy.gui.DataEntryElement;
import oracle.oc4j.admin.deploy.gui.DataEntryPane;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.gui.GuiUtil;

public abstract class DataEntryElementBase
extends DataElementBase
implements DataEntryElement {
    protected Vector _listeners;
    private JComponent _component;
    private boolean _settingValueFromComponent = false;

    public DataEntryElementBase(String name, boolean optional) {
        this(name, null, optional);
    }

    public DataEntryElementBase(String name, Object value, boolean optional) {
        super(name, value, optional);
    }

    public DataEntryElementBase(DataElement elem) {
        super(elem);
    }

    public void setEnabled(boolean enabled) {
        if (this._component != null) {
            this._component.setEnabled(enabled);
        }
    }

    public DataEntryPane getDataEntryPanel() {
        return new DataEntryPane(new DataEntryElement[]{this});
    }

    protected void setSwingComponent(JComponent component) {
        this._component = component;
    }

    public JComponent getSwingComponent() {
        return this._component;
    }

    public final void setValueFromComponent() {
        this._settingValueFromComponent = true;
        this.setValue(this.getValueFromComponent());
        this._settingValueFromComponent = false;
    }

    public boolean checkValidEntry() {
        if (!this.getSwingComponent().isEnabled()) {
            return true;
        }
        if (this.getValueFromComponent() == null && !this.isOptional()) {
            GuiUtil.errDialog("You must enter a value for " + this.getName() + ".");
            return false;
        }
        if (this._listeners != null) {
            Enumeration e = this._listeners.elements();
            while (e.hasMoreElements()) {
                DataChangeListener lsnr = (DataChangeListener)e.nextElement();
                if (lsnr.isDataValid(this.getName(), this.getValueFromComponent())) continue;
                GuiUtil.errDialog("Invalid value for " + this.getName());
                return false;
            }
        }
        return true;
    }

    public void setValue(Object value) {
        this.setValue(value, true);
    }

    protected abstract void setValueInComponent(Object var1);

    public void setDefaultValue(Object value) {
        this.setValueInComponent(value);
    }

    public void setValue(Object value, boolean fireChangeEvent) {
        Object oldValue = this.getValue();
        super.setValue(value);
        if (!this._settingValueFromComponent) {
            this.setValueInComponent(value);
        }
        if (!fireChangeEvent || this._listeners == null) {
            return;
        }
        DataChangeEvent evt = new DataChangeEvent(this.getName(), oldValue, value);
        Enumeration e = this._listeners.elements();
        while (e.hasMoreElements()) {
            ((DataChangeListener)e.nextElement()).dataChange(evt);
        }
    }

    public void addDataChangeListener(DataChangeListener listener) {
        if (this._listeners == null) {
            this._listeners = new Vector();
        }
        this._listeners.add(listener);
    }

    protected JLabel createValueLabel() {
        Object defaultObj;
        JLabel label = new JLabel();
        label.setForeground(Deployer.ValueForegroundColor);
        String value = this.getValueAsString();
        if ((value == null || value.equals("")) && (defaultObj = this.getValueFromComponent()) != null) {
            value = defaultObj.toString();
            label.setForeground(Deployer.DefaultValueForegroundColor);
        }
        label.setText(value);
        return label;
    }
}

