/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.gui;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Method;
import java.util.Arrays;
import oracle.oc4j.admin.deploy.gui.ComboDataEntryElement;
import oracle.oc4j.admin.deploy.gui.DataEntryElement;
import oracle.oc4j.admin.deploy.gui.DataEntryElementBase;
import oracle.oc4j.admin.deploy.gui.GuiUtil;
import oracle.oc4j.admin.deploy.gui.PropertyDataChangeListener;
import oracle.oc4j.admin.deploy.gui.PropertyValidator;
import oracle.oc4j.admin.deploy.gui.StringDataEntryElement;
import oracle.oc4j.admin.deploy.gui.ViewableJTreeNodeSupport;
import oracle.oc4j.admin.deploy.shared.util.PropertyDescriptorComparator;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;

public class DataEntryElementFactory {
    public static DataEntryElement[] createJavaBeanDataElements(Object bean) {
        DataEntryElement[] attrElements = null;
        try {
            Class<?> beanClass = bean.getClass();
            BeanInfo beanInfo = null;
            beanInfo = bean instanceof ViewableJTreeNodeSupport ? Introspector.getBeanInfo(bean.getClass(), ViewableJTreeNodeSupport.class) : Introspector.getBeanInfo(bean.getClass());
            PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
            if (descriptors.length == 0) {
                attrElements = new DataEntryElement[]{};
                return attrElements;
            }
            Arrays.sort(descriptors, new PropertyDescriptorComparator());
            DataEntryElement[] elements = new DataEntryElement[descriptors.length];
            int skipped = 0;
            for (int i = 0; i < descriptors.length; ++i) {
                String doc;
                String value;
                PropertyEditor attrEditor = null;
                PropertyEditor defaultEditor = null;
                Class<?> propEdClass = descriptors[i].getPropertyEditorClass();
                if (propEdClass != null) {
                    attrEditor = (PropertyEditor)propEdClass.newInstance();
                    defaultEditor = (PropertyEditor)propEdClass.newInstance();
                } else {
                    Class<?> propertyType = descriptors[i].getPropertyType();
                    attrEditor = PropertyEditorManager.findEditor(propertyType);
                    defaultEditor = PropertyEditorManager.findEditor(propertyType);
                }
                if (attrEditor == null) {
                    ++skipped;
                    continue;
                }
                Method readMethod = descriptors[i].getReadMethod();
                Object obj = readMethod.invoke(bean, null);
                if (obj != null) {
                    attrEditor.setValue(obj);
                }
                if ((value = attrEditor.getAsText()).equals("null")) {
                    value = "";
                }
                Method getDefaultObjectMethod = null;
                Object[] tags = null;
                Object defaultObj = null;
                try {
                    StringBuffer buf = new StringBuffer(descriptors[i].getName());
                    buf.setCharAt(0, Character.toUpperCase(buf.charAt(0)));
                    String methodName = "default" + buf;
                    getDefaultObjectMethod = bean.getClass().getMethod(methodName, null);
                    defaultObj = getDefaultObjectMethod.invoke(bean, null);
                    defaultEditor.setValue(defaultObj);
                    tags = defaultEditor.getTags();
                }
                catch (NoSuchMethodException ex) {
                    // empty catch block
                }
                if (tags == null) {
                    tags = attrEditor.getTags();
                }
                DataEntryElementBase elem = null;
                if (tags == null) {
                    elem = new StringDataEntryElement(descriptors[i].getDisplayName(), value);
                    if (obj == null && defaultObj != null && defaultObj.toString() != null) {
                        elem.setDefaultValue(defaultObj.toString());
                    }
                } else {
                    elem = new ComboDataEntryElement(descriptors[i].getDisplayName(), tags);
                    if (obj != null) {
                        elem.setValue(obj.toString());
                    } else if (defaultObj != null) {
                        elem.setDefaultValue(defaultObj.toString());
                    }
                }
                elem.setReadOnly(descriptors[i].getWriteMethod() == null);
                if (bean instanceof ConfigBeanNode && (doc = ((ConfigBeanNode)bean).getPropertyDoc(elem.getName())) != null) {
                    elem.setDoc(doc);
                }
                if (bean instanceof PropertyValidator) {
                    elem.addDataChangeListener(new PropertyDataChangeListener((PropertyValidator)bean, descriptors[i].getWriteMethod(), defaultEditor));
                }
                elements[i] = elem;
            }
            if (skipped != 0) {
                DataEntryElement[] tmp = new DataEntryElement[elements.length - skipped];
                int j = 0;
                for (int i = 0; i < elements.length; ++i) {
                    if (elements[i] == null) continue;
                    tmp[j++] = elements[i];
                }
                elements = tmp;
            }
            attrElements = elements;
        }
        catch (Throwable t) {
            t.printStackTrace();
            GuiUtil.errDialog("Error getting properties of bean " + bean);
        }
        return attrElements;
    }
}

