/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.oc4j.admin.deploy.gui.DataEntryElement;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.gui.GuiUtil;

public class DataEntryPane
extends JPanel {
    protected DataEntryElement[] _elements;
    protected JComponent[] _components;
    protected JLabel[] _nameLabels;

    public DataEntryPane(DataEntryElement[] elements) {
        this._elements = elements;
        this._components = new JComponent[elements.length];
        this._nameLabels = new JLabel[elements.length];
        this.setBackground(Deployer.ViewBackgroundColor);
        GridBagLayout gridLayout = new GridBagLayout();
        this.setLayout(gridLayout);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridy = 0;
        c.gridx = 1;
        this.add(Box.createHorizontalStrut(5), c);
        int minwidth = 140;
        int minheight = 25;
        for (int i = 0; i < elements.length; ++i) {
            DataEntryElement data = elements[i];
            JLabel nameLabel = new JLabel(data.getName(), 4);
            nameLabel.setForeground(Color.red);
            nameLabel.setFont(GuiUtil.getBoldDialogFont());
            this._nameLabels[i] = nameLabel;
            this._components[i] = data.getSwingComponent();
            this._components[i].setFont(GuiUtil.getDialogInputFont());
            Dimension prefSize = this._components[i].getPreferredSize();
            int width = prefSize.width > minwidth ? prefSize.width + 5 : minwidth;
            int height = prefSize.height > minheight ? prefSize.height : minheight;
            Dimension dim = new Dimension(width, height);
            this._components[i].setMinimumSize(dim);
            this._components[i].setPreferredSize(dim);
            c.gridy = i;
            c.gridx = 0;
            c.weightx = 0.0;
            this.add((Component)nameLabel, c);
            c.gridx = 2;
            c.weightx = 1.0;
            this.add((Component)this._components[i], c);
        }
    }

    public JComponent[] getSwingComponents() {
        return this._components;
    }

    public DataEntryElement[] getDataEntryElements() {
        return this._elements;
    }

    public void setElementEnabled(int index, boolean enabled) {
        this._components[index].setEnabled(enabled);
        this._nameLabels[index].setForeground(enabled ? Color.red : Color.gray);
    }
}

