/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.enterprise.deploy.shared.factories.DeploymentFactoryManager;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import oracle.oc4j.admin.deploy.gui.Controller;
import oracle.oc4j.admin.deploy.gui.ControllerImpl;
import oracle.oc4j.admin.deploy.gui.ControllerListener;
import oracle.oc4j.admin.deploy.gui.DeployMenu;
import oracle.oc4j.admin.deploy.gui.DualTreeViewPane;
import oracle.oc4j.admin.deploy.gui.StatusPane;
import oracle.oc4j.admin.deploy.gui.TreeViewPane;
import oracle.oc4j.admin.deploy.gui.ViewableJTree;
import oracle.oc4j.admin.deploy.spi.factories.ClusterDeploymentFactory;
import oracle.oc4j.admin.deploy.spi.factories.IasDeploymentFactory;
import oracle.oc4j.admin.deploy.spi.factories.Oc4jDeploymentFactory;

public class Deployer
extends JFrame
implements ControllerListener {
    public static final Color MenuBackgroundColor = new Color(250, 235, 215);
    public static final Color TreeBackgroundColor = new Color(255, 250, 240);
    public static final Color ViewBackgroundColor = new Color(250, 235, 215);
    public static final Color ViewHeaderColor = Color.red;
    public static final Color ConfigPanelBackgroundColor = new Color(92, 172, 238);
    public static final Color LabelForegroundColor = new Color(255, 246, 203);
    public static final Color EditableValueLabelBackgroundColor = new Color(255, 116, 116);
    public static final Color NoValueLabelBackgroundColor = new Color(128, 128, 128);
    public static final Color CustomValueLabelBackgroundColor = new Color(92, 140, 180);
    public static final Color DefaultValueForegroundColor = new Color(190, 190, 190);
    public static final Color ValueForegroundColor = new Color(70, 70, 70);
    public static final Color ValueBackgroundColor = Color.white;
    private static final int MANAGEMENT_PANE_INDEX = 0;
    private static final int DEPLOY_PANE_INDEX = 1;
    protected DeployMenu _deployMenu;
    protected StatusPane _statusPane;
    protected DualTreeViewPane _deployWindow;
    protected TreeViewPane _oc4jManagementWindow;
    protected DualTreeViewPane _iasManagementWindow;
    protected JTabbedPane _tabPane;
    protected Controller _controller;
    protected boolean _lastConnectionIas;

    public Deployer() {
        super("Oracle J2EE Deployment/Management Tool");
        int height = 500;
        int treeWidth = 200;
        int viewWidth = 550;
        int width = treeWidth + viewWidth;
        Dimension screenDim = this.getToolkit().getScreenSize();
        this.setLocation((int)(screenDim.getWidth() - (double)width) / 2, (int)(screenDim.getHeight() - (double)height) / 2);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setBackground(TreeBackgroundColor);
        contentPane.setLayout(new BorderLayout());
        this._tabPane = new JTabbedPane();
        this._oc4jManagementWindow = new TreeViewPane(treeWidth, viewWidth, height);
        this._iasManagementWindow = new DualTreeViewPane(treeWidth, viewWidth, height);
        this._tabPane.insertTab("Manage", null, this._iasManagementWindow, "Manage Already-Deployed J2EE Applications", 0);
        this._lastConnectionIas = true;
        this._deployWindow = new DualTreeViewPane(treeWidth, viewWidth, height);
        this._tabPane.insertTab("Deploy", null, this._deployWindow, "Configure and Deploy J2EE Modules and Applications", 1);
        contentPane.add((Component)this._tabPane, "Center");
        this._controller = ControllerImpl.initSingleton(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                Deployer.this._controller.exit(1);
            }
        });
        this._statusPane = new StatusPane(this._controller);
        contentPane.add((Component)this._statusPane, "South");
        this._deployMenu = new DeployMenu(this._controller);
        this.setJMenuBar(this._deployMenu);
    }

    private void selectManagementTab(boolean ias) {
        if (ias && !this._lastConnectionIas) {
            this._tabPane.setComponentAt(0, this._iasManagementWindow);
        } else if (!ias && this._lastConnectionIas) {
            this._tabPane.setComponentAt(0, this._oc4jManagementWindow);
        }
        this._lastConnectionIas = ias;
        this.enableManagementWindow(true);
    }

    public void disconnectedFromServer() {
        this.enableManagementWindow(false);
        this._deployMenu.setConnected(false);
        this._statusPane.setDisconnected();
        this._iasManagementWindow.clear();
        this._oc4jManagementWindow.clear();
    }

    public void connectedToServer(String url, boolean ias) {
        this._statusPane.setConnected(url);
        this._controller.addTargetSelectionListener(this._statusPane);
        if (ias) {
            this._iasManagementWindow.setUpperTree(this._controller.getManagementTree());
        } else {
            this._oc4jManagementWindow.setTree(this._controller.getManagementTree());
        }
        this.selectManagementTab(ias);
        this._deployMenu.setConnected(true);
    }

    public void archiveOpen(File openArchive) {
        this._deployMenu.archiveOpen(openArchive);
        this.setDeployWindowTree(this._controller.getDeployTree());
        this.setFocusToDeployWindow();
    }

    public void archiveReopen() {
        this.setDeployWindowTree(null);
        this.setDeployWindowTree(this._controller.getDeployTree());
        this.setFocusToDeployWindow();
    }

    public void archiveClosed() {
        this._deployMenu.archiveClosed();
        this.setDeployWindowTree(null);
        this.setFocusToDeployWindow();
    }

    public void maybeChangingArchiveStatus() {
        this.setFocusToDeployWindow();
    }

    public void deployCompleted() {
        this.setFocusToManagementWindow();
    }

    protected void setFocusToDeployWindow() {
        this._tabPane.setSelectedIndex(1);
    }

    protected void setFocusToManagementWindow() {
        this._tabPane.setSelectedIndex(0);
    }

    protected void enableManagementWindow(boolean enable) {
        this._tabPane.setEnabledAt(0, enable);
        if (!enable) {
            this.setFocusToDeployWindow();
        } else {
            this.setFocusToManagementWindow();
        }
    }

    protected void setDeployWindowTree(ViewableJTree tree) {
        this._deployWindow.setUpperTree(tree);
    }

    public void start() {
        this.pack();
        this.setVisible(true);
    }

    public static void main(String[] args) {
        DeploymentFactoryManager mgr = DeploymentFactoryManager.getInstance();
        mgr.registerDeploymentFactory((DeploymentFactory)new Oc4jDeploymentFactory());
        mgr.registerDeploymentFactory((DeploymentFactory)new IasDeploymentFactory());
        mgr.registerDeploymentFactory((DeploymentFactory)new ClusterDeploymentFactory());
        Deployer deployer = new Deployer();
        deployer.start();
        deployer._controller.connect();
    }
}

