/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.management.j2ee.statistics.Statistic;
import javax.management.j2ee.statistics.Stats;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import oracle.oc4j.admin.deploy.gui.CreationException;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.gui.GuiUtil;
import oracle.oc4j.admin.deploy.gui.StatsNode;
import oracle.oc4j.admin.deploy.gui.StatsPane;

public class EJBStatisticsPane
extends JPanel
implements ActionListener {
    private String _name;
    private StatsNode _node;
    private Stats _stats;
    private Hashtable _funcStats = new Hashtable();
    private JPanel _gridPanel = null;
    private JComboBox _comboBox = null;

    public EJBStatisticsPane(String name, StatsNode node) throws CreationException {
        this._name = name;
        this._node = node;
        this.sortStats();
        this.setLayout(new BorderLayout());
        this.setBackground(Deployer.ViewBackgroundColor);
        JLabel label = new JLabel("Statistics for " + name, 2);
        label.setBorder(BorderFactory.createEmptyBorder(3, 0, 7, 0));
        label.setForeground(Deployer.ViewHeaderColor);
        label.setFont(GuiUtil.getRegularFont());
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new BorderLayout());
        panel.add((Component)label, "North");
        JButton refreshButton = new JButton("Refresh");
        refreshButton.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setOpaque(false);
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(6, 10, 0, 0));
        buttonPanel.setLayout(new BorderLayout());
        buttonPanel.add((Component)refreshButton, "West");
        buttonPanel.add((Component)new JLabel(" "), "South");
        panel.add((Component)buttonPanel, "West");
        this._comboBox = new JComboBox<String>(this.getFunctionNames());
        this._comboBox.setBackground(Deployer.TreeBackgroundColor);
        this._comboBox.setRenderer(new ComboBoxRenderer());
        this._comboBox.addActionListener(this);
        panel.add((Component)this._comboBox, "South");
        this.add((Component)panel, "North");
    }

    private String[] getFunctionNames() {
        String[] names = new String[this._funcStats.size()];
        return this._funcStats.keySet().toArray(names);
    }

    private void sortStats() {
        this._stats = this._node.refreshStats();
        String[] statNames = this._stats.getStatisticNames();
        for (int i = 0; i < statNames.length; ++i) {
            String funcName = null;
            String statType = null;
            int index = statNames[i].indexOf(41);
            if (index == -1) {
                index = statNames[i].indexOf("ejbRemove");
                if (index != -1) {
                    funcName = "ejbRemove";
                    statType = statNames[i].substring(9);
                } else {
                    index = statNames[i].indexOf("ejbActivate");
                    if (index != -1) {
                        funcName = "ejbActivate";
                        statType = statNames[i].substring(11);
                    } else {
                        index = statNames[i].indexOf("ejbPassivate");
                        if (index != -1) {
                            funcName = "ejbPassivate";
                            statType = statNames[i].substring(12);
                        } else {
                            funcName = statNames[i];
                            statType = "";
                        }
                    }
                }
            } else {
                funcName = statNames[i].substring(0, index + 1);
                statType = statNames[i].substring(index + 1);
            }
            FuncStat stat = this.getFuncStat(funcName);
            stat.addStat(statType, this._stats.getStatistic(statNames[i]));
        }
    }

    private void initPane(String funcName) {
        JPanel oldPanel = this._gridPanel;
        FuncStat stat = (FuncStat)this._funcStats.get(funcName);
        this._gridPanel = new StatsPane(stat.getStats(), false);
        if (oldPanel != null) {
            this.remove(oldPanel);
        }
        this.add((Component)this._gridPanel, "Center");
    }

    public void actionPerformed(ActionEvent e) {
        String item = ((String)this._comboBox.getSelectedItem()).trim();
        if (e.getSource() != this._comboBox) {
            this.sortStats();
        } else {
            this._comboBox.setToolTipText(item);
        }
        this.initPane(item);
        this.revalidate();
    }

    private FuncStat getFuncStat(String funcName) {
        FuncStat stat = (FuncStat)this._funcStats.get(funcName);
        if (stat == null) {
            stat = new FuncStat(funcName);
            this._funcStats.put(funcName, stat);
        }
        return stat;
    }

    class FuncStat {
        String _funcName;
        Hashtable _stats = new Hashtable();

        FuncStat(String funcName) {
            this._funcName = funcName;
        }

        void addStat(String statType, Statistic stat) {
            this._stats.put(statType, stat);
        }

        Statistic getStat(String statType) {
            return (Statistic)this._stats.get(statType);
        }

        Statistic[] getStats() {
            Statistic[] stats = new Statistic[this._stats.size()];
            int i = 0;
            Enumeration e = this._stats.elements();
            while (e.hasMoreElements()) {
                stats[i++] = (Statistic)e.nextElement();
            }
            return stats;
        }
    }

    class ComboBoxRenderer
    extends JTextField
    implements ListCellRenderer {
        public ComboBoxRenderer() {
            this.setOpaque(true);
            this.setColumns(40);
            this.setBorder(null);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                list.setToolTipText((String)value);
            } else {
                this.setBackground(Deployer.TreeBackgroundColor);
            }
            this.setText(" " + (String)value);
            this.setEditable(false);
            return this;
        }
    }
}

