/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.gui;

import java.util.Vector;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import oracle.oc4j.admin.deploy.gui.ComboDataEntryElement;
import oracle.oc4j.admin.deploy.gui.DataEntryDialog;
import oracle.oc4j.admin.deploy.gui.DataEntryElement;
import oracle.oc4j.admin.deploy.gui.GuiUtil;
import oracle.oc4j.admin.deploy.gui.ImportSharedLibraryNode;
import oracle.oc4j.admin.deploy.gui.ModifiableRootNode;
import oracle.oc4j.admin.deploy.gui.SharedLibraryNode;
import oracle.oc4j.admin.deploy.gui.SharedLibraryRootNode;
import oracle.oc4j.admin.deploy.gui.StringDataEntryElement;
import oracle.oc4j.admin.deploy.gui.ViewableJTreeNode;
import oracle.oc4j.admin.deploy.gui.ViewableJTreeNodeSupport;
import oracle.oc4j.admin.deploy.spi.ProprietaryConnectedDeploymentManager;
import oracle.oc4j.admin.management.shared.ImportSharedLibrary;
import oracle.oc4j.admin.management.shared.SharedLibrary;

public class ImportSharedLibraryRootNode
extends ViewableJTreeNodeSupport
implements ModifiableRootNode {
    protected String _viewHeaderString = "Import Shared Libraries";
    protected ImportSharedLibrary[] _imports;
    protected DeploymentManager _manager;

    public ImportSharedLibraryRootNode(ImportSharedLibrary[] imports, DeploymentManager manager) {
        this._imports = imports;
        this._manager = manager;
    }

    public String childType() {
        return "Import Shared Library";
    }

    public ViewableJTreeNode addNewChildNode() {
        SharedLibraryNode parent = (SharedLibraryNode)this.getParent();
        SharedLibrary parentLib = parent.getSharedLibrary();
        SharedLibraryRootNode parentRoot = (SharedLibraryRootNode)parent.getParent();
        SharedLibrary[] allLibs = parentRoot.getSharedLibraries();
        Vector<SharedLibrary> otherLibs = new Vector<SharedLibrary>();
        for (int i = 0; i < allLibs.length; ++i) {
            if (allLibs[i].getName().equals(parentLib.getName())) continue;
            boolean alreadyImported = false;
            for (int j = 0; j < this._imports.length; ++j) {
                if (!allLibs[i].getName().equals(this._imports[j].getName())) continue;
                alreadyImported = true;
                break;
            }
            if (alreadyImported) continue;
            otherLibs.add(allLibs[i]);
        }
        DataEntryElement[] childElements = new DataEntryElement[]{new ComboDataEntryElement("Name", otherLibs), new StringDataEntryElement("MinVersion", true), new StringDataEntryElement("MaxVersion", true)};
        DataEntryDialog dialog = DataEntryDialog.createSimpleDataEntryDialog(childElements, "New " + this.childType(), "Enter New " + this.childType() + " Information");
        if (!dialog.showDialog()) {
            return null;
        }
        String name = childElements[0].getValueAsString();
        if (name == null || name.length() == 0) {
            GuiUtil.errDialog("You must enter a value for Name.");
            return null;
        }
        String minVersion = childElements[1].getValueAsString();
        String maxVersion = childElements[2].getValueAsString();
        try {
            parentRoot.setRebuildChildJTree(true);
            SharedLibrary[] shLibs = parentRoot.getSharedLibraries();
            int libNo = -1;
            for (int lib = 0; lib < shLibs.length; ++lib) {
                if (!shLibs[lib].getName().equals(parentLib.getName()) || !shLibs[lib].getVersion().equals(parentLib.getVersion())) continue;
                libNo = lib;
                break;
            }
            if (libNo < 0) {
                GuiUtil.errDialog("The parent shared library does not exist");
                return null;
            }
            ImportSharedLibrary[] imports = shLibs[libNo].getImports();
            for (int imprt = 0; imprt < imports.length; ++imprt) {
                if (!imports[imprt].getName().equals(name)) continue;
                GuiUtil.errDialog(this.childType() + " already exists.");
                return null;
            }
            imports = new ImportSharedLibrary[]{new ImportSharedLibrary(name, minVersion, maxVersion)};
            ProprietaryConnectedDeploymentManager mgr = (ProprietaryConnectedDeploymentManager)this._manager;
            mgr.modifySharedLibrary(new Target[]{parent.getTarget()}, parentLib.getName(), parentLib.getVersion(), null, null, null, null, imports, null);
            ImportSharedLibrary importSharedLibrary = new ImportSharedLibrary(name, minVersion, maxVersion);
            ImportSharedLibraryNode node = new ImportSharedLibraryNode(importSharedLibrary, this._manager);
            this.addJTreeChild(node);
            return node;
        }
        catch (Exception ex) {
            GuiUtil.errDialog("Exception adding " + this.childType() + ": " + ex.getMessage());
            ex.printStackTrace();
            return null;
        }
    }

    public String viewHeaderString() {
        return this._viewHeaderString;
    }

    public String toString() {
        return "Import Shared Libraries";
    }

    public void buildChildJTree() {
        for (int lib = 0; lib < this._imports.length; ++lib) {
            this.addJTreeChild(new ImportSharedLibraryNode(this._imports[lib], this._manager));
        }
    }

    public boolean leaf() {
        return false;
    }
}

