/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.gui;

import java.awt.Color;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import oracle.oc4j.admin.deploy.gui.ComboDataEntryElement;
import oracle.oc4j.admin.deploy.gui.DataEntryDialog;
import oracle.oc4j.admin.deploy.gui.DataEntryElement;
import oracle.oc4j.admin.deploy.gui.DataEntryElementBase;
import oracle.oc4j.admin.deploy.gui.DataEntryPane;
import oracle.oc4j.admin.deploy.gui.GuiUtil;
import oracle.oc4j.admin.deploy.gui.ListDataEntryPane;
import oracle.oc4j.admin.deploy.gui.StringDataEntryElement;

public class ListDataEntryElement
extends DataEntryElementBase {
    private JList _theList;
    private DefaultListModel _theModel = new DefaultListModel();
    Vector _choices = null;

    public ListDataEntryElement(String name) {
        this(name, null, null);
    }

    public ListDataEntryElement(String name, Object[] items) {
        this(name, items, null);
    }

    public ListDataEntryElement(String name, Object[] items, Object[] choices) {
        super(name, false);
        int i;
        if (items != null) {
            for (i = 0; i < items.length; ++i) {
                this._theModel.addElement(items[i]);
            }
        }
        this._theList = new JList(this._theModel);
        this._theList.setSelectionMode(0);
        this._theList.setBackground(Color.white);
        this._theList.setFont(GuiUtil.getRegularFont());
        this.setSwingComponent(this._theList);
        if (choices != null) {
            this._choices = new Vector();
            for (i = 0; i < choices.length; ++i) {
                this._choices.add(choices[i]);
            }
        }
    }

    protected void setValueInComponent(Object value) {
        if (this._choices != null) {
            throw new UnsupportedOperationException("Can't set value of ListDataEntryElement when choices were specified");
        }
        this._theModel.clear();
        if (value instanceof Object[]) {
            Object[] vals = (Object[])value;
            for (int i = 0; i < vals.length; ++i) {
                this._theModel.addElement(vals[i]);
            }
        } else {
            this._theModel.addElement(value);
        }
    }

    public Object getValueFromComponent() {
        int size = this._theList.getModel().getSize();
        String[] elems = new String[size];
        for (int i = 0; i < size; ++i) {
            elems[i] = (String)this._theList.getModel().getElementAt(i);
        }
        return elems;
    }

    public DataEntryPane getDataEntryPanel() {
        return new ListDataEntryPane(this);
    }

    public void removeSelectedElement() {
        int size;
        int index = this._theList.getSelectedIndex();
        Object dross = this._theModel.remove(index);
        if (this._choices != null) {
            this._choices.add(dross);
        }
        if ((size = this._theModel.getSize()) > 0) {
            if (index == size) {
                --index;
            }
            this._theList.setSelectedIndex(index);
            this._theList.ensureIndexIsVisible(index);
        }
    }

    public void promptForNewElement() {
        DataEntryElementBase getItem = null;
        getItem = this._choices == null ? new StringDataEntryElement(this.getName()) : new ComboDataEntryElement(this.getName(), this._choices);
        DataEntryElement[] elems = new DataEntryElement[]{getItem};
        DataEntryDialog dlg = DataEntryDialog.createSimpleDataEntryDialog(elems, 0, "Add " + this.getName(), "Specify new " + this.getName());
        if (dlg.showDialog()) {
            this.addItem(getItem.getValue());
            if (this._choices != null) {
                this._choices.remove(getItem.getValue());
            }
        }
    }

    protected Vector getChoices() {
        return this._choices;
    }

    protected DefaultListModel getTheModel() {
        return this._theModel;
    }

    protected JList getTheList() {
        return this._theList;
    }

    protected void addItem(Object item) {
        this._theModel.addElement(item);
        this._theList.setSelectedIndex(this._theModel.getSize() - 1);
        this._theList.ensureIndexIsVisible(this._theModel.getSize() - 1);
    }
}

