/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.gui;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyEditor;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.MouseInputAdapter;
import oracle.oc4j.admin.deploy.gui.ControllerImpl;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.gui.GuiUtil;
import oracle.oc4j.admin.deploy.gui.PropertyDialog;

public class PropertyComponent
extends JPanel
implements ActionListener {
    protected PropertyEditor _propertyEditor;
    protected PropertyEditor _defaultPropertyEditor;
    protected PropertyDialog _propertyDialog;
    protected JTextField _textField;
    protected JComboBox _comboBox;
    protected JLabel _label;
    protected String _propertyName;

    public PropertyComponent(String name, PropertyEditor propertyEditor, boolean editable) {
        this(name, propertyEditor, editable, null);
    }

    public PropertyComponent(String name, PropertyEditor propertyEditor, boolean editable, PropertyEditor defaultPropertyEditor) {
        boolean custom;
        this._propertyEditor = propertyEditor;
        this._defaultPropertyEditor = defaultPropertyEditor == null ? propertyEditor : defaultPropertyEditor;
        this._propertyName = name;
        this.setLayout(new BorderLayout());
        this.setBackground(Deployer.ValueBackgroundColor);
        String txtValue = this._propertyEditor.getAsText();
        if (txtValue == null) {
            GuiUtil.errDialog("Property Editor " + this._propertyEditor.getClass() + " does not support 'getAsText()' method");
            return;
        }
        if (txtValue.equals("null")) {
            txtValue = "";
        }
        if ((custom = this._propertyEditor.supportsCustomEditor()) || !editable) {
            this._label = new JLabel(txtValue);
            if (txtValue == "") {
                this._label.setText("XX");
                this._label.setPreferredSize(this._label.getPreferredSize());
                this._label.setText("");
            }
            this._label.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(0, 4, 0, 10)));
            this.add(this._label);
            this._label.setFont(GuiUtil.getMediumFont());
            if (custom) {
                this._label.addMouseListener(new ClickListener());
                JFrame parent = ControllerImpl.getSingletonController().getParent();
                this._propertyDialog = new PropertyDialog(parent, this._propertyName, (JComponent)this._propertyEditor.getCustomEditor());
            } else {
                this._label.setForeground(Deployer.ValueForegroundColor);
            }
        } else {
            String[] tags = this._defaultPropertyEditor.getTags();
            if (tags == null) {
                tags = this._propertyEditor.getTags();
            }
            if (tags == null) {
                this._textField = new JTextField(txtValue);
                if (txtValue == "") {
                    this._textField.setText("XX");
                    this._textField.setPreferredSize(this._textField.getPreferredSize());
                    this._textField.setText("");
                }
                this._textField.addActionListener(this);
                this._textField.setBorder(BorderFactory.createCompoundBorder(this._textField.getBorder(), BorderFactory.createEmptyBorder(0, 4, 0, 10)));
                this.add(this._textField);
            } else {
                int i;
                String[] newTags = new String[tags.length + 1];
                newTags[0] = "";
                for (i = 0; i < tags.length; ++i) {
                    newTags[i + 1] = tags[i];
                }
                this._comboBox = new JComboBox<String>(newTags);
                this._comboBox.addActionListener(this);
                this._comboBox.setBackground(Deployer.ValueBackgroundColor);
                for (i = 1; i < newTags.length; ++i) {
                    if (!newTags[i].equals(txtValue)) continue;
                    this._comboBox.setSelectedIndex(i);
                    break;
                }
                this._comboBox.setFont(GuiUtil.getRegularFont());
                this.add(this._comboBox);
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        this.setValueInPropertyEditor();
    }

    public void setValueInPropertyEditor() {
        String value = "";
        if (this._textField != null) {
            value = this._textField.getText();
        } else if (this._comboBox != null) {
            value = (String)this._comboBox.getSelectedItem();
        }
        if (value == null || value.trim().equals("")) {
            this._propertyEditor.setAsText(null);
        } else {
            this._propertyEditor.setValue(this._defaultPropertyEditor.getValue());
            this._propertyEditor.setAsText(value);
        }
    }

    public void setValue(String newValue) {
        if (this._textField != null) {
            this._textField.setText(newValue);
        } else if (this._comboBox != null) {
            this._comboBox.setSelectedItem(newValue);
        } else if (this._label != null) {
            this._label.setText(newValue);
        }
    }

    class ClickListener
    extends MouseInputAdapter {
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                PropertyComponent.this._propertyDialog.showDialog();
                PropertyComponent.this._label.setText(PropertyComponent.this._propertyEditor.getAsText());
            }
        }
    }
}

