/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.TreeNode;
import oracle.oc4j.admin.deploy.gui.CreationException;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.gui.GuiUtil;
import oracle.oc4j.admin.deploy.model.xml.BeanNode;
import oracle.oc4j.admin.deploy.model.xml.CollectionJTreeNode;

public class PropertyListPane
extends JPanel {
    public PropertyListPane(CollectionJTreeNode node) throws CreationException {
        this.setLayout(new BorderLayout());
        this.setBackground(Deployer.ViewBackgroundColor);
        JLabel label = new JLabel(node.viewHeaderString(), 2);
        label.setBorder(BorderFactory.createEmptyBorder(3, 0, 7, 0));
        label.setForeground(Deployer.ViewHeaderColor);
        label.setFont(GuiUtil.getRegularFont());
        this.add((Component)label, "North");
        int numKids = node.getChildCount();
        if (numKids == 0 || !node.listChildren()) {
            return;
        }
        TreeNode bean = node.getChildAt(0);
        String[] columnNames = null;
        Object[][] data = null;
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(bean.getClass(), BeanNode.class);
            PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
            if (descriptors.length == 0) {
                return;
            }
            columnNames = new String[descriptors.length];
            data = new Object[numKids][descriptors.length];
            for (int i = 0; i < descriptors.length; ++i) {
                columnNames[i] = descriptors[i].getDisplayName();
            }
            for (int j = 0; j < numKids; ++j) {
                bean = node.getChildAt(j);
                for (int k = 0; k < descriptors.length; ++k) {
                    Method readMethod = descriptors[k].getReadMethod();
                    data[j][k] = "  " + readMethod.invoke((Object)bean, null);
                }
            }
        }
        catch (Exception ex) {
            throw new CreationException(ex);
        }
        PropertyTableModel tableModel = new PropertyTableModel(data, columnNames);
        JTable table = new JTable(tableModel);
        table.setSelectionMode(0);
        table.setRowHeight(20);
        table.setForeground(Color.red);
        table.getTableHeader().setFont(GuiUtil.getBoldFont());
        table.getTableHeader().setBackground(Deployer.TreeBackgroundColor);
        JScrollPane tablePane = new JScrollPane(table);
        tablePane.getViewport().setBackground(Deployer.ViewBackgroundColor);
        tablePane.setOpaque(false);
        JPanel panel = new JPanel();
        panel.setBackground(Deployer.ViewBackgroundColor);
        panel.setLayout(new BorderLayout());
        panel.add((Component)tablePane, "North");
        this.add((Component)panel, "Center");
    }

    class PropertyTableModel
    extends AbstractTableModel {
        public String[] _columnNames;
        public Object[][] _data;

        public PropertyTableModel(Object[][] data, String[] columns) {
            this._columnNames = columns;
            this._data = data;
        }

        public int getColumnCount() {
            return this._columnNames.length;
        }

        public int getRowCount() {
            return this._data.length;
        }

        public String getColumnName(int col) {
            return this._columnNames[col];
        }

        public Object getValueAt(int row, int col) {
            return this._data[row][col];
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }
    }
}

