/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.gui;

import java.awt.Dimension;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Arrays;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.oc4j.admin.deploy.gui.CreationException;
import oracle.oc4j.admin.deploy.gui.DataElement;
import oracle.oc4j.admin.deploy.gui.DataElementPane;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.gui.GuiUtil;
import oracle.oc4j.admin.deploy.gui.IntegerDataElement;
import oracle.oc4j.admin.deploy.gui.StringDataElement;
import oracle.oc4j.admin.deploy.gui.ViewableJTreeNode;
import oracle.oc4j.admin.deploy.gui.ViewableJTreeNodeSupport;
import oracle.oc4j.admin.deploy.shared.util.PropertyDescriptorComparator;

public class PropertySheetPane
extends JPanel {
    public PropertySheetPane(ViewableJTreeNode bean) throws CreationException {
        this.setLayout(new BoxLayout(this, 1));
        this.setBackground(Deployer.ViewBackgroundColor);
        if (bean.viewHeaderString() != null) {
            JLabel label = GuiUtil.createHeaderLabel(bean.viewHeaderString());
            this.add(label);
        }
        try {
            BeanInfo beanInfo = bean instanceof ViewableJTreeNodeSupport ? Introspector.getBeanInfo(bean.getClass(), ViewableJTreeNodeSupport.class) : Introspector.getBeanInfo(bean.getClass());
            PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
            if (descriptors.length == 0) {
                return;
            }
            Arrays.sort(descriptors, new PropertyDescriptorComparator());
            DataElement[] elements = new DataElement[descriptors.length];
            for (int i = 0; i < descriptors.length; ++i) {
                Method readMethod = descriptors[i].getReadMethod();
                Object obj = readMethod.invoke((Object)bean, null);
                elements[i] = readMethod.getReturnType() == Integer.TYPE ? new IntegerDataElement(descriptors[i].getDisplayName(), (Integer)obj) : new StringDataElement(descriptors[i].getDisplayName(), (String)obj);
            }
            DataElementPane dataPanel = new DataElementPane(elements, true);
            dataPanel.setAlignmentX(0.0f);
            Dimension prefSize = dataPanel.getPreferredSize();
            dataPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, prefSize.height));
            this.add(dataPanel);
        }
        catch (Exception ex) {
            throw new CreationException(ex);
        }
    }
}

