/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.gui;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Date;
import javax.management.j2ee.statistics.Statistic;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.gui.GuiUtil;
import oracle.oc4j.admin.management.shared.statistic.BoundaryStatisticImpl;
import oracle.oc4j.admin.management.shared.statistic.BoundedRangeStatisticImpl;
import oracle.oc4j.admin.management.shared.statistic.CountStatisticImpl;
import oracle.oc4j.admin.management.shared.statistic.RangeStatisticImpl;
import oracle.oc4j.admin.management.shared.statistic.TimeStatisticImpl;

public class StatsPane
extends JPanel {
    private Statistic[] _stats;
    private JPanel _gridPanel;

    public StatsPane(Statistic[] stats) {
        this(stats, true);
    }

    public StatsPane(Statistic[] stats, boolean header) {
        this._stats = stats;
        this.setLayout(new BoxLayout(this, 1));
        this.setOpaque(false);
        for (int i = 0; i < stats.length; ++i) {
            SingleStatPane statPane = new SingleStatPane(stats[i], header);
            this.add(statPane);
            if (i + 1 == stats.length) continue;
            this.add(new JLabel(" "));
        }
    }

    class SingleStatPane
    extends JPanel {
        GridBagLayout _gridbag = new GridBagLayout();
        GridBagConstraints _c = new GridBagConstraints();
        int _row;

        SingleStatPane(Statistic stat, boolean header) {
            this.setLayout(this._gridbag);
            this.setOpaque(false);
            this._c.fill = 1;
            this._c.ipady = 4;
            this._row = 0;
            String desc = stat.getDescription();
            int index = desc.indexOf(" for");
            if (index != -1) {
                desc = desc.substring(0, index);
            }
            String leftStr = null;
            leftStr = header ? stat.getName() : desc;
            JLabel leftLabel = this.createHeaderLabel(leftStr, 2);
            this._c.gridy = this._row++;
            this._c.gridx = 0;
            this._c.weightx = 0.0;
            if (header) {
                this._gridbag.setConstraints(leftLabel, this._c);
                this.add(leftLabel);
                this._c.gridx = 1;
                this._c.weightx = 5.0;
                JLabel rightLabel = this.createHeaderLabel(desc, 2);
                this._gridbag.setConstraints(rightLabel, this._c);
                this.add(rightLabel);
            } else {
                this._c.gridwidth = 2;
                this._gridbag.setConstraints(leftLabel, this._c);
                this.add(leftLabel);
                this._c.gridwidth = 1;
            }
            this.addLine("Units", stat.getUnit());
            this.addLine("StartTime", new Date(stat.getStartTime()).toString());
            this.addLine("Last Sample Time", new Date(stat.getLastSampleTime()).toString());
            if (stat instanceof BoundaryStatisticImpl) {
                BoundaryStatisticImpl bstat = (BoundaryStatisticImpl)stat;
                this.addLine("Upper Bound", Long.toString(bstat.getUpperBound()));
                this.addLine("Lower Bound", Long.toString(bstat.getLowerBound()));
            } else if (stat instanceof RangeStatisticImpl) {
                RangeStatisticImpl rstat = (RangeStatisticImpl)stat;
                this.addLine("High Water Mark", Long.toString(rstat.getHighWaterMark()));
                this.addLine("Low Water Mark", Long.toString(rstat.getLowWaterMark()));
                this.addLine("Current", Long.toString(rstat.getCurrent()));
                if (stat instanceof BoundedRangeStatisticImpl) {
                    BoundedRangeStatisticImpl brstat = (BoundedRangeStatisticImpl)stat;
                    this.addLine("Upper Bound", Long.toString(brstat.getUpperBound()));
                    this.addLine("Lower Bound", Long.toString(brstat.getLowerBound()));
                }
            } else if (stat instanceof CountStatisticImpl) {
                CountStatisticImpl cstat = (CountStatisticImpl)stat;
                this.addLine("Count", Long.toString(cstat.getCount()));
            } else if (stat instanceof TimeStatisticImpl) {
                TimeStatisticImpl tstat = (TimeStatisticImpl)stat;
                this.addLine("Count", Long.toString(tstat.getCount()));
                this.addLine("Max Time", Long.toString(tstat.getMaxTime()));
                this.addLine("Min Time", Long.toString(tstat.getMinTime()));
                this.addLine("Total Time", Long.toString(tstat.getTotalTime()));
            }
        }

        private void addLine(String left, String right) {
            this._c.gridy = this._row++;
            this._c.gridx = 0;
            this._c.weightx = 0.0;
            JLabel leftLabel = this.createLabel(left, 4);
            this._gridbag.setConstraints(leftLabel, this._c);
            this.add(leftLabel);
            this._c.gridx = 1;
            this._c.weightx = 5.0;
            JLabel rightLabel = this.createLabel(right, 2);
            this._gridbag.setConstraints(rightLabel, this._c);
            this.add(rightLabel);
        }

        private JLabel createLabel(String msg) {
            return this.createLabel(msg, 2);
        }

        private JLabel createLabel(String msg, int justification) {
            JLabel label = new JLabel(msg, justification);
            label.setBackground(Deployer.TreeBackgroundColor);
            label.setOpaque(true);
            label.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(0, 4, 0, 10)));
            label.setFont(GuiUtil.getRegularFont());
            return label;
        }

        private JLabel createHeaderLabel(String msg, int justification) {
            JLabel label = new JLabel(msg, justification);
            label.setBackground(new Color(255, 246, 203));
            label.setForeground(new Color(255, 116, 116));
            label.setOpaque(true);
            label.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(0, 4, 0, 10)));
            return label;
        }
    }
}

