/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.model.file;

import java.io.File;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.model.J2eeApplicationObject;
import javax.enterprise.deploy.model.XpathListener;
import javax.enterprise.deploy.shared.ModuleType;
import oracle.oc4j.admin.deploy.model.file.CarFile;
import oracle.oc4j.admin.deploy.model.file.EjbFile;
import oracle.oc4j.admin.deploy.model.file.J2eeFile;
import oracle.oc4j.admin.deploy.model.file.RarFile;
import oracle.oc4j.admin.deploy.model.file.WarFile;
import oracle.oc4j.admin.deploy.model.xml.BeanRootNode;
import oracle.oc4j.admin.deploy.model.xml.EarStdXml;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.FormattingResourceBundle;
import oracle.xml.parser.v2.XMLDocument;

public class EarFile
extends J2eeFile
implements J2eeApplicationObject {
    protected DeployableObject[] _ejbDeployableObjects = null;
    protected DeployableObject[] _warDeployableObjects = null;
    protected DeployableObject[] _carDeployableObjects = null;
    protected DeployableObject[] _rarDeployableObjects = null;
    protected DeployableObject[] _deployableObjects = null;
    protected String[] _moduleUris = null;
    protected String[] _ejbModuleUris = null;
    protected String[] _warModuleUris = null;
    protected String[] _carModuleUris = null;
    protected String[] _rarModuleUris = null;
    protected Hashtable _deployableObjectsByUri = null;

    public EarFile(File earFile) throws ExtendedRuntimeException {
        this(earFile, false);
    }

    public EarFile(File earFile, boolean dtdValidation) throws ExtendedRuntimeException {
        super(earFile, dtdValidation);
        this.init(earFile);
    }

    public DeployableObject getDeployableObject(String uri) {
        return (DeployableObject)this._deployableObjectsByUri.get(uri);
    }

    public DeployableObject[] getDeployableObjects(ModuleType type) {
        if (type == ModuleType.EJB) {
            return this._ejbDeployableObjects;
        }
        if (type == ModuleType.WAR) {
            return this._warDeployableObjects;
        }
        if (type == ModuleType.CAR) {
            return this._carDeployableObjects;
        }
        if (type == ModuleType.RAR) {
            return this._rarDeployableObjects;
        }
        return null;
    }

    public DeployableObject[] getDeployableObjects() {
        return this._deployableObjects;
    }

    public String[] getModuleUris(ModuleType type) {
        if (type == ModuleType.EJB) {
            return this._ejbModuleUris;
        }
        if (type == ModuleType.WAR) {
            return this._warModuleUris;
        }
        if (type == ModuleType.CAR) {
            return this._carModuleUris;
        }
        if (type == ModuleType.RAR) {
            return this._rarModuleUris;
        }
        return null;
    }

    public String[] getModuleUris() {
        return this._moduleUris;
    }

    public DDBean[] getChildBean(ModuleType type, String xpath) {
        return null;
    }

    public String[] getText(ModuleType type, String xpath) {
        return null;
    }

    public ModuleType getType() {
        return ModuleType.EAR;
    }

    public void addXpathListener(ModuleType type, String xpath, XpathListener xpl) {
    }

    public void removeXpathListener(ModuleType type, String xpath, XpathListener xpl) {
    }

    public boolean checkStdXml(BeanRootNode stdXml) {
        return this.checkParam(stdXml, "oracle.oc4j.admin.deploy.model.xml.EarStdXml");
    }

    public String getStdXmlEntry() {
        return "META-INF/application.xml";
    }

    public void noConfiguration(boolean noConfig) {
        super.noConfiguration(noConfig);
        if (this._deployableObjects != null) {
            for (int n = 0; n < this._deployableObjects.length; ++n) {
                J2eeFile j2eeFile = (J2eeFile)this._deployableObjects[n];
                j2eeFile.noConfiguration(noConfig);
            }
        }
    }

    public void close() {
        int n;
        if (this._ejbDeployableObjects != null) {
            for (n = 0; n < this._ejbDeployableObjects.length; ++n) {
                EjbFile ejbFile = (EjbFile)this._ejbDeployableObjects[n];
                ejbFile.close();
            }
            this._ejbDeployableObjects = null;
        }
        if (this._warDeployableObjects != null) {
            for (n = 0; n < this._warDeployableObjects.length; ++n) {
                WarFile warFile = (WarFile)this._warDeployableObjects[n];
                warFile.close();
            }
            this._warDeployableObjects = null;
        }
        if (this._carDeployableObjects != null) {
            for (n = 0; n < this._carDeployableObjects.length; ++n) {
                CarFile carFile = (CarFile)this._carDeployableObjects[n];
                carFile.close();
            }
            this._carDeployableObjects = null;
        }
        if (this._rarDeployableObjects != null) {
            for (n = 0; n < this._rarDeployableObjects.length; ++n) {
                RarFile rarFile = (RarFile)this._rarDeployableObjects[n];
                rarFile.close();
            }
            this._rarDeployableObjects = null;
        }
        this._deployableObjects = null;
        this._moduleUris = null;
        this._ejbModuleUris = null;
        this._warModuleUris = null;
        this._carModuleUris = null;
        this._rarModuleUris = null;
        this._deployableObjectsByUri = null;
        super.close();
    }

    public EarFile copy(File dest) throws ExtendedRuntimeException {
        try {
            this.copyToFile(dest);
            return new EarFile(dest);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public static EarFile copy(InputStream inStrm) throws ExtendedRuntimeException {
        try {
            File tmpEar = File.createTempFile("dep", ".ear");
            EarFile.copyStreamToFile(inStrm, tmpEar);
            EarFile ret = new EarFile(tmpEar);
            ret._tmpFile = true;
            return ret;
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    private void init(File earFile) throws ExtendedRuntimeException {
        try {
            XMLDocument doc = this.getXmlDocument(this.getStdXmlEntry());
            if (doc == null) {
                throw new ExtendedRuntimeException(FormattingResourceBundle.DeploymentMessages.getString("missingStdDesc", new String[]{earFile.getAbsolutePath(), this.getStdXmlEntry()}));
            }
            this.setStdXml(new EarStdXml(doc, this));
            Vector<EjbFile> allModules = new Vector<EjbFile>();
            this._deployableObjects = new DeployableObject[0];
            this._deployableObjectsByUri = new Hashtable();
            DDBean[] modules = this.getChildBean("/application/module");
            Vector<EjbFile> ejbModules = new Vector<EjbFile>();
            Vector<EjbFile> warModules = new Vector<EjbFile>();
            Vector<EjbFile> carModules = new Vector<EjbFile>();
            Vector<EjbFile> rarModules = new Vector<EjbFile>();
            Vector<String> moduleUris = new Vector<String>();
            String uri = null;
            for (int n = 0; n < modules.length; ++n) {
                DDBean[] rars;
                DDBean[] cars;
                DDBean[] wars;
                DDBean[] ejbs;
                J2eeFile j2eeFile = null;
                String[] altDDs = modules[n].getText("alt-dd");
                String altDD = null;
                if (altDDs != null && altDDs.length > 0) {
                    altDD = altDDs[0];
                }
                if ((ejbs = modules[n].getChildBean("ejb")) != null && ejbs.length > 0) {
                    uri = ejbs[0].getText();
                    j2eeFile = new EjbFile(altDD, uri, this, this.getDtdValidationMode());
                    ejbModules.add((EjbFile)j2eeFile);
                }
                if ((wars = modules[n].getChildBean("web/web-uri")) != null && wars.length > 0) {
                    uri = wars[0].getText();
                    j2eeFile = new WarFile(altDD, uri, this, this.getDtdValidationMode());
                    warModules.add((EjbFile)j2eeFile);
                }
                if ((cars = modules[n].getChildBean("java")) != null && cars.length > 0) {
                    uri = cars[0].getText();
                    j2eeFile = new CarFile(altDD, uri, this, this.getDtdValidationMode());
                    carModules.add((EjbFile)j2eeFile);
                }
                if ((rars = modules[n].getChildBean("connector")) != null && rars.length > 0) {
                    uri = rars[0].getText();
                    j2eeFile = new RarFile(altDD, uri, this, this.getDtdValidationMode());
                    rarModules.add((EjbFile)j2eeFile);
                }
                allModules.add((EjbFile)j2eeFile);
                this._deployableObjectsByUri.put(uri, j2eeFile);
                if (moduleUris.contains(uri)) {
                    throw new ExtendedRuntimeException(FormattingResourceBundle.DeploymentMessages.getString("onlyOneAllowed", new String[]{uri + " module"}));
                }
                moduleUris.add(uri);
            }
            this._ejbModuleUris = this.getText("/application/module/ejb");
            this._warModuleUris = this.getText("/application/module/web/web-uri");
            this._carModuleUris = this.getText("/application/module/java");
            this._rarModuleUris = this.getText("/application/module/connector");
            if (this._ejbModuleUris != null && this._ejbModuleUris.length > 0) {
                this._ejbDeployableObjects = new EjbFile[1];
                this._ejbDeployableObjects = ejbModules.toArray(this._ejbDeployableObjects);
            }
            if (this._warModuleUris != null && this._warModuleUris.length > 0) {
                this._warDeployableObjects = new WarFile[1];
                this._warDeployableObjects = warModules.toArray(this._warDeployableObjects);
            }
            if (this._carModuleUris != null && this._carModuleUris.length > 0) {
                this._carDeployableObjects = new CarFile[1];
                this._carDeployableObjects = carModules.toArray(this._carDeployableObjects);
            }
            if (this._rarModuleUris != null && this._rarModuleUris.length > 0) {
                this._rarDeployableObjects = new RarFile[1];
                this._rarDeployableObjects = rarModules.toArray(this._rarDeployableObjects);
            }
            if (allModules.size() > 0) {
                this._deployableObjects = allModules.toArray(this._deployableObjects);
                this._moduleUris = moduleUris.toArray(new String[0]);
            }
        }
        catch (ExtendedRuntimeException ExT) {
            this.close();
            throw ExT;
        }
        catch (Throwable t) {
            this.close();
            throw new ExtendedRuntimeException(t);
        }
    }
}

