/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.model.xml;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Vector;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.model.J2eeApplicationObject;
import oracle.oc4j.admin.deploy.gui.ViewableJTreeNode;
import oracle.oc4j.admin.deploy.model.xml.BeanNode;
import oracle.oc4j.admin.deploy.model.xml.CarModuleBean;
import oracle.oc4j.admin.deploy.model.xml.CollectionJTreeNode;
import oracle.oc4j.admin.deploy.model.xml.EarStdXml;
import oracle.oc4j.admin.deploy.model.xml.EjbModuleBean;
import oracle.oc4j.admin.deploy.model.xml.IconBean;
import oracle.oc4j.admin.deploy.model.xml.ModuleBean;
import oracle.oc4j.admin.deploy.model.xml.RarModuleBean;
import oracle.oc4j.admin.deploy.model.xml.SecurityRoleBean;
import oracle.oc4j.admin.deploy.model.xml.StringBean;
import oracle.oc4j.admin.deploy.model.xml.WarModuleBean;
import oracle.oc4j.admin.deploy.model.xml.WebBean;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.xml.J2eeXmlNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ApplicationBean
extends BeanNode {
    public ApplicationBean(Node node, DDBean parent) {
        super(node, parent);
        this.init(node);
    }

    public String getVersion() {
        String ret = "";
        J2eeXmlNode parent = this.getXmlParent();
        if (parent != null && parent instanceof EarStdXml) {
            EarStdXml xml = (EarStdXml)parent;
            ret = xml.getModuleDTDVersion();
        }
        return ret;
    }

    public String getDisplayName() {
        return this.nodeValue("display-name");
    }

    public String getDescription() {
        return this.nodeValue("description");
    }

    public String getSmallIcon() {
        return this.nodeValue("icon/small-icon");
    }

    public String getLargeIcon() {
        return this.nodeValue("icon/large-icon");
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        out.println(indentation + "<" + "application" + ">");
        ApplicationBean.writeAll(this.getChildBean("icon"), out, indentation + "\t");
        ApplicationBean.writeAll(this.getChildBean("display-name"), out, indentation + "\t");
        ApplicationBean.writeAll(this.getChildBean("description"), out, indentation + "\t");
        ApplicationBean.writeAll(this.getChildBean("module"), out, indentation + "\t");
        ApplicationBean.writeAll(this.getChildBean("security-role"), out, indentation + "\t");
        out.println(indentation + "</" + "application" + ">");
    }

    protected Collection createSpecialJTreeChildren() {
        Vector<ViewableJTreeNode> vec = new Vector<ViewableJTreeNode>();
        if (this.getNumJTreeChildren() == 0) {
            J2eeApplicationObject appObj;
            int j;
            CollectionJTreeNode node = new CollectionJTreeNode(this, "security-role", "Security Roles", true);
            vec.add(node);
            DDBean[] beans = this.getChildBean("module/ejb");
            if (beans != null) {
                for (j = 0; j < beans.length; ++j) {
                    appObj = (J2eeApplicationObject)beans[j].getRoot().getDeployableObject();
                    DeployableObject ejbObj = appObj.getDeployableObject(beans[j].getText(".")[0]);
                    EjbModuleBean ejbModuleBean = (EjbModuleBean)ejbObj.getChildBean("/ejb-jar")[0];
                    vec.add(ejbModuleBean);
                    ejbModuleBean.setURI(beans[j].getText(".")[0]);
                }
            }
            if ((beans = this.getChildBean("module/web")) != null) {
                for (int k = 0; k < beans.length; ++k) {
                    WebBean webBean = (WebBean)beans[k];
                    J2eeApplicationObject appObj2 = (J2eeApplicationObject)webBean.getRoot().getDeployableObject();
                    DeployableObject webObj = appObj2.getDeployableObject(webBean.getWebUri());
                    WarModuleBean warModuleBean = (WarModuleBean)webObj.getChildBean("/web-app")[0];
                    vec.add(warModuleBean);
                    warModuleBean.linkWebBean(webBean);
                }
            }
            if ((beans = this.getChildBean("module/java")) != null) {
                for (j = 0; j < beans.length; ++j) {
                    appObj = (J2eeApplicationObject)beans[j].getRoot().getDeployableObject();
                    DeployableObject carObj = appObj.getDeployableObject(beans[j].getText(".")[0]);
                    CarModuleBean carModuleBean = (CarModuleBean)carObj.getChildBean("/application-client")[0];
                    vec.add(carModuleBean);
                    carModuleBean.setURI(beans[j].getText(".")[0]);
                }
            }
            if ((beans = this.getChildBean("module/connector")) != null) {
                for (j = 0; j < beans.length; ++j) {
                    appObj = (J2eeApplicationObject)beans[j].getRoot().getDeployableObject();
                    DeployableObject rarObj = appObj.getDeployableObject(beans[j].getText(".")[0]);
                    RarModuleBean rarModuleBean = (RarModuleBean)rarObj.getChildBean("/connector")[0];
                    vec.add(rarModuleBean);
                    rarModuleBean.setURI(beans[j].getText(".")[0]);
                }
            }
        }
        return vec;
    }

    public String jtreeToolTip() {
        return "J2EE Application";
    }

    public String toString() {
        return this.getDisplayName();
    }

    private void init(Node rootNode) {
        this.setXpath("application");
        Vector<IconBean> icon = new Vector<IconBean>(1);
        Vector<IconBean> displayName = new Vector<IconBean>(1);
        Vector<IconBean> description = new Vector<IconBean>(1);
        Vector<IconBean> modules = new Vector<IconBean>();
        Vector<IconBean> securityRoles = new Vector<IconBean>();
        NodeList nodes = rootNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            BeanNode bean;
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (name.equals("icon")) {
                bean = new IconBean(node, this);
                icon.add((IconBean)bean);
            }
            if (name.equals("display-name")) {
                bean = new StringBean(node, this, "display-name");
                displayName.add((IconBean)bean);
            }
            if (name.equals("description")) {
                bean = new StringBean(node, this, "description");
                description.add((IconBean)bean);
            }
            if (name.equals("module")) {
                bean = new ModuleBean(node, this);
                modules.add((IconBean)bean);
            }
            if (!name.equals("security-role")) continue;
            bean = new SecurityRoleBean(node, this);
            securityRoles.add((IconBean)bean);
        }
        this.recordXpathForBeans("icon", icon);
        this.recordXpathForBeans("display-name", displayName);
        this.recordXpathForBeans("description", description);
        this.recordXpathForBeans("module", modules);
        this.recordXpathForBeans("security-role", securityRoles);
    }
}

