/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.model.xml;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;
import javax.enterprise.deploy.model.DDBean;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.tree.TreeNode;
import oracle.oc4j.admin.deploy.gui.CreationException;
import oracle.oc4j.admin.deploy.gui.PropertyListPane;
import oracle.oc4j.admin.deploy.gui.ViewableJTree;
import oracle.oc4j.admin.deploy.gui.ViewableJTreeNode;
import oracle.oc4j.admin.deploy.model.xml.BeanNode;

public class CollectionJTreeNode
implements ViewableJTreeNode {
    protected BeanNode _parent;
    protected String _childXpath;
    protected String _displayName;
    protected Vector _jtreeChildren = new Vector();
    protected boolean _hasChildren;
    protected boolean _listChildren = true;
    protected JComponent _viewPane;
    private boolean _semiSelected;

    public CollectionJTreeNode(BeanNode parent, String childPath, String name, boolean hasChildren) {
        this._parent = parent;
        this._childXpath = childPath;
        this._displayName = name;
        this._hasChildren = hasChildren;
    }

    protected void buildChildJTree() {
        DDBean[] beans;
        if (this._jtreeChildren.size() == 0 && (beans = this._parent.getChildBean(this._childXpath)) != null) {
            for (int j = 0; j < beans.length; ++j) {
                this.addJTreeChild((ViewableJTreeNode)beans[j]);
            }
        }
    }

    public void addJTreeChild(ViewableJTreeNode node) {
        this._jtreeChildren.add(node);
        node.setJTreeParent(this);
    }

    public void setJTreeParent(ViewableJTreeNode parent) {
        this._parent = (BeanNode)parent;
    }

    public String viewHeaderString() {
        return this._parent.getXpath() + "/" + this._childXpath + "*";
    }

    public String getDisplayName() {
        return this._displayName;
    }

    public String jtreeIconName() {
        StringBuffer buf = new StringBuffer(this._displayName);
        int index = this._displayName.length();
        while ((index = this._displayName.lastIndexOf(32, index - 1)) > 0) {
            buf.deleteCharAt(index);
        }
        return new String(buf);
    }

    public boolean listChildren() {
        return this._listChildren;
    }

    public void setListChildren(boolean listChildren) {
        this._listChildren = listChildren;
    }

    public String jtreeToolTip() {
        return null;
    }

    public JComponent viewComponent() throws CreationException {
        if (this._viewPane == null) {
            this._viewPane = new PropertyListPane(this);
            this._viewPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 4));
        }
        return this._viewPane;
    }

    public TreeNode getChildAt(int childIndex) {
        this.buildChildJTree();
        return (TreeNode)this._jtreeChildren.elementAt(childIndex);
    }

    public int getChildCount() {
        this.buildChildJTree();
        return this._jtreeChildren.size();
    }

    public TreeNode getParent() {
        return this._parent;
    }

    public int getIndex(TreeNode node) {
        this.buildChildJTree();
        return this._jtreeChildren.indexOf(node);
    }

    public boolean getAllowsChildren() {
        return this._hasChildren;
    }

    public boolean isLeaf() {
        return !this._hasChildren;
    }

    public Enumeration children() {
        this.buildChildJTree();
        return this._jtreeChildren.elements();
    }

    public ViewableJTree[] subTrees() {
        return null;
    }

    public void setSemiSelected(boolean sel) {
        this._semiSelected = sel;
    }

    public boolean isSemiSelected() {
        return this._semiSelected;
    }

    public Collection getPopupMenuItems(ViewableJTree jtree) {
        return null;
    }

    public String toString() {
        return this._displayName;
    }
}

