/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.model.xml;

import java.io.PrintWriter;
import java.util.Vector;
import javax.enterprise.deploy.model.DDBean;
import oracle.oc4j.admin.deploy.model.xml.BeanNode;
import oracle.oc4j.admin.deploy.model.xml.StringBean;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ContextParamBean
extends BeanNode {
    public ContextParamBean(Node node, DDBean parent) {
        super(node, parent);
        this.init(node);
    }

    public String getParamName() {
        return this.nodeValue("param-name");
    }

    public String getParamValue() {
        return this.nodeValue("param-value");
    }

    public String getDescription() {
        return this.nodeValue("description");
    }

    public String toString() {
        return this.getParamName();
    }

    protected boolean leaf() {
        return true;
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        out.println(indentation + "<" + "context-param" + ">");
        ContextParamBean.writeAll(this.getChildBean("param-name"), out, indentation + "\t");
        ContextParamBean.writeAll(this.getChildBean("param-value"), out, indentation + "\t");
        ContextParamBean.writeAll(this.getChildBean("description"), out, indentation + "\t");
        out.println(indentation + "</" + "context-param" + ">");
    }

    private void init(Node rootNode) {
        this.setXpath("context-param");
        Vector<StringBean> description = new Vector<StringBean>(1);
        Vector<StringBean> paramName = new Vector<StringBean>(1);
        Vector<StringBean> paramValue = new Vector<StringBean>(1);
        NodeList nodes = rootNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            StringBean bean;
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (name.equals("param-name")) {
                bean = new StringBean(node, this, "param-name");
                paramName.add(bean);
                continue;
            }
            if (name.equals("param-value")) {
                bean = new StringBean(node, this, "param-value");
                paramValue.add(bean);
                continue;
            }
            if (!name.equals("description")) continue;
            bean = new StringBean(node, this, "description");
            description.add(bean);
        }
        this.recordXpathForBeans("param-name", paramName);
        this.recordXpathForBeans("param-value", paramValue);
        this.recordXpathForBeans("description", description);
    }
}

