/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.model.xml;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Vector;
import javax.enterprise.deploy.model.DDBean;
import oracle.oc4j.admin.deploy.model.xml.BeanNode;
import oracle.oc4j.admin.deploy.model.xml.CmrFieldBean;
import oracle.oc4j.admin.deploy.model.xml.RelationshipRoleSourceBean;
import oracle.oc4j.admin.deploy.model.xml.StringBean;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EjbRelationshipRoleBean
extends BeanNode {
    public EjbRelationshipRoleBean(Node node, DDBean parent) {
        super(node, parent);
        this.init(node);
    }

    public String getDescription() {
        return this.nodeValue("description");
    }

    public String getEjbRelationshipRoleName() {
        return this.nodeValue("ejb-relationship-role-name");
    }

    public String getMultiplicity() {
        return this.nodeValue("multiplicity");
    }

    public boolean isCascadeDelete() {
        Vector v = this.resolveXpath("cascade-delete");
        return v != null && v.size() != 0;
    }

    protected Collection createSpecialJTreeChildren() {
        DDBean[] cmrField;
        Vector<DDBean> vec = new Vector<DDBean>();
        String childPath = "relationship-role-source";
        DDBean[] relationshipRoleSource = this.getChildBean(childPath);
        if (relationshipRoleSource != null && relationshipRoleSource.length > 0) {
            vec.add(relationshipRoleSource[0]);
        }
        if ((cmrField = this.getChildBean(childPath = "cmr-field")) != null && cmrField.length > 0) {
            vec.add(cmrField[0]);
        }
        return vec;
    }

    public String toString() {
        return "Ejb Relationship Role";
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        out.println(indentation + "<" + "ejb-relationship-role" + ">");
        EjbRelationshipRoleBean.writeAll(this.getChildBean("description"), out, indentation + "\t");
        EjbRelationshipRoleBean.writeAll(this.getChildBean("ejb-relationship-role-name"), out, indentation + "\t");
        EjbRelationshipRoleBean.writeAll(this.getChildBean("multiplicity"), out, indentation + "\t");
        EjbRelationshipRoleBean.writeAll(this.getChildBean("cascade-delete"), out, indentation + "\t");
        EjbRelationshipRoleBean.writeAll(this.getChildBean("relationship-role-source"), out, indentation + "\t");
        EjbRelationshipRoleBean.writeAll(this.getChildBean("cmr-field"), out, indentation + "\t");
        out.println(indentation + "</" + "ejb-relationship-role" + ">");
    }

    private void init(Node rootNode) {
        this.setXpath("ejb-relationship-role");
        Vector<StringBean> description = new Vector<StringBean>(1);
        Vector<StringBean> ejbRelationshipRoleName = new Vector<StringBean>(1);
        Vector<StringBean> multiplicity = new Vector<StringBean>(1);
        Vector<StringBean> cascadeDelete = new Vector<StringBean>(1);
        Vector<StringBean> relationshipRoleSource = new Vector<StringBean>(1);
        Vector<StringBean> cmrField = new Vector<StringBean>(1);
        NodeList nodes = rootNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            BeanNode bean;
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (name.equals("description")) {
                bean = new StringBean(node, this, "description");
                description.add((StringBean)bean);
            }
            if (name.equals("ejb-relationship-role-name")) {
                bean = new StringBean(node, this, "ejb-relationship-role-name");
                ejbRelationshipRoleName.add((StringBean)bean);
            }
            if (name.equals("multiplicity")) {
                bean = new StringBean(node, this, "multiplicity");
                multiplicity.add((StringBean)bean);
            }
            if (name.equals("cascade-delete")) {
                bean = new StringBean(node, this, "cascade-delete");
                cascadeDelete.add((StringBean)bean);
            }
            if (name.equals("relationship-role-source")) {
                bean = new RelationshipRoleSourceBean(node, this);
                relationshipRoleSource.add((StringBean)bean);
            }
            if (!name.equals("cmr-field")) continue;
            bean = new CmrFieldBean(node, this);
            cmrField.add((StringBean)bean);
        }
        this.recordXpathForBeans("description", description);
        this.recordXpathForBeans("ejb-relationship-role-name", ejbRelationshipRoleName);
        this.recordXpathForBeans("multiplicity", multiplicity);
        this.recordXpathForBeans("cascade-delete", cascadeDelete);
        this.recordXpathForBeans("relationship-role-source", relationshipRoleSource);
        this.recordXpathForBeans("cmr-field", cmrField);
    }
}

