/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.model.xml;

import java.io.PrintWriter;
import java.util.Vector;
import javax.enterprise.deploy.model.DDBean;
import oracle.oc4j.admin.deploy.model.xml.BeanNode;
import oracle.oc4j.admin.deploy.model.xml.StringBean;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ErrorPageBean
extends BeanNode {
    public ErrorPageBean(Node node, DDBean parent) {
        super(node, parent);
        this.init(node);
    }

    public String getErrorCode() {
        return this.nodeValue("error-code");
    }

    public String getExceptionType() {
        return this.nodeValue("exception-type");
    }

    public String getLocation() {
        return this.nodeValue("location");
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        out.println(indentation + "<" + "error-page" + ">");
        ErrorPageBean.writeAll(this.getChildBean("error-code"), out, indentation + "\t");
        ErrorPageBean.writeAll(this.getChildBean("exception-type"), out, indentation + "\t");
        ErrorPageBean.writeAll(this.getChildBean("location"), out, indentation + "\t");
        out.println(indentation + "</" + "error-page" + ">");
    }

    private void init(Node rootNode) {
        this.setXpath("error-page");
        Vector<StringBean> errorCode = new Vector<StringBean>(1);
        Vector<StringBean> exceptionType = new Vector<StringBean>(1);
        Vector<StringBean> location = new Vector<StringBean>(1);
        NodeList nodes = rootNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            StringBean bean;
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (name.equals("error-code")) {
                bean = new StringBean(node, this, "error-code");
                errorCode.add(bean);
                continue;
            }
            if (name.equals("exception-type")) {
                bean = new StringBean(node, this, "exception-type");
                exceptionType.add(bean);
                continue;
            }
            if (!name.equals("location")) continue;
            bean = new StringBean(node, this, "location");
            location.add(bean);
        }
        this.recordXpathForBeans("error-code", errorCode);
        this.recordXpathForBeans("exception-type", exceptionType);
        this.recordXpathForBeans("location", location);
    }
}

