/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.model.xml;

import java.io.PrintWriter;
import java.util.Vector;
import javax.enterprise.deploy.model.DDBean;
import oracle.oc4j.admin.deploy.model.xml.BeanNode;
import oracle.oc4j.admin.deploy.model.xml.StringBean;
import oracle.oc4j.admin.deploy.model.xml.WebBean;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ModuleBean
extends BeanNode {
    public ModuleBean(Node node, DDBean parent) {
        super(node, parent);
        this.init(node);
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        out.println(indentation + "<" + "module" + ">");
        ModuleBean.writeAll(this.getChildBean("connector"), out, indentation + "\t");
        ModuleBean.writeAll(this.getChildBean("ejb"), out, indentation + "\t");
        ModuleBean.writeAll(this.getChildBean("java"), out, indentation + "\t");
        ModuleBean.writeAll(this.getChildBean("web"), out, indentation + "\t");
        ModuleBean.writeAll(this.getChildBean("alt-dd"), out, indentation + "\t");
        out.println(indentation + "</" + "module" + ">");
    }

    private void init(Node rootNode) {
        this.setXpath("module");
        Vector<StringBean> rars = new Vector<StringBean>();
        Vector<StringBean> ejbs = new Vector<StringBean>();
        Vector<StringBean> javas = new Vector<StringBean>();
        Vector<WebBean> webs = new Vector<WebBean>();
        Vector<StringBean> altDD = new Vector<StringBean>(1);
        NodeList nodes = rootNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            StringBean bean;
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (name.equals("connector")) {
                bean = new StringBean(node, this, "connector");
                rars.add(bean);
                continue;
            }
            if (name.equals("ejb")) {
                bean = new StringBean(node, this, "ejb");
                ejbs.add(bean);
                continue;
            }
            if (name.equals("java")) {
                bean = new StringBean(node, this, "java");
                javas.add(bean);
                continue;
            }
            if (name.equals("web")) {
                WebBean webBean = new WebBean(node, this);
                webs.add(webBean);
                continue;
            }
            if (!name.equals("alt-dd")) continue;
            bean = new StringBean(node, this, "alt-dd");
            altDD.add(bean);
        }
        this.recordXpathForBeans("connector", rars);
        this.recordXpathForBeans("ejb", ejbs);
        this.recordXpathForBeans("java", javas);
        this.recordXpathForBeans("web", webs);
        this.recordXpathForBeans("alt-dd", altDD);
    }
}

