/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.model.xml;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Vector;
import javax.enterprise.deploy.model.DDBean;
import oracle.oc4j.admin.deploy.model.xml.AuthenticationMechanismBean;
import oracle.oc4j.admin.deploy.model.xml.BeanNode;
import oracle.oc4j.admin.deploy.model.xml.CollectionJTreeNode;
import oracle.oc4j.admin.deploy.model.xml.ConnectionDefinition15Bean;
import oracle.oc4j.admin.deploy.model.xml.StringBean;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OutboundResourceAdapter15Bean
extends BeanNode {
    public OutboundResourceAdapter15Bean(Node node, DDBean parent) {
        super(node, parent);
        this.init(node);
    }

    public String getTransactionSupport() {
        return this.nodeValue("transaction-support");
    }

    public String getReauthenticationSupport() {
        return this.nodeValue("reauthentication-support");
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        out.println(indentation + "<" + "outbound-resourceadapter" + ">");
        OutboundResourceAdapter15Bean.writeAll(this.getChildBean("connection-definition"), out, indentation + "\t");
        OutboundResourceAdapter15Bean.writeAll(this.getChildBean("transaction-support"), out, indentation + "\t");
        OutboundResourceAdapter15Bean.writeAll(this.getChildBean("authentication-mechanism"), out, indentation + "\t");
        OutboundResourceAdapter15Bean.writeAll(this.getChildBean("reauthentication-support"), out, indentation + "\t");
        out.println(indentation + "</" + "outbound-resourceadapter" + ">");
    }

    protected Collection createSpecialJTreeChildren() {
        Vector<CollectionJTreeNode> vec = new Vector<CollectionJTreeNode>();
        vec.add(new CollectionJTreeNode(this, "connection-definition", "Connection Definitions", true));
        vec.add(new CollectionJTreeNode(this, "authentication-mechanism", "Authentication Mechanisms", true));
        return vec;
    }

    public String toString() {
        return "Outbound Resource Adapter";
    }

    private void init(Node rootNode) {
        this.setXpath("outbound-resourceadapter");
        Vector<ConnectionDefinition15Bean> transactionSupport = new Vector<ConnectionDefinition15Bean>(1);
        Vector<ConnectionDefinition15Bean> connectionDefinition = new Vector<ConnectionDefinition15Bean>(1);
        Vector<ConnectionDefinition15Bean> authenticationMechanism = new Vector<ConnectionDefinition15Bean>();
        Vector<ConnectionDefinition15Bean> reauthenticationSupport = new Vector<ConnectionDefinition15Bean>(1);
        NodeList nodes = rootNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            BeanNode bean;
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (name.equals("connection-definition")) {
                bean = new ConnectionDefinition15Bean(node, this);
                connectionDefinition.add((ConnectionDefinition15Bean)bean);
                continue;
            }
            if (name.equals("transaction-support")) {
                bean = new StringBean(node, this, "transaction-support");
                transactionSupport.add((ConnectionDefinition15Bean)bean);
                continue;
            }
            if (name.equals("authentication-mechanism")) {
                bean = new AuthenticationMechanismBean(node, this);
                authenticationMechanism.add((ConnectionDefinition15Bean)bean);
                continue;
            }
            if (!name.equals("reauthentication-support")) continue;
            bean = new StringBean(node, this, "reauthentication-support");
            reauthenticationSupport.add((ConnectionDefinition15Bean)bean);
        }
        this.recordXpathForBeans("connection-definition", connectionDefinition);
        this.recordXpathForBeans("transaction-support", transactionSupport);
        this.recordXpathForBeans("authentication-mechanism", authenticationMechanism);
        this.recordXpathForBeans("reauthentication-support", reauthenticationSupport);
    }
}

