/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.model.xml;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Vector;
import javax.enterprise.deploy.model.DDBean;
import oracle.oc4j.admin.deploy.model.xml.BeanNode;
import oracle.oc4j.admin.deploy.model.xml.IconBean;
import oracle.oc4j.admin.deploy.model.xml.PortComponentHandlerBean;
import oracle.oc4j.admin.deploy.model.xml.ServiceImplBeanBean;
import oracle.oc4j.admin.deploy.model.xml.StringBean;
import oracle.oc4j.admin.deploy.model.xml.WsdlPortBean;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PortComponentBean
extends BeanNode {
    public PortComponentBean(Node node, DDBean parent) {
        super(node, parent);
        this.init(node);
    }

    public String getDisplayName() {
        return this.nodeValue("display-name");
    }

    public String getDescription() {
        return this.nodeValue("description");
    }

    public String getSmallIcon() {
        return this.nodeValue("icon/small-icon");
    }

    public String getLargeIcon() {
        return this.nodeValue("icon/large-icon");
    }

    public String getPortComponentName() {
        return this.nodeValue("port-component-name");
    }

    public String getServiceEndpointInterface() {
        return this.nodeValue("service-endpoint-interface");
    }

    protected Collection createSpecialJTreeChildren() {
        int j;
        Vector<DDBean> vec = new Vector<DDBean>();
        String childPath = "wsdl-port";
        DDBean[] beans = this.getChildBean(childPath);
        if (beans != null) {
            for (j = 0; j < beans.length; ++j) {
                vec.add(beans[j]);
            }
        }
        if ((beans = this.getChildBean(childPath = "service-impl-bean")) != null) {
            for (j = 0; j < beans.length; ++j) {
                vec.add(beans[j]);
            }
        }
        if ((beans = this.getChildBean(childPath = "handler")) != null) {
            for (j = 0; j < beans.length; ++j) {
                vec.add(beans[j]);
            }
        }
        return vec;
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        out.println(indentation + "<" + "port-component" + ">");
        PortComponentBean.writeAll(this.getChildBean("description"), out, indentation + "\t");
        PortComponentBean.writeAll(this.getChildBean("display-name"), out, indentation + "\t");
        PortComponentBean.writeAll(this.getChildBean("icon"), out, indentation + "\t");
        PortComponentBean.writeAll(this.getChildBean("port-component-name"), out, indentation + "\t");
        out.println(indentation + "</" + "port-component" + ">");
    }

    public String jtreeToolTip() {
        return "Port Component";
    }

    public String toString() {
        String ret = this.getDisplayName();
        if (ret != null && ret.length() > 0) {
            return ret;
        }
        return "Port Component";
    }

    private void init(Node rootNode) {
        this.setXpath("port-component");
        Vector<IconBean> icon = new Vector<IconBean>(1);
        Vector<IconBean> displayName = new Vector<IconBean>(1);
        Vector<IconBean> description = new Vector<IconBean>(1);
        Vector<IconBean> portComponentName = new Vector<IconBean>(1);
        Vector<IconBean> wsdlPort = new Vector<IconBean>(1);
        Vector<IconBean> serviceEndpointInterface = new Vector<IconBean>(1);
        Vector<IconBean> serviceImplBean = new Vector<IconBean>(1);
        Vector<IconBean> handler = new Vector<IconBean>(1);
        NodeList nodes = rootNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            BeanNode bean;
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (name.equals("icon")) {
                bean = new IconBean(node, this);
                icon.add((IconBean)bean);
            }
            if (name.equals("display-name")) {
                bean = new StringBean(node, this, "display-name");
                displayName.add((IconBean)bean);
            }
            if (name.equals("description")) {
                bean = new StringBean(node, this, "description");
                description.add((IconBean)bean);
            }
            if (name.equals("port-component-name")) {
                bean = new StringBean(node, this, "port-component-name");
                portComponentName.add((IconBean)bean);
            }
            if (name.equals("wsdl-port")) {
                bean = new WsdlPortBean(node, this);
                wsdlPort.add((IconBean)bean);
            }
            if (name.equals("service-endpoint-interface")) {
                bean = new StringBean(node, this, "service-endpoint-interface");
                serviceEndpointInterface.add((IconBean)bean);
            }
            if (name.equals("service-impl-bean")) {
                bean = new ServiceImplBeanBean(node, this);
                serviceImplBean.add((IconBean)bean);
            }
            if (!name.equals("handler")) continue;
            bean = new PortComponentHandlerBean(node, this);
            handler.add((IconBean)bean);
        }
        this.recordXpathForBeans("icon", icon);
        this.recordXpathForBeans("display-name", displayName);
        this.recordXpathForBeans("description", description);
        this.recordXpathForBeans("port-component-name", portComponentName);
        this.recordXpathForBeans("wsdl-port", wsdlPort);
        this.recordXpathForBeans("service-endpoint-interface", serviceEndpointInterface);
        this.recordXpathForBeans("service-impl-bean", serviceImplBean);
        this.recordXpathForBeans("handler", handler);
    }
}

