/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.model.xml;

import java.io.PrintWriter;
import java.util.Vector;
import javax.enterprise.deploy.model.DDBean;
import oracle.oc4j.admin.deploy.model.xml.BeanNode;
import oracle.oc4j.admin.deploy.model.xml.StringBean;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServiceImplBeanBean
extends BeanNode {
    public ServiceImplBeanBean(Node node, DDBean parent) {
        super(node, parent);
        this.init(node);
    }

    public String getEjbLink() {
        return this.nodeValue("ejb-link");
    }

    public String getServletLink() {
        return this.nodeValue("servlet-link");
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        out.println(indentation + "<" + "service-impl-bean" + ">");
        ServiceImplBeanBean.writeAll(this.getChildBean("ejb-link"), out, indentation + "\t");
        ServiceImplBeanBean.writeAll(this.getChildBean("servlet-link"), out, indentation + "\t");
        out.println(indentation + "</" + "service-impl-bean" + ">");
    }

    public String jtreeToolTip() {
        return "Service Impl Bean";
    }

    public String toString() {
        return this.getEjbLink();
    }

    private void init(Node rootNode) {
        this.setXpath("service-impl-bean");
        Vector<StringBean> ejbLink = new Vector<StringBean>(1);
        Vector<StringBean> servletLink = new Vector<StringBean>(1);
        NodeList nodes = rootNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            StringBean bean;
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (name.equals("ejb-link")) {
                bean = new StringBean(node, this, "ejb-link");
                ejbLink.add(bean);
            }
            if (!name.equals("servlet-link")) continue;
            bean = new StringBean(node, this, "servlet-link");
            servletLink.add(bean);
        }
        this.recordXpathForBeans("ejb-link", ejbLink);
        this.recordXpathForBeans("servlet-link", servletLink);
    }
}

