/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.model.xml;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Vector;
import javax.enterprise.deploy.model.DDBean;
import oracle.oc4j.admin.deploy.model.xml.BeanNode;
import oracle.oc4j.admin.deploy.model.xml.CollectionJTreeNode;
import oracle.oc4j.admin.deploy.model.xml.IconBean;
import oracle.oc4j.admin.deploy.model.xml.PortComponentHandlerBean;
import oracle.oc4j.admin.deploy.model.xml.PortComponentRefBean;
import oracle.oc4j.admin.deploy.model.xml.ServiceQNameBean;
import oracle.oc4j.admin.deploy.model.xml.StringBean;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServiceRefBean
extends BeanNode {
    public ServiceRefBean(Node node, DDBean parent) {
        super(node, parent);
        this.init(node);
    }

    public String getDisplayName() {
        return this.nodeValue("display-name");
    }

    public String getDescription() {
        return this.nodeValue("description");
    }

    public String getSmallIcon() {
        return this.nodeValue("icon/small-icon");
    }

    public String getLargeIcon() {
        return this.nodeValue("icon/large-icon");
    }

    public String getServiceRefName() {
        return this.nodeValue("service-ref-name");
    }

    public String getServiceInterface() {
        return this.nodeValue("service-interface");
    }

    public String getWsdlFile() {
        return this.nodeValue("wsdl-file");
    }

    public String getJaxrpcMappingFile() {
        return this.nodeValue("jaxrpc-mapping-file");
    }

    protected Collection createSpecialJTreeChildren() {
        Vector<Object> vec = new Vector<Object>();
        DDBean[] beans = this.getChildBean("service-qname");
        if (beans != null) {
            for (int j = 0; j < beans.length; ++j) {
                vec.add(beans[j]);
            }
        }
        String childPath = "port-component-ref";
        vec.add(new CollectionJTreeNode(this, childPath, "Port Component Refs", true));
        childPath = "handler";
        vec.add(new CollectionJTreeNode(this, childPath, "Service Ref Handlers", true));
        return vec;
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        out.println(indentation + "<" + "service-ref" + ">");
        ServiceRefBean.writeAll(this.getChildBean("description"), out, indentation + "\t");
        ServiceRefBean.writeAll(this.getChildBean("display-name"), out, indentation + "\t");
        ServiceRefBean.writeAll(this.getChildBean("icon"), out, indentation + "\t");
        ServiceRefBean.writeAll(this.getChildBean("service-ref-name"), out, indentation + "\t");
        ServiceRefBean.writeAll(this.getChildBean("service-interface"), out, indentation + "\t");
        ServiceRefBean.writeAll(this.getChildBean("wsdl-file"), out, indentation + "\t");
        ServiceRefBean.writeAll(this.getChildBean("jaxrpc-mapping-file"), out, indentation + "\t");
        ServiceRefBean.writeAll(this.getChildBean("service-qname"), out, indentation + "\t");
        out.println(indentation + "</" + "service-ref" + ">");
    }

    public String jtreeToolTip() {
        return "Service Ref";
    }

    public String toString() {
        String ret = this.getDisplayName();
        if (ret != null && ret.length() > 0) {
            return ret;
        }
        return "Service Ref";
    }

    private void init(Node rootNode) {
        this.setXpath("service-ref");
        Vector<IconBean> icon = new Vector<IconBean>(1);
        Vector<IconBean> displayName = new Vector<IconBean>(1);
        Vector<IconBean> description = new Vector<IconBean>(1);
        Vector<IconBean> serviceRefName = new Vector<IconBean>(1);
        Vector<IconBean> serviceInterfaceName = new Vector<IconBean>(1);
        Vector<IconBean> wsdlFileName = new Vector<IconBean>(1);
        Vector<IconBean> jaxrpcMappingFileName = new Vector<IconBean>(1);
        Vector<IconBean> serviceQNameName = new Vector<IconBean>(1);
        Vector<IconBean> portComponentRefs = new Vector<IconBean>(1);
        Vector<IconBean> handlers = new Vector<IconBean>(1);
        NodeList nodes = rootNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            BeanNode bean;
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (name.equals("icon")) {
                bean = new IconBean(node, this);
                icon.add((IconBean)bean);
            }
            if (name.equals("display-name")) {
                bean = new StringBean(node, this, "display-name");
                displayName.add((IconBean)bean);
            }
            if (name.equals("description")) {
                bean = new StringBean(node, this, "description");
                description.add((IconBean)bean);
            }
            if (name.equals("service-ref-name")) {
                bean = new StringBean(node, this, "service-ref-name");
                serviceRefName.add((IconBean)bean);
            }
            if (name.equals("service-interface")) {
                bean = new StringBean(node, this, "service-interface");
                serviceInterfaceName.add((IconBean)bean);
            }
            if (name.equals("wsdl-file")) {
                bean = new StringBean(node, this, "wsdl-file");
                wsdlFileName.add((IconBean)bean);
            }
            if (name.equals("jaxrpc-mapping-file")) {
                bean = new StringBean(node, this, "jaxrpc-mapping-file");
                jaxrpcMappingFileName.add((IconBean)bean);
            }
            if (name.equals("service-qname")) {
                bean = new ServiceQNameBean(node, this);
                serviceQNameName.add((IconBean)bean);
            }
            if (name.equals("port-component-ref")) {
                bean = new PortComponentRefBean(node, this);
                portComponentRefs.add((IconBean)bean);
            }
            if (!name.equals("handler")) continue;
            bean = new PortComponentHandlerBean(node, this);
            handlers.add((IconBean)bean);
        }
        this.recordXpathForBeans("icon", icon);
        this.recordXpathForBeans("display-name", displayName);
        this.recordXpathForBeans("description", description);
        this.recordXpathForBeans("service-ref-name", serviceRefName);
        this.recordXpathForBeans("service-interface", serviceInterfaceName);
        this.recordXpathForBeans("wsdl-file", wsdlFileName);
        this.recordXpathForBeans("jaxrpc-mapping-file", jaxrpcMappingFileName);
        this.recordXpathForBeans("service-qname", serviceQNameName);
        this.recordXpathForBeans("port-component-ref", portComponentRefs);
        this.recordXpathForBeans("handler", handlers);
    }
}

