/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.shell;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.management.ObjectName;
import oracle.oc4j.admin.deploy.shell.AdminShell;
import oracle.oc4j.admin.deploy.shell.InstanceManagerBase;

class InstanceManagerImpl
implements InstanceManagerBase {
    private List arguments = null;

    InstanceManagerImpl() {
    }

    public void restart() {
    }

    public void shutdown() {
    }

    public void handleListApps(List args) throws Exception {
        this.arguments = args;
        int TYPENUM = 5;
        int TITLENUM = 5;
        String[] j2eeType = new String[5];
        j2eeType[0] = "oc4j:j2eeType=J2EEApplication,*";
        j2eeType[1] = "oc4j:j2eeType=EJBModule,*";
        j2eeType[2] = "oc4j:j2eeType=WebModule,*";
        j2eeType[3] = "oc4j:j2eeType=AppClientModule,*";
        String[] title = new String[]{"j2eeType", "name", "JDBCResource", "J2EEApplication", "J2EEServer"};
        System.out.println(title[0] + "              " + title[1] + "                      " + title[2] + "   " + title[3] + "   " + title[4]);
        System.out.println("------------------------------------------------------------------------------------------");
        String type = this.arguments.isEmpty() ? null : AdminShell.getNextArgumentFromShell(this.arguments, "j2ee type");
        try {
            if (type == null || type.equalsIgnoreCase("-all")) {
                for (int i = 0; i < 5; ++i) {
                    Set deployed_apps;
                    if (j2eeType[i] == null || (deployed_apps = AdminShell.getManagement().queryNames(new ObjectName(j2eeType[i]), null)).size() == 0) continue;
                    Iterator iter = deployed_apps.iterator();
                    this.parseAndDisplayType(iter);
                }
            } else {
                String theType = this.parseListOptions(j2eeType, type);
                if (theType != null) {
                    Set deployed_apps = AdminShell.getManagement().queryNames(new ObjectName(theType), null);
                    if (deployed_apps.size() == 0) {
                        System.err.println("No deployed applications or modules found with the type: " + theType);
                    } else {
                        Iterator iter = deployed_apps.iterator();
                        this.parseAndDisplayType(iter);
                    }
                }
            }
        }
        catch (Throwable e) {
            throw new Exception("Error on queryNames: " + e.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String parseListOptions(String[] j2eeType, String type) throws Exception {
        String theType = null;
        String option = null;
        if (type.equalsIgnoreCase("-app")) {
            option = this.arguments.isEmpty() ? null : AdminShell.getNextArgumentFromShell(this.arguments, "j2ee application");
            if (option == null) return j2eeType[0];
            j2eeType[4] = "oc4j:J2EEApplication=" + option + ",*";
            return j2eeType[4];
        }
        if (type.equalsIgnoreCase("-ejb")) {
            return j2eeType[1];
        }
        if (type.equalsIgnoreCase("-web")) {
            return j2eeType[2];
        }
        if (type.equalsIgnoreCase("-appClient")) {
            return j2eeType[3];
        }
        if (type.equalsIgnoreCase("-resource")) {
            try {
                this.listResource();
                return theType;
            }
            catch (Exception e) {
                throw new Exception("Error to list all resources." + e.getMessage());
            }
        } else {
            if (type.equalsIgnoreCase("-JDBCResource")) {
                option = this.arguments.isEmpty() ? null : AdminShell.getNextArgumentFromShell(this.arguments, "JDBC resource");
                if (option == null) throw new Exception("Please specify the JDBCResource name.");
                j2eeType[4] = "oc4j:JDBCResource=" + option + ",*";
                return j2eeType[4];
            }
            System.out.println("Unknown command options. \n");
            System.out.println("Please execute command \"help list\" to get more details on this command.");
        }
        return theType;
    }

    private void parseAndDisplayType(Iterator iter) {
        if (iter == null) {
            return;
        }
        while (iter.hasNext()) {
            String str = iter.next().toString();
            int titleNum = 5;
            String[] content = new String[titleNum];
            String[] a = new String[titleNum];
            String[] b = new String[titleNum];
            int start = 0;
            int end = 0;
            int i = 0;
            String domainName = str.substring(start, str.indexOf(":"));
            str = str.substring(str.indexOf(":") + 1);
            while ((start = str.indexOf("=", start)) >= 0) {
                a[i] = str.substring(0, start);
                end = str.indexOf(",", start);
                if (end < 0) {
                    b[i] = str.substring(start + 1);
                    break;
                }
                b[i] = str.substring(start + 1, end);
                ++i;
                str = str.substring(end + 1);
                start = 0;
            }
            for (i = 0; i < titleNum; ++i) {
                if (a[i] == null) continue;
                if (a[i].equalsIgnoreCase("j2eeType")) {
                    content[0] = b[i];
                    continue;
                }
                if (a[i].equalsIgnoreCase("name")) {
                    content[1] = b[i];
                    continue;
                }
                if (a[i].equalsIgnoreCase("JDBCResource")) {
                    content[2] = b[i];
                    continue;
                }
                if (a[i].equalsIgnoreCase("J2EEApplication")) {
                    content[3] = b[i];
                    continue;
                }
                if (!a[i].equalsIgnoreCase("J2EEServer")) continue;
                content[4] = b[i];
            }
            int column1 = 20;
            int column2 = 32;
            int column3 = 14;
            int column4 = 16;
            for (i = 0; i < titleNum; ++i) {
                System.out.print(content[i]);
                int len = content[i] != null ? (i == 0 ? column1 - content[i].length() : (i == 1 ? column2 - content[i].length() : (i == 2 ? column3 - content[i].length() : (i == 3 ? column4 - content[i].length() : 0)))) : (i == 0 ? column1 - 4 : (i == 1 ? column2 - 4 : (i == 2 ? column3 - 4 : (i == 3 ? column4 - 4 : 0))));
                for (int k = 0; k < len; ++k) {
                    System.out.print(" ");
                }
            }
            System.out.println("");
        }
    }

    private void listResource() throws Exception {
        int RESOURCETYPE = 4;
        String[] theType = new String[]{"oc4j:j2eeType=JavaMailResource,*", "oc4j:j2eeType=JDBCResource,*", "oc4j:j2eeType=JMSResource,*", "oc4j:j2eeType=URLResource,*"};
        try {
            for (int i = 0; i < 4; ++i) {
                Set deployed_apps = AdminShell.getManagement().queryNames(new ObjectName(theType[i]), null);
                if (deployed_apps.size() == 0) continue;
                Iterator iter = deployed_apps.iterator();
                this.parseAndDisplayType(iter);
            }
        }
        catch (Throwable e) {
            throw new Exception("Error: " + e.getMessage());
        }
    }
}

