/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;
import javax.management.j2ee.Management;
import oracle.ias.opmn.optic.OpmnConn;
import oracle.ias.opmn.optic.OpmnProcess;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.admin.deploy.spi.ClusterJVMInfoImpl;
import oracle.oc4j.admin.deploy.spi.JDBCDriverInfo;
import oracle.oc4j.admin.deploy.spi.JDBCDriverInfoImpl;
import oracle.oc4j.admin.deploy.spi.JMSInfo;
import oracle.oc4j.admin.deploy.spi.JMSInfoImpl;
import oracle.oc4j.admin.deploy.spi.JVMInfo;
import oracle.oc4j.admin.deploy.spi.JVMInfoImpl;
import oracle.oc4j.admin.deploy.spi.ProprietaryTarget;
import oracle.oc4j.admin.jmx.client.CoreRemoteMBeanServer;
import oracle.oc4j.admin.jmx.shared.ClusterDomain;
import oracle.oc4j.admin.jmx.shared.Domain;
import oracle.oc4j.admin.jmx.shared.Oc4jOpmnRmiDomain;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXRuntimeException;
import oracle.oc4j.admin.jmx.shared.util.ObjectNameFactory;
import oracle.oc4j.admin.management.mejb.MEjbFactory;
import oracle.oc4j.admin.management.shared.InstalledLibrary;
import oracle.oc4j.admin.management.shared.SharedLibrary;

public class TargetImpl
implements ProprietaryTarget {
    private static Logger logger_ = TraceLogger.getLogger((Class)TargetImpl.class);
    private Management mejb_ = null;
    private ObjectName targetName_ = null;

    public TargetImpl(Management mejb, ObjectName targetName) {
        this.mejb_ = mejb;
        this.targetName_ = targetName;
    }

    public String getName() {
        return this.targetName_.getKeyProperty("name");
    }

    public String getDefaultApplication() {
        try {
            ObjectName defaultApp = (ObjectName)this.mejb_.getAttribute(this.targetName_, "defaultApplication");
            if (defaultApp == null) {
                return null;
            }
            return defaultApp.getKeyProperty("name");
        }
        catch (Exception e) {
            throw new JMXRuntimeException(e);
        }
    }

    public ObjectName getObjectName() {
        return this.targetName_;
    }

    public String getDescription() {
        return "Target instance representing the J2EEServer named: " + this.getName() + " within the " + this.targetName_.getDomain() + " domain";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TargetImpl)) {
            return false;
        }
        return this.targetName_.equals(((TargetImpl)obj).targetName_);
    }

    public int hashCode() {
        return this.targetName_.hashCode();
    }

    public String toString() {
        return this.targetName_.toString();
    }

    public final long getStartTime() {
        try {
            Long startTime = (Long)this.mejb_.getAttribute(this.targetName_, "startTime");
            return startTime;
        }
        catch (Exception e) {
            throw new JMXRuntimeException(e);
        }
    }

    public final int getState() {
        try {
            Integer state = (Integer)this.mejb_.getAttribute(this.targetName_, "state");
            return state;
        }
        catch (Exception e) {
            throw new JMXRuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final JVMInfo[] getJVMs() {
        ArrayList<ClusterJVMInfoImpl> res = new ArrayList<ClusterJVMInfoImpl>();
        if (((CoreRemoteMBeanServer)this.mejb_).getDomain() instanceof ClusterDomain) {
            Domain[] syncDoms;
            ClusterDomain clustDom = (ClusterDomain)((Object)((CoreRemoteMBeanServer)this.mejb_).getDomain());
            Domain[] syncDomsOnly = clustDom.getSynchronizationDomains(((CoreRemoteMBeanServer)this.mejb_).portInUse());
            if (syncDomsOnly != null && syncDomsOnly.length != 0) {
                syncDoms = new Domain[syncDomsOnly.length + 1];
                for (int syncnt = 0; syncnt < syncDomsOnly.length; ++syncnt) {
                    syncDoms[syncnt] = syncDomsOnly[syncnt];
                }
                syncDoms[syncDomsOnly.length] = ((CoreRemoteMBeanServer)this.mejb_).getDomain();
            } else {
                syncDoms = new Domain[]{((CoreRemoteMBeanServer)this.mejb_).getDomain()};
            }
            List oc4jProcs = null;
            if (clustDom instanceof Oc4jOpmnRmiDomain) {
                oc4jProcs = ((Oc4jOpmnRmiDomain)clustDom).getOc4jProcs();
            }
            if (syncDoms != null && syncDoms.length != 0) {
                for (int i = 0; i < syncDoms.length; ++i) {
                    Throwable te2;
                    Object var19_27;
                    Management mejb = null;
                    try {
                        mejb = MEjbFactory.getManagement(syncDoms[i]);
                        ObjectName[] jvms = null;
                        try {
                            jvms = (ObjectName[])mejb.getAttribute(this.targetName_, "JavaVMs");
                        }
                        catch (Exception e) {
                            throw new JMXRuntimeException(e);
                        }
                        for (int ii = 0; ii < jvms.length; ++ii) {
                            JVMInfoImpl inf = new JVMInfoImpl(mejb, jvms[ii]);
                            if (oc4jProcs == null || oc4jProcs.size() == 0) {
                                res.add(new ClusterJVMInfoImpl(inf));
                                continue;
                            }
                            String pid = null;
                            Iterator it = oc4jProcs.iterator();
                            while (it.hasNext()) {
                                OpmnProcess choosenProc = (OpmnProcess)it.next();
                                List conList = choosenProc.getConnList();
                                Iterator itc = conList.iterator();
                                int prt = -1;
                                while (itc.hasNext()) {
                                    OpmnConn con = (OpmnConn)itc.next();
                                    if (!"rmi".equals(con.getType())) continue;
                                    prt = Integer.parseInt(con.getPort());
                                    break;
                                }
                                if (prt != inf.getRMIPort()) continue;
                                pid = choosenProc.getPid();
                                break;
                            }
                            if (pid != null) {
                                res.add(new ClusterJVMInfoImpl(inf, pid));
                                continue;
                            }
                            res.add(new ClusterJVMInfoImpl(inf));
                        }
                        var19_27 = null;
                        if (mejb == null) continue;
                    }
                    catch (Throwable throwable) {
                        block24: {
                            var19_27 = null;
                            if (mejb != null) {
                                try {
                                    mejb.remove();
                                }
                                catch (Throwable te2) {
                                    if (!logger_.isLoggable(Level.FINE)) break block24;
                                    logger_.log(Level.FINE, te2.getMessage(), te2);
                                }
                            }
                        }
                        throw throwable;
                    }
                    try {
                        mejb.remove();
                    }
                    catch (Throwable te2) {
                        if (!logger_.isLoggable(Level.FINE)) continue;
                        logger_.log(Level.FINE, te2.getMessage(), te2);
                    }
                }
            }
            Iterator it = res.iterator();
            int cnt = 0;
            JVMInfo[] jvmInfs = new JVMInfo[res.size()];
            while (it.hasNext()) {
                jvmInfs[cnt++] = (JVMInfo)it.next();
            }
            return jvmInfs;
        }
        ObjectName[] jvms = null;
        try {
            jvms = (ObjectName[])this.mejb_.getAttribute(this.targetName_, "JavaVMs");
        }
        catch (Exception e) {
            throw new JMXRuntimeException(e);
        }
        JVMInfo[] jvmInfs = new JVMInfo[jvms.length];
        for (int i = 0; i < jvms.length; ++i) {
            JVMInfoImpl inf = new JVMInfoImpl(this.mejb_, jvms[i]);
            jvmInfs[i] = inf;
        }
        return jvmInfs;
    }

    public final JMSInfo[] getJMSResources() {
        String serverName = this.targetName_.getKeyProperty("name");
        String domain = this.targetName_.getDomain();
        String searchPattern = domain + ":j2eeType=JMSDestinationResource,J2EEServer=" + serverName + ",*";
        try {
            ObjectName targetPattern = ObjectNameFactory.create(searchPattern);
            Set targets = this.mejb_.queryNames(targetPattern, null);
            JMSInfo[] jmsInf = new JMSInfo[targets.size()];
            Iterator iter = targets.iterator();
            int targetCount = 0;
            while (iter.hasNext()) {
                jmsInf[targetCount++] = new JMSInfoImpl(this.mejb_, (ObjectName)iter.next());
            }
            return jmsInf;
        }
        catch (Exception e) {
            throw new JMXRuntimeException(e);
        }
    }

    public JDBCDriverInfo[] getJDBCDrivers() {
        String serverName = this.targetName_.getKeyProperty("name");
        String domain = this.targetName_.getDomain();
        String searchPattern = domain + ":j2eeType=JDBCDriver,J2EEServer=" + serverName + ",*";
        try {
            ObjectName targetPattern = ObjectNameFactory.create(searchPattern);
            Set targets = this.mejb_.queryNames(targetPattern, null);
            JDBCDriverInfo[] driverInf = new JDBCDriverInfo[targets.size()];
            Iterator iter = targets.iterator();
            int targetCount = 0;
            while (iter.hasNext()) {
                driverInf[targetCount++] = new JDBCDriverInfoImpl(this.mejb_, (ObjectName)iter.next());
            }
            return driverInf;
        }
        catch (Exception e) {
            throw new JMXRuntimeException(e);
        }
    }

    public InstalledLibrary[] getInstalledLibraries() {
        try {
            return (InstalledLibrary[])this.mejb_.getAttribute(this.targetName_, "installedLibraries");
        }
        catch (Exception e) {
            throw new JMXRuntimeException(e);
        }
    }

    public SharedLibrary[] getSharedLibraries() {
        try {
            return (SharedLibrary[])this.mejb_.getAttribute(this.targetName_, "sharedLibraries");
        }
        catch (Exception e) {
            throw new JMXRuntimeException(e);
        }
    }

    public void removeSharedLibrary(String libraryName, String libraryVersion) {
        try {
            Object[] params = new Object[]{libraryName, libraryVersion};
            String[] sigs = new String[]{"java.lang.String", "java.lang.String"};
            this.mejb_.invoke(this.targetName_, "removeSharedLibrary", params, sigs);
        }
        catch (Exception e) {
            throw new JMXRuntimeException(e);
        }
    }

    public boolean instantiateSharedLibrary(String libraryName, String libraryVersion) {
        try {
            Object[] params = new Object[]{libraryName, libraryVersion};
            String[] sigs = new String[]{"java.lang.String", "java.lang.String"};
            Boolean ret = (Boolean)this.mejb_.invoke(this.targetName_, "instantiateSharedLibrary", params, sigs);
            return ret;
        }
        catch (Exception e) {
            throw new JMXRuntimeException(e);
        }
    }

    public void addWebSite(String name, String protocol, int port, String keystorePath, String keystorePassword, String sslProvider) {
        try {
            Object[] params = new Object[]{name, protocol, new Integer(port), keystorePath, keystorePassword, sslProvider};
            String[] sigs = new String[]{"java.lang.String", "java.lang.String", Integer.TYPE.getName(), "java.lang.String", "java.lang.String", "java.lang.String"};
            this.mejb_.invoke(this.targetName_, "addWebSite", params, sigs);
        }
        catch (Exception e) {
            throw new JMXRuntimeException(e);
        }
    }
}

