/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import java.util.Vector;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ArgumentType;
import oracle.oc4j.admin.deploy.spi.xml.BooleanType;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CarInvocationMappingsType
extends ConfigBeanNode {
    protected String _path = null;
    protected BooleanType _autoStart = null;
    protected BooleanType _oldAutoStart = null;
    protected String _user = null;
    protected ArgumentType[] _arguments = null;

    public CarInvocationMappingsType(ConfigBeanNode parent) throws ConfigurationException {
        this(parent, (Node)null);
    }

    public CarInvocationMappingsType(ConfigBeanNode parent, Node node) throws ConfigurationException {
        super(null, parent, node);
        this.init();
    }

    public CarInvocationMappingsType(ConfigBeanNode parent, String path) throws ConfigurationException {
        this(parent);
        this._path = path;
    }

    public void setAutoStart(BooleanType autoStart) throws ConfigurationException {
        this._autoStart = autoStart;
        this.firePropertyChange("autoStart", this._oldAutoStart, this._autoStart);
        if (this._autoStart != null) {
            if (this._oldAutoStart == null) {
                this._oldAutoStart = this.defaultAutoStart();
            }
            this._oldAutoStart.setValue(this._autoStart.getValue());
        } else {
            this._oldAutoStart = null;
        }
    }

    public BooleanType getAutoStart() {
        return this._autoStart;
    }

    public BooleanType defaultAutoStart() {
        try {
            return new BooleanType(this, "false");
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void setUser(String user) throws ConfigurationException {
        String oldValue = this._user;
        this._user = user;
        this.firePropertyChange("user", oldValue, this._user);
    }

    public String getUser() {
        return this._user;
    }

    public String defaultUser() {
        return "";
    }

    public void setArguments(ArgumentType[] arguments) throws ConfigurationException {
        ArgumentType[] oldValue = this._arguments;
        this._arguments = arguments;
        this.firePropertyChange("arguments", oldValue, this._arguments);
    }

    public ArgumentType[] getArguments() {
        return this._arguments;
    }

    public ArgumentType[] defaultArguments() {
        return new ArgumentType[0];
    }

    public void addArguments() throws ConfigurationException {
        if (this._arguments != null) {
            return;
        }
        ArgumentType[] arguments = new ArgumentType[]{new ArgumentType(this, null)};
        this.setArguments(arguments);
    }

    public void removeArguments() throws ConfigurationException {
        if (this._arguments == null) {
            return;
        }
        this.setArguments(null);
    }

    public void addArgument(ArgumentType argument) throws ConfigurationException {
        argument.setParent(this);
        int existingArgumentsCnt = 0;
        if (this._arguments != null) {
            existingArgumentsCnt = this._arguments.length;
        }
        ArgumentType[] newArguments = new ArgumentType[existingArgumentsCnt + 1];
        for (int n = 0; n < existingArgumentsCnt; ++n) {
            newArguments[n] = this._arguments[n];
        }
        newArguments[existingArgumentsCnt] = argument;
        ArgumentType[] oldValue = this._arguments;
        this._arguments = newArguments;
        this.firePropertyChange("arguments", oldValue, this._arguments);
    }

    public void removeArgument(ArgumentType argument) throws ConfigurationException {
        int existingArgumentsCnt = 0;
        if (this._arguments != null) {
            existingArgumentsCnt = this._arguments.length;
        }
        ArgumentType[] newArguments = new ArgumentType[existingArgumentsCnt - 1];
        int newIndex = 0;
        for (int n = 0; n < existingArgumentsCnt; ++n) {
            if (argument.equals(this._arguments[n])) continue;
            newArguments[newIndex++] = this._arguments[n];
        }
        if (newArguments.length == 0) {
            newArguments = null;
        }
        ArgumentType[] oldValue = this._arguments;
        this._arguments = newArguments;
        this.firePropertyChange("arguments", oldValue, this._arguments);
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagAttributeStart(out, indentation, "client-module");
        XMLUtils.writeAttribute(out, indentation, "path", this._path);
        XMLUtils.writeAttribute(out, indentation, "auto-start", this._autoStart);
        XMLUtils.writeAttribute(out, indentation, "user", this._user);
        XMLUtils.writeTagAttributeEnd(out, indentation, "client-module");
        ArgumentType.writeXML(out, indentation + "\t", this._arguments);
        XMLUtils.writeTagEnd(out, indentation, "client-module");
    }

    public void writeArgumentsXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        ArgumentType.writeXML(out, indentation, this._arguments);
    }

    private void init() throws ConfigurationException {
        this.setXpath("/orion-application/client-module");
        Vector<ArgumentType> arguments = new Vector<ArgumentType>();
        if (this.getNode() != null) {
            String val = null;
            Node node = this.getNode();
            val = XMLUtils.getAttribute(node, "path");
            if (val != null && !val.trim().equals("")) {
                this._path = val;
            }
            if ((val = XMLUtils.getAttribute(node, "auto-start")) != null && !val.trim().equals("")) {
                BooleanType autoStart = this.defaultAutoStart();
                autoStart.setValue(val);
                this.setAutoStart(autoStart);
            }
            if ((val = XMLUtils.getAttribute(node, "user")) != null && !val.trim().equals("")) {
                this._user = val;
            }
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                String name = node.getNodeName();
                if (!name.equals("arguments")) continue;
                NodeList argNodes = node.getChildNodes();
                for (int n = 0; n < argNodes.getLength(); ++n) {
                    Node argNode = argNodes.item(n);
                    name = argNode.getNodeName();
                    if (!name.equals("argument")) continue;
                    ArgumentType arg = new ArgumentType(this, argNode);
                    arguments.add(arg);
                }
            }
        }
        if (arguments.size() > 0) {
            this.setArguments(arguments.toArray(new ArgumentType[0]));
        }
    }
}

