/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.xml.AuditingTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.AuditingType;
import oracle.oc4j.admin.deploy.spi.xml.ClientOperationRuntimeType;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.ReliabilityClientOperationTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.ReliabilityClientOperationType;
import oracle.oc4j.admin.deploy.spi.xml.SecurityOperationConfigType;
import oracle.oc4j.admin.deploy.spi.xml.SecurityOperationTreeNode;

public class ClientOperationRuntimeTreeNode
extends ConfigTreeNode
implements ActionListener {
    private ClientOperationRuntimeType _bean;
    private static final String ADD_SECURITY_MENU_STRING = "Add Security";
    private static final String ADD_AUDITING_MENU_STRING = "Add Auditing";
    private static final String ADD_RELIABILITY_MENU_STRING = "Add Reliability";
    private static final String REMOVE_RUNTIME_MENU_STRING = "Remove Runtime";
    private JMenuItem _addSecurityMenuItem;
    private JMenuItem _addAuditingMenuItem;
    private JMenuItem _addReliabilityMenuItem;
    private JMenuItem _removeRuntimeMenuItem;

    public ClientOperationRuntimeTreeNode(ConfigTreeNode rootNode, ConfigBeanNode bean) {
        super(bean);
        this.setRootNode(rootNode);
        this._bean = (ClientOperationRuntimeType)bean;
        this._addSecurityMenuItem = new JMenuItem(ADD_SECURITY_MENU_STRING);
        this._addSecurityMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addSecurityMenuItem.setFont(ClientOperationRuntimeTreeNode.getFont());
        this._addSecurityMenuItem.addActionListener(this);
        if (this._bean.getSecurity() != null) {
            this._addSecurityMenuItem.setEnabled(false);
        }
        this._addAuditingMenuItem = new JMenuItem(ADD_AUDITING_MENU_STRING);
        this._addAuditingMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addAuditingMenuItem.setFont(ClientOperationRuntimeTreeNode.getFont());
        this._addAuditingMenuItem.addActionListener(this);
        if (this._bean.getAuditing() != null) {
            this._addAuditingMenuItem.setEnabled(false);
        }
        this._addReliabilityMenuItem = new JMenuItem(ADD_RELIABILITY_MENU_STRING);
        this._addReliabilityMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addReliabilityMenuItem.setFont(ClientOperationRuntimeTreeNode.getFont());
        this._addReliabilityMenuItem.addActionListener(this);
        if (this._bean.getReliability() != null) {
            this._addReliabilityMenuItem.setEnabled(false);
        }
        this._removeRuntimeMenuItem = new JMenuItem(REMOVE_RUNTIME_MENU_STRING);
        this._removeRuntimeMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._removeRuntimeMenuItem.setFont(ClientOperationRuntimeTreeNode.getFont());
        this._removeRuntimeMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addSecurityMenuItem);
        this._popup.add(this._addAuditingMenuItem);
        this._popup.add(this._addReliabilityMenuItem);
        this._popup.add(this._removeRuntimeMenuItem);
    }

    public String viewHeaderString() {
        return "Runtime";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        try {
            SecurityOperationConfigType security = this._bean.getSecurity();
            if (security != null) {
                SecurityOperationTreeNode securityOperationTreeNode = new SecurityOperationTreeNode(this.getRootNode(), security);
                this.addChild(securityOperationTreeNode);
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
        try {
            AuditingType auditing = this._bean.getAuditing();
            if (auditing != null) {
                AuditingTreeNode auditingTreeNode = new AuditingTreeNode(this.getRootNode(), auditing);
                this.addChild(auditingTreeNode);
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
        try {
            ReliabilityClientOperationType reliability = this._bean.getReliability();
            if (reliability != null) {
                ReliabilityClientOperationTreeNode reliabilityClientOperationTreeNode = new ReliabilityClientOperationTreeNode(this.getRootNode(), reliability);
                this.addChild(reliabilityClientOperationTreeNode);
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getActionCommand().equals(ADD_SECURITY_MENU_STRING)) {
                if (this._bean.getSecurity() == null) {
                    this._bean.addSecurity();
                    SecurityOperationTreeNode newNode = new SecurityOperationTreeNode(this, this._bean.getSecurity());
                    this.insertNode(newNode);
                    this._addSecurityMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(ADD_AUDITING_MENU_STRING)) {
                AuditingType newAuditing;
                if (this._bean.getAuditing() == null && this.showAddDialog(newAuditing = this._bean.defaultAuditing(), ADD_AUDITING_MENU_STRING)) {
                    this._bean.setAuditing(newAuditing);
                    AuditingTreeNode newNode = new AuditingTreeNode(this, newAuditing);
                    this.insertNode(newNode);
                    this._addAuditingMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(ADD_RELIABILITY_MENU_STRING)) {
                ReliabilityClientOperationType newReliability;
                if (this._bean.getReliability() == null && this.showAddDialog(newReliability = this._bean.defaultReliability(), ADD_RELIABILITY_MENU_STRING)) {
                    this._bean.setReliability(newReliability);
                    ReliabilityClientOperationTreeNode newNode = new ReliabilityClientOperationTreeNode(this, newReliability);
                    this.insertNode(newNode);
                    this._addReliabilityMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(REMOVE_RUNTIME_MENU_STRING) && this.confirmRemove()) {
                this.getParentNode().remove(this);
            }
        }
        catch (Throwable ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof SecurityOperationTreeNode) {
            this._bean.removeSecurity();
            this.removeNode(node);
            this._addSecurityMenuItem.setEnabled(true);
        } else if (node instanceof AuditingTreeNode) {
            this._bean.removeAuditing();
            this.removeNode(node);
            this._addAuditingMenuItem.setEnabled(true);
        } else if (node instanceof ReliabilityClientOperationTreeNode) {
            this._bean.removeReliability();
            this.removeNode(node);
            this._addReliabilityMenuItem.setEnabled(true);
        }
    }
}

