/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.EncryptElementsConfigType;
import oracle.oc4j.admin.deploy.spi.xml.TbeElementTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.TbeElementType;

public class EncryptElementsTreeNode
extends ConfigTreeNode
implements ActionListener {
    private EncryptElementsConfigType _bean;
    private static final String ADD_TBE_ELEMENT_MENU_STRING = "Add Tbe Element";
    private static final String REMOVE_TBE_ELEMENTS_MENU_STRING = "Remove Tbe Elements";
    private JMenuItem _addTbeElementMenuItem;
    private JMenuItem _removeTbeElementsMenuItem;

    public EncryptElementsTreeNode(ConfigTreeNode rootNode, EncryptElementsConfigType tbeElements) {
        super(tbeElements);
        this.setRootNode(rootNode);
        this._bean = tbeElements;
        this._addTbeElementMenuItem = new JMenuItem(ADD_TBE_ELEMENT_MENU_STRING);
        this._addTbeElementMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addTbeElementMenuItem.setFont(EncryptElementsTreeNode.getFont());
        this._addTbeElementMenuItem.addActionListener(this);
        this._removeTbeElementsMenuItem = new JMenuItem(REMOVE_TBE_ELEMENTS_MENU_STRING);
        this._removeTbeElementsMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._removeTbeElementsMenuItem.setFont(EncryptElementsTreeNode.getFont());
        this._removeTbeElementsMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addTbeElementMenuItem);
        this._popup.add(this._removeTbeElementsMenuItem);
    }

    public String viewHeaderString() {
        return "Tbe Elements";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        TbeElementType[] tbeElements = this._bean.getTbeElements();
        if (tbeElements != null) {
            for (int i = 0; i < tbeElements.length; ++i) {
                TbeElementType tbeElement = tbeElements[i];
                if (tbeElement == null) continue;
                TbeElementTreeNode tbeElementTreeNode = new TbeElementTreeNode(this.getRootNode(), tbeElement);
                this.addChild(tbeElementTreeNode);
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getActionCommand().equals(ADD_TBE_ELEMENT_MENU_STRING)) {
                TbeElementType newTbeElement = new TbeElementType(this._bean);
                if (this.showAddDialog(newTbeElement, ADD_TBE_ELEMENT_MENU_STRING)) {
                    this._bean.addTbeElement(newTbeElement);
                    TbeElementTreeNode newNode = new TbeElementTreeNode(this, newTbeElement);
                    this.insertNode(newNode);
                }
            } else if (event.getActionCommand().equals(REMOVE_TBE_ELEMENTS_MENU_STRING) && this.confirmRemove()) {
                this.getParentNode().remove(this);
            }
        }
        catch (Throwable ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof TbeElementTreeNode) {
            TbeElementType tbeElement = (TbeElementType)node.getConfigBeanNode();
            this._bean.removeTbeElement(tbeElement);
            this.removeNode(node);
        }
    }
}

